/*
 * Decompiled with CFR 0.152.
 */
package geo.google;

import geo.google.GeoException;
import geo.google.datamodel.GeoAddress;
import geo.google.datamodel.GeoCoordinate;
import geo.google.datamodel.GeoUsAddress;
import geo.google.mapping.MappingUtils;
import geo.google.mapping.XmlMappingFunctor;
import geo.google.mapping.XmlToAddressFunctor;
import geo.google.mapping.XmlToUsAddressFunctor;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpURL;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.io.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeoAddressStandardizer {
    private static final String BASE_URL = "http://maps.google.com/maps/geo?q={0}&output={1}&key={2}";
    private static final String XML = "xml";
    private static final String CSV = "csv";
    private String _apiKey;
    private long _rateLimitInterval = 5769L;
    private long _lastRequestTime = System.currentTimeMillis() - this._rateLimitInterval;
    private HttpClientParams _httpClientParams = null;
    private static HttpConnectionManager _connectionManager = new MultiThreadedHttpConnectionManager();
    private static HttpClient _httpClient = new HttpClient(_connectionManager);

    public static synchronized void setConnectionManager(HttpConnectionManager manager) {
        _connectionManager = manager;
        _httpClient = new HttpClient(_connectionManager);
    }

    public static synchronized void setHttpClient(HttpClient client) {
        _httpClient = client;
    }

    public HttpClientParams getHttpClientParams() {
        return this._httpClientParams;
    }

    public void setHttpClientParams(HttpClientParams httpClientParams) {
        this._httpClientParams = httpClientParams;
        if (this._httpClientParams != null && _httpClient != null) {
            _httpClient.setParams(this._httpClientParams);
        }
    }

    public GeoAddressStandardizer(String apiKey) {
        this._apiKey = apiKey;
    }

    public GeoAddressStandardizer(String apiKey, long rateIntervalInMillis) {
        this(apiKey);
        if (rateIntervalInMillis < 0L) {
            throw new IllegalArgumentException("rateInterval cannot be negative");
        }
        this._rateLimitInterval = rateIntervalInMillis;
    }

    public GeoAddress standardizeToGeoAddress(GeoUsAddress usAddress) throws GeoException {
        return this.standardizeToGeoAddress(usAddress.toAddressLine());
    }

    public GeoUsAddress standardizeToGeoUsAddress(GeoUsAddress usAddress) throws GeoException {
        return this.standardizeToGeoUsAddress(usAddress.toAddressLine());
    }

    public GeoAddress standardizeToGeoAddress(String addressLine) throws GeoException {
        List<GeoAddress> ret = this.standardize(addressLine, XmlToAddressFunctor.getInstance());
        return CollectionUtils.isEmpty(ret) ? null : ret.get(0);
    }

    public GeoUsAddress standardizeToGeoUsAddress(String addressLine) throws GeoException {
        List<GeoUsAddress> ret = this.standardize(addressLine, XmlToUsAddressFunctor.getInstance());
        return CollectionUtils.isEmpty(ret) ? null : ret.get(0);
    }

    public List<GeoUsAddress> standardizeToGeoUsAddresses(String addressLine) throws GeoException {
        return this.standardize(addressLine, XmlToUsAddressFunctor.getInstance());
    }

    public List<GeoAddress> standardizeToGeoAddresses(String addressLine) throws GeoException {
        return this.standardize(addressLine, XmlToAddressFunctor.getInstance());
    }

    public List<GeoUsAddress> standardizeToGeoUsAddresses(GeoUsAddress usAddress) throws GeoException {
        return this.standardize(usAddress.toAddressLine(), XmlToUsAddressFunctor.getInstance());
    }

    public List<GeoAddress> standardizeToGeoAddresses(GeoUsAddress usAddress) throws GeoException {
        return this.standardize(usAddress.toAddressLine(), XmlToAddressFunctor.getInstance());
    }

    public GeoCoordinate standardizeToGeoCoordinate(String addressLine) throws GeoException {
        try {
            HttpURL url = new HttpURL(MessageFormat.format(BASE_URL, addressLine, CSV, this._apiKey));
            String res = this.getServerResponse(url.toString());
            return MappingUtils.stringToCoordinate(res);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (GeoException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GeoException(e.getMessage());
        }
    }

    public <ReturnType> ReturnType standardize(String addressLine, XmlMappingFunctor<ReturnType> mappingFunction) throws GeoException {
        try {
            HttpURL url = new HttpURL(MessageFormat.format(BASE_URL, addressLine, XML, this._apiKey));
            String res = this.getServerResponse(url.toString());
            return mappingFunction.execute(res);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (GeoException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GeoException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized String getServerResponse(String url) throws Exception {
        GetMethod get = null;
        try {
            long timeTilNextStart = this._rateLimitInterval - (System.currentTimeMillis() - this._lastRequestTime);
            if (timeTilNextStart > 0L) {
                Thread.sleep(timeTilNextStart);
            }
            this._lastRequestTime = System.currentTimeMillis();
            get = new GetMethod(url);
            get.setFollowRedirects(true);
            _httpClient.executeMethod((HttpMethod)get);
            String string = IOUtils.toString((InputStream)get.getResponseBodyAsStream(), (String)get.getRequestCharSet());
            return string;
        }
        finally {
            if (get != null) {
                get.releaseConnection();
            }
        }
    }

    public String getApiKey() {
        return this._apiKey;
    }

    public void setApiKey(String apiKey) {
        this._apiKey = apiKey;
    }

    public long getRateLimitInterval() {
        return this._rateLimitInterval;
    }

    public void setRateLimitInterval(long rateLimitInterval) {
        this._rateLimitInterval = rateLimitInterval;
    }
}

