/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rrd;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.rrd.RrdDataSource;
import org.opennms.netmgt.rrd.RrdException;
import org.opennms.netmgt.rrd.RrdStrategy;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RrdUtils {
    private static RrdStrategy m_rrdStrategy = null;
    private static BeanFactory m_context = new ClassPathXmlApplicationContext(new String[]{"org/opennms/netmgt/rrd/rrd-configuration.xml"});

    public static RrdStrategy getStrategy() {
        RrdStrategy retval = null;
        retval = m_rrdStrategy == null ? (((Boolean)m_context.getBean("useQueue")).booleanValue() ? (((Boolean)m_context.getBean("useTcp")).booleanValue() ? (RrdStrategy)m_context.getBean(StrategyName.tcpAndQueuingRrdStrategy.toString()) : (RrdStrategy)m_context.getBean(StrategyName.queuingRrdStrategy.toString())) : (((Boolean)m_context.getBean("useTcp")).booleanValue() ? (RrdStrategy)m_context.getBean(StrategyName.tcpAndBasicRrdStrategy.toString()) : (RrdStrategy)m_context.getBean(StrategyName.basicRrdStrategy.toString()))) : m_rrdStrategy;
        if (retval == null) {
            throw new IllegalStateException("RrdUtils not initialized");
        }
        return retval;
    }

    public static RrdStrategy getSpecificStrategy(StrategyName strategy) {
        RrdStrategy retval = null;
        retval = (RrdStrategy)m_context.getBean(strategy.toString());
        if (retval == null) {
            throw new IllegalStateException("RrdUtils not initialized");
        }
        return retval;
    }

    public static void setStrategy(RrdStrategy strategy) {
        m_rrdStrategy = strategy;
    }

    public static boolean createRRD(String creator, String directory, String dsName, int step, String dsType, int dsHeartbeat, String dsMin, String dsMax, List<String> rraList) throws RrdException {
        return RrdUtils.createRRD(creator, directory, dsName, step, Collections.singletonList(new RrdDataSource(dsName, dsType, dsHeartbeat, dsMin, dsMax)), rraList);
    }

    public static boolean createRRD(String creator, String directory, String rrdName, int step, List<RrdDataSource> dataSources, List<String> rraList) throws RrdException {
        String fileName = rrdName + RrdUtils.getExtension();
        String completePath = directory + File.separator + fileName;
        RrdUtils.log().info("createRRD: creating RRD file " + completePath);
        try {
            Object def = RrdUtils.getStrategy().createDefinition(creator, directory, rrdName, step, dataSources, rraList);
            RrdUtils.getStrategy().createFile(def);
            return true;
        }
        catch (Exception e) {
            RrdUtils.log().error("createRRD: An error occured creating rrdfile " + completePath + ": " + e, (Throwable)e);
            throw new RrdException("An error occured creating rrdfile " + completePath + ": " + e, e);
        }
    }

    private static ThreadCategory log() {
        return ThreadCategory.getInstance(RrdUtils.class);
    }

    public static void updateRRD(String owner, String repositoryDir, String rrdName, String val) throws RrdException {
        RrdUtils.updateRRD(owner, repositoryDir, rrdName, System.currentTimeMillis(), val);
    }

    public static void updateRRD(String owner, String repositoryDir, String rrdName, long timestamp, String val) throws RrdException {
        String rrdFile = repositoryDir + File.separator + rrdName + RrdUtils.getExtension();
        long time = (timestamp + 500L) / 1000L;
        String updateVal = Long.toString(time) + ":" + val;
        RrdUtils.log().info("updateRRD: updating RRD file " + rrdFile + " with values '" + updateVal + "'");
        Object rrd = null;
        try {
            rrd = RrdUtils.getStrategy().openFile(rrdFile);
            RrdUtils.getStrategy().updateFile(rrd, owner, updateVal);
        }
        catch (Exception e) {
            RrdUtils.log().error("updateRRD: Error updating RRD file " + rrdFile + " with values '" + updateVal + "': " + e, (Throwable)e);
            throw new RrdException("Error updating RRD file " + rrdFile + " with values '" + updateVal + "': " + e, e);
        }
        finally {
            try {
                if (rrd != null) {
                    RrdUtils.getStrategy().closeFile(rrd);
                }
            }
            catch (Exception e) {
                RrdUtils.log().error("updateRRD: Exception closing RRD file " + rrdFile + ": " + e, (Throwable)e);
                throw new RrdException("Exception closing RRD file " + rrdFile + ": " + e, e);
            }
        }
        if (RrdUtils.log().isDebugEnabled()) {
            RrdUtils.log().debug("updateRRD: RRD update command completed.");
        }
    }

    public static Double fetchLastValue(String rrdFile, String ds, int interval) throws NumberFormatException, RrdException {
        return RrdUtils.getStrategy().fetchLastValue(rrdFile, ds, interval);
    }

    public static Double fetchLastValueInRange(String rrdFile, String ds, int interval, int range) throws NumberFormatException, RrdException {
        return RrdUtils.getStrategy().fetchLastValueInRange(rrdFile, ds, interval, range);
    }

    public static InputStream createGraph(String command, File workDir) throws IOException, RrdException {
        return RrdUtils.getStrategy().createGraph(command, workDir);
    }

    public static String getExtension() {
        String rrdExtension = (String)m_context.getBean("rrdFileExtension");
        if (rrdExtension == null || "".equals(rrdExtension)) {
            return RrdUtils.getStrategy().getDefaultFileExtension();
        }
        return rrdExtension;
    }

    public static void promoteEnqueuedFiles(Collection<String> files) {
        RrdUtils.getStrategy().promoteEnqueuedFiles(files);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StrategyName {
        basicRrdStrategy,
        queuingRrdStrategy,
        tcpAndBasicRrdStrategy,
        tcpAndQueuingRrdStrategy;

    }
}

