/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rrd;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;
import org.opennms.netmgt.rrd.RrdDataSource;
import org.opennms.netmgt.rrd.RrdException;
import org.opennms.netmgt.rrd.RrdGraphDetails;
import org.opennms.netmgt.rrd.RrdStrategy;
import org.opennms.netmgt.rrd.RrdUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueuingRrdStrategy
implements RrdStrategy<Operation, String>,
Runnable {
    private Properties m_configurationProperties;
    RrdStrategy m_delegate;
    static final int UPDATE = 0;
    static final int CREATE = 1;
    private int m_writeThreads;
    private boolean m_queueCreates;
    private boolean m_prioritizeSignificantUpdates;
    private long m_inSigHighWaterMark;
    private long m_sigHighWaterMark;
    private long m_queueHighWaterMark;
    private long m_modulus;
    private String m_category;
    private long m_maxInsigUpdateSeconds;
    private long m_writeThreadSleepTime;
    private long m_writeThreadExitDelay;
    LinkedList<String> filesWithSignificantWork = new LinkedList();
    LinkedList<String> filesWithInsignificantWork = new LinkedList();
    Map<String, LinkedList<Operation>> pendingFileOperations = new HashMap<String, LinkedList<Operation>>();
    Map<Thread, String> fileAssignments = new HashMap<Thread, String>();
    Set<String> reservedFiles = new HashSet<String>();
    private long m_totalOperationsPending = 0L;
    private long m_enqueuedOperations = 0L;
    private long m_dequeuedOperations = 0L;
    private long m_significantOpsEnqueued = 0L;
    private long m_significantOpsDequeued = 0L;
    private long m_significantOpsCompleted = 0L;
    private long m_dequeuedItems = 0L;
    private long m_createsCompleted = 0L;
    private long m_updatesCompleted = 0L;
    private long m_errors = 0L;
    int threadsRunning = 0;
    private long m_startTime = 0L;
    private long m_promotionCount = 0L;
    long lastLap = System.currentTimeMillis();
    long lastStatsTime = 0L;
    long lastEnqueued = 0L;
    long lastDequeued = 0L;
    long lastSignificantEnqueued = 0L;
    long lastSignificantDequeued = 0L;
    long lastSignificantCompleted = 0L;
    long lastDequeuedItems = 0L;
    long lastOpsPending = 0L;

    public Properties getConfigurationProperties() {
        return this.m_configurationProperties;
    }

    @Override
    public void setConfigurationProperties(Properties configurationParameters) {
        this.m_configurationProperties = configurationParameters;
    }

    public int getWriteThreads() {
        return this.m_writeThreads;
    }

    public void setWriteThreads(int writeThreads) {
        this.m_writeThreads = writeThreads;
    }

    public boolean queueCreates() {
        return this.m_queueCreates;
    }

    public void setQueueCreates(boolean queueCreates) {
        this.m_queueCreates = queueCreates;
    }

    public boolean prioritizeSignificantUpdates() {
        return this.m_prioritizeSignificantUpdates;
    }

    public void setPrioritizeSignificantUpdates(boolean prioritizeSignificantUpdates) {
        this.m_prioritizeSignificantUpdates = prioritizeSignificantUpdates;
    }

    public long getInSigHighWaterMark() {
        return this.m_inSigHighWaterMark;
    }

    public void setInSigHighWaterMark(long inSigHighWaterMark) {
        this.m_inSigHighWaterMark = inSigHighWaterMark;
    }

    public long getSigHighWaterMark() {
        return this.m_sigHighWaterMark;
    }

    public void setSigHighWaterMark(long sigHighWaterMark) {
        this.m_sigHighWaterMark = sigHighWaterMark;
    }

    public long getQueueHighWaterMark() {
        return this.m_queueHighWaterMark;
    }

    public void setQueueHighWaterMark(long queueHighWaterMark) {
        this.m_queueHighWaterMark = queueHighWaterMark;
    }

    public long getModulus() {
        return this.m_modulus;
    }

    public void setModulus(long modulus) {
        this.m_modulus = modulus;
    }

    public String getCategory() {
        return this.m_category;
    }

    public void setCategory(String category) {
        this.m_category = category;
    }

    public long getMaxInsigUpdateSeconds() {
        return this.m_maxInsigUpdateSeconds;
    }

    public void setMaxInsigUpdateSeconds(long maxInsigUpdateSeconds) {
        this.m_maxInsigUpdateSeconds = maxInsigUpdateSeconds;
    }

    public long getWriteThreadSleepTime() {
        return this.m_writeThreadSleepTime;
    }

    public void setWriteThreadSleepTime(long writeThreadSleepTime) {
        this.m_writeThreadSleepTime = writeThreadSleepTime;
    }

    public long getWriteThreadExitDelay() {
        return this.m_writeThreadExitDelay;
    }

    public void setWriteThreadExitDelay(long writeThreadExitDelay) {
        this.m_writeThreadExitDelay = writeThreadExitDelay;
    }

    public Operation makeCreateOperation(String fileName, Object rrdDef) {
        return new CreateOperation(fileName, rrdDef);
    }

    public Operation makeUpdateOperation(String fileName, String owner, String update) {
        try {
            int colon = update.indexOf(58);
            if (colon >= 0 && Double.parseDouble(update.substring(colon + 1)) == 0.0) {
                long initialTimeStamp = Long.parseLong(update.substring(0, colon));
                if (initialTimeStamp == 0L) {
                    this.log().debug((Object)("ZERO ERROR: created a zero update with ts=0 for file: " + fileName + " data: " + update));
                }
                return new ZeroUpdateOperation(fileName, initialTimeStamp);
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return new UpdateOperation(fileName, update);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOperation(Operation op) {
        QueuingRrdStrategy queuingRrdStrategy = this;
        synchronized (queuingRrdStrategy) {
            if (this.queueIsFull()) {
                this.log().error((Object)("RRD Data Queue is Full!! Discarding operation for file " + op.getFileName()));
                return;
            }
            if (op.isSignificant() && this.sigQueueIsFull()) {
                this.log().error((Object)("RRD Data Significant Queue is Full!! Discarding operation for file " + op.getFileName()));
                return;
            }
            if (!op.isSignificant() && this.inSigQueueIsFull()) {
                this.log().error((Object)("RRD Insignificant Data Queue is Full!! Discarding operation for file " + op.getFileName()));
                return;
            }
            this.storeAssignment(op);
            this.setTotalOperationsPending(this.getTotalOperationsPending() + 1L);
            this.setEnqueuedOperations(this.getEnqueuedOperations() + 1L);
            if (op.isSignificant()) {
                this.setSignificantOpsEnqueued(this.getSignificantOpsEnqueued() + 1L);
            }
            this.notifyAll();
            this.ensureThreadsStarted();
        }
    }

    private Logger log() {
        return Logger.getLogger((String)this.m_category);
    }

    private boolean queueIsFull() {
        if (this.m_queueHighWaterMark <= 0L) {
            return false;
        }
        return this.getTotalOperationsPending() >= this.m_queueHighWaterMark;
    }

    private boolean sigQueueIsFull() {
        if (this.m_sigHighWaterMark <= 0L) {
            return false;
        }
        return this.getTotalOperationsPending() >= this.m_sigHighWaterMark;
    }

    private boolean inSigQueueIsFull() {
        if (this.m_inSigHighWaterMark <= 0L) {
            return false;
        }
        return this.getTotalOperationsPending() >= this.m_inSigHighWaterMark;
    }

    public synchronized void ensureThreadsStarted() {
        if (this.threadsRunning < this.m_writeThreads) {
            ++this.threadsRunning;
            new Thread((Runnable)this, this.getClass().getSimpleName() + "-" + this.threadsRunning).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedList<Operation> getNext() {
        LinkedList<Operation> ops = null;
        QueuingRrdStrategy queuingRrdStrategy = this;
        synchronized (queuingRrdStrategy) {
            String newAssignment;
            this.completeAssignment();
            while ((newAssignment = this.selectNewAssignment()) == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {}
            }
            if (this.getStartTime() == 0L) {
                this.setStartTime(System.currentTimeMillis());
            }
            if ((ops = this.takeAssignment(newAssignment)) != null) {
                for (Operation op : ops) {
                    this.setTotalOperationsPending(this.getTotalOperationsPending() - (long)op.getCount());
                    this.setDequeuedOperations(this.getDequeuedOperations() + (long)op.getCount());
                    if (!op.isSignificant()) continue;
                    this.setSignificantOpsDequeued(this.getSignificantOpsDequeued() + (long)op.getCount());
                }
                this.setDequeuedItems(this.getDequeuedItems() + 1L);
            }
        }
        return ops;
    }

    private synchronized void storeAssignment(Operation op) {
        LinkedList<Operation> pendingOperations = this.pendingFileOperations.get(op.getFileName());
        if (pendingOperations == null) {
            pendingOperations = new LinkedList();
            this.pendingFileOperations.put(op.getFileName(), pendingOperations);
            if (!this.m_prioritizeSignificantUpdates || op.isSignificant()) {
                this.filesWithSignificantWork.addLast(op.getFileName());
            } else {
                this.filesWithInsignificantWork.addLast(op.getFileName());
            }
        } else if (this.m_prioritizeSignificantUpdates && op.isSignificant() && this.hasOnlyInsignificant(pendingOperations)) {
            this.filesWithSignificantWork.addLast(op.getFileName());
        }
        this.promoteAgedFiles();
        op.addToPendingList(pendingOperations);
    }

    private synchronized void promoteAgedFiles() {
        double millisPerPromotion;
        long nextPromotionMillis;
        if (!this.m_prioritizeSignificantUpdates) {
            return;
        }
        if (this.m_maxInsigUpdateSeconds == 0L || this.filesWithInsignificantWork.isEmpty()) {
            return;
        }
        long now = System.currentTimeMillis();
        long elapsedMillis = Math.max(now - this.getStartTime(), 1L);
        if (elapsedMillis > (nextPromotionMillis = (long)((millisPerPromotion = (double)this.m_maxInsigUpdateSeconds * 1000.0 / (double)this.filesWithInsignificantWork.size()) * (double)this.getPromotionCount()))) {
            String file = this.filesWithInsignificantWork.removeFirst();
            this.filesWithSignificantWork.addFirst(file);
            this.setPromotionCount(this.getPromotionCount() + 1L);
        }
    }

    @Override
    public synchronized void promoteEnqueuedFiles(Collection<String> rrdFiles) {
        this.filesWithSignificantWork.addAll(0, rrdFiles);
    }

    private boolean hasOnlyInsignificant(LinkedList<Operation> pendingOps) {
        for (Operation op : pendingOps) {
            if (!op.isSignificant()) continue;
            return false;
        }
        return true;
    }

    private LinkedList<Operation> takeAssignment(String newAssignment) {
        this.fileAssignments.put(Thread.currentThread(), newAssignment);
        this.reservedFiles.add(newAssignment);
        return this.pendingFileOperations.remove(newAssignment);
    }

    private String selectNewAssignment() {
        String fn;
        Iterator it = this.filesWithSignificantWork.iterator();
        while (it.hasNext()) {
            fn = (String)it.next();
            if (this.reservedFiles.contains(fn)) continue;
            it.remove();
            return fn;
        }
        it = this.filesWithInsignificantWork.iterator();
        while (it.hasNext()) {
            fn = (String)it.next();
            if (this.reservedFiles.contains(fn)) continue;
            it.remove();
            return fn;
        }
        return null;
    }

    private synchronized void completeAssignment() {
        String previousAssignment = this.fileAssignments.remove(Thread.currentThread());
        if (previousAssignment != null) {
            this.reservedFiles.remove(previousAssignment);
        }
    }

    public QueuingRrdStrategy(RrdStrategy delegate) {
        this.m_delegate = delegate;
    }

    public RrdStrategy getDelegate() {
        return this.m_delegate;
    }

    @Override
    public void closeFile(String rrd) throws Exception {
    }

    public Operation createDefinition(String creator, String directory, String dsName, int step, String dsType, int dsHeartbeat, String dsMin, String dsMax, List<String> rraList) throws Exception {
        return this.createDefinition(creator, directory, dsName, step, (List)Collections.singletonList(new RrdDataSource(dsName, dsType, dsHeartbeat, dsMin, dsMax)), (List)rraList);
    }

    @Override
    public Operation createDefinition(String creator, String directory, String rrdName, int step, List<RrdDataSource> dataSources, List<String> rraList) throws Exception {
        String fileName = directory + File.separator + rrdName + RrdUtils.getExtension();
        Object def = this.m_delegate.createDefinition(creator, directory, rrdName, step, dataSources, rraList);
        return this.makeCreateOperation(fileName, def);
    }

    @Override
    public void createFile(Operation op) throws Exception {
        if (this.m_queueCreates) {
            this.addOperation(op);
        } else {
            this.m_delegate.createFile(op.getData());
        }
    }

    @Override
    public String openFile(String fileName) throws Exception {
        return fileName;
    }

    @Override
    public void updateFile(String rrdFile, String owner, String data) throws Exception {
        this.addOperation(this.makeUpdateOperation(rrdFile, owner, data));
    }

    @Override
    public Double fetchLastValue(String rrdFile, String ds, int interval) throws NumberFormatException, RrdException {
        return this.m_delegate.fetchLastValue(rrdFile, ds, interval);
    }

    @Override
    public Double fetchLastValue(String rrdFile, String ds, String consolidationFunction, int interval) throws NumberFormatException, RrdException {
        return this.m_delegate.fetchLastValue(rrdFile, ds, consolidationFunction, interval);
    }

    @Override
    public Double fetchLastValueInRange(String rrdFile, String ds, int interval, int range) throws NumberFormatException, RrdException {
        return this.m_delegate.fetchLastValueInRange(rrdFile, ds, interval, range);
    }

    @Override
    public InputStream createGraph(String command, File workDir) throws IOException, RrdException {
        return this.m_delegate.createGraph(command, workDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            long waitStart = -1L;
            long delayed = 0L;
            while (delayed < this.m_writeThreadExitDelay) {
                if (this.getTotalOperationsPending() > 0L) {
                    delayed = 0L;
                    waitStart = -1L;
                    this.processPendingOperations();
                    continue;
                }
                if (waitStart < 0L) {
                    waitStart = System.currentTimeMillis();
                }
                try {
                    Thread.sleep(this.m_writeThreadSleepTime);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                long now = System.currentTimeMillis();
                delayed = now - waitStart;
            }
        }
        finally {
            QueuingRrdStrategy queuingRrdStrategy = this;
            synchronized (queuingRrdStrategy) {
                --this.threadsRunning;
                this.completeAssignment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPendingOperations() {
        LinkedList<Operation> ops;
        String fileName;
        Object rrd;
        block7: {
            rrd = null;
            fileName = null;
            ops = this.getNext();
            if (ops != null) break block7;
            this.processClose(rrd);
            return;
        }
        try {
            for (Operation op : ops) {
                if (!op.isSignificant()) continue;
                this.setSignificantOpsCompleted(this.getSignificantOpsCompleted() + 1L);
            }
            for (Operation op : ops) {
                fileName = op.getFileName();
                rrd = op.process(rrd);
            }
            this.processClose(rrd);
        }
        catch (Exception e) {
            try {
                this.setErrors(this.getErrors() + 1L);
                this.logLapTime("Error updating file " + fileName + ": " + e.getMessage());
                this.log().debug((Object)("Error upading file " + fileName + ": " + e.getMessage()), (Throwable)e);
                this.processClose(rrd);
            }
            catch (Throwable throwable) {
                this.processClose(rrd);
                throw throwable;
            }
        }
    }

    private void processClose(Object rrd) {
        if (rrd != null) {
            try {
                this.m_delegate.closeFile(rrd);
            }
            catch (Throwable t) {
                this.logLapTime("Throwable received while closing file", t);
            }
        }
    }

    @Override
    public String getStats() {
        long now = System.currentTimeMillis();
        long currentElapsedMillis = Math.max(now - this.lastStatsTime, 1L);
        long totalElapsedMillis = Math.max(now - this.getStartTime(), 1L);
        long currentEnqueuedOps = this.getEnqueuedOperations() - this.lastEnqueued;
        long currentDequeuedOps = this.getDequeuedOperations() - this.lastDequeued;
        long currentDequeuedItems = this.getDequeuedItems() - this.lastDequeuedItems;
        long currentSigOpsEnqueued = this.getSignificantOpsEnqueued() - this.lastSignificantEnqueued;
        long currentSigOpsDequeued = this.getSignificantOpsDequeued() - this.lastSignificantDequeued;
        long currentEnqueueRate = (long)((double)currentEnqueuedOps * 1000.0 / (double)currentElapsedMillis);
        long currentSigEnqueueRate = (long)((double)currentSigOpsEnqueued * 1000.0 / (double)currentElapsedMillis);
        long currentInsigEnqueueRate = (long)((double)(currentEnqueuedOps - currentSigOpsEnqueued) * 1000.0 / (double)currentElapsedMillis);
        long overallEnqueueRate = (long)((double)this.getEnqueuedOperations() * 1000.0 / (double)totalElapsedMillis);
        long overallSigEnqueueRate = (long)((double)this.getSignificantOpsEnqueued() * 1000.0 / (double)totalElapsedMillis);
        long overallInsigEnqueueRate = (long)((double)(this.getEnqueuedOperations() - this.getSignificantOpsEnqueued()) * 1000.0 / (double)totalElapsedMillis);
        long currentDequeueRate = (long)((double)currentDequeuedOps * 1000.0 / (double)currentElapsedMillis);
        long currentSigDequeueRate = (long)((double)currentSigOpsDequeued * 1000.0 / (double)currentElapsedMillis);
        long currentInsigDequeueRate = (long)((double)(currentDequeuedOps - currentSigOpsDequeued) * 1000.0 / (double)currentElapsedMillis);
        long overallDequeueRate = (long)((double)this.getDequeuedOperations() * 1000.0 / (double)totalElapsedMillis);
        long overallSigDequeueRate = (long)((double)this.getSignificantOpsDequeued() * 1000.0 / (double)totalElapsedMillis);
        long overallInsigDequeueRate = (long)((double)(this.getDequeuedOperations() - this.getSignificantOpsDequeued()) * 1000.0 / (double)totalElapsedMillis);
        long currentItemDequeueRate = (long)((double)currentDequeuedItems * 1000.0 / (double)currentElapsedMillis);
        long overallItemDequeueRate = (long)((double)this.getDequeuedItems() * 1000.0 / (double)totalElapsedMillis);
        String stats = "\nQS:\ttotalOperationsPending=" + this.getTotalOperationsPending() + ", significantOpsPending=" + (this.getSignificantOpsEnqueued() - this.getSignificantOpsCompleted()) + ", filesWithSignificantWork=" + this.filesWithSignificantWork.size() + ", filesWithInsignificantWork=" + this.filesWithInsignificantWork.size() + "\nQS:\t" + ", createsCompleted=" + this.getCreatesCompleted() + ", updatesCompleted=" + this.getUpdatesCompleted() + ", errors=" + this.getErrors() + ", promotionRate=" + (double)this.getPromotionCount() * 1000.0 / (double)totalElapsedMillis + ", promotionCount=" + this.getPromotionCount() + "\nQS:\t" + ", currentEnqueueRates=(" + currentSigEnqueueRate + "/" + currentInsigEnqueueRate + "/" + currentEnqueueRate + ")" + ", currentDequeueRate=(" + currentSigDequeueRate + "/" + currentInsigDequeueRate + "/" + currentDequeueRate + ")" + ", currentItemDequeRate=" + currentItemDequeueRate + ", currentOpsPerUpdate=" + (double)currentDequeuedOps / Math.max((double)currentDequeuedItems, 1.0) + ", currentPrcntSignificant=" + (double)currentSigOpsEnqueued * 100.0 / Math.max((double)currentEnqueuedOps, 1.0) + "%" + ", elapsedTime=" + (currentElapsedMillis + 500L) / 1000L + "\nQS:\t" + ", overallEnqueueRate=(" + overallSigEnqueueRate + "/" + overallInsigEnqueueRate + "/" + overallEnqueueRate + ")" + ", overallDequeueRate=(" + overallSigDequeueRate + "/" + overallInsigDequeueRate + "/" + overallDequeueRate + ")" + ", overallItemDequeRate=" + overallItemDequeueRate + ", overallOpsPerUpdate=" + (double)this.getDequeuedOperations() / Math.max((double)this.getDequeuedItems(), 1.0) + ", overallPrcntSignificant=" + (double)this.getSignificantOpsEnqueued() * 100.0 / Math.max((double)this.getEnqueuedOperations(), 1.0) + "%" + ", totalElapsedTime=" + (totalElapsedMillis + 500L) / 1000L;
        this.lastStatsTime = now;
        this.lastEnqueued = this.getEnqueuedOperations();
        this.lastDequeued = this.getDequeuedOperations();
        this.lastDequeuedItems = this.getDequeuedItems();
        this.lastSignificantEnqueued = this.getSignificantOpsEnqueued();
        this.lastSignificantDequeued = this.getSignificantOpsDequeued();
        this.lastSignificantCompleted = this.getSignificantOpsCompleted();
        this.lastOpsPending = this.getTotalOperationsPending();
        return stats;
    }

    public void logStats() {
        this.logLapTime(this.getStats());
    }

    void logLapTime(String message) {
        this.log().debug((Object)(message + " " + this.getLapTime()));
    }

    void logLapTime(String message, Throwable t) {
        this.log().debug((Object)(message + " " + this.getLapTime()), t);
    }

    public String getLapTime() {
        long newLap = System.currentTimeMillis();
        double seconds = (double)(newLap - this.lastLap) / 1000.0;
        this.lastLap = newLap;
        return "[" + seconds + " sec]";
    }

    @Override
    public int getGraphLeftOffset() {
        return this.m_delegate.getGraphLeftOffset();
    }

    @Override
    public int getGraphRightOffset() {
        return this.m_delegate.getGraphRightOffset();
    }

    @Override
    public int getGraphTopOffsetWithText() {
        return this.m_delegate.getGraphTopOffsetWithText();
    }

    @Override
    public String getDefaultFileExtension() {
        return this.m_delegate.getDefaultFileExtension();
    }

    @Override
    public RrdGraphDetails createGraphReturnDetails(String command, File workDir) throws IOException, RrdException {
        return this.m_delegate.createGraphReturnDetails(command, workDir);
    }

    public long getTotalOperationsPending() {
        return this.m_totalOperationsPending;
    }

    public void setTotalOperationsPending(long totalOperationsPending) {
        this.m_totalOperationsPending = totalOperationsPending;
    }

    public long getCreatesCompleted() {
        return this.m_createsCompleted;
    }

    public void setCreatesCompleted(long createsCompleted) {
        this.m_createsCompleted = createsCompleted;
    }

    public long getUpdatesCompleted() {
        return this.m_updatesCompleted;
    }

    public void setUpdatesCompleted(long updatesCompleted) {
        this.m_updatesCompleted = updatesCompleted;
    }

    public long getErrors() {
        return this.m_errors;
    }

    public void setErrors(long errors) {
        this.m_errors = errors;
    }

    public long getPromotionCount() {
        return this.m_promotionCount;
    }

    public void setPromotionCount(long promotionCount) {
        this.m_promotionCount = promotionCount;
    }

    public long getSignificantOpsEnqueued() {
        return this.m_significantOpsEnqueued;
    }

    public void setSignificantOpsEnqueued(long significantOpsEnqueued) {
        this.m_significantOpsEnqueued = significantOpsEnqueued;
    }

    public long getSignificantOpsDequeued() {
        return this.m_significantOpsDequeued;
    }

    public void setSignificantOpsDequeued(long significantOpsDequeued) {
        this.m_significantOpsDequeued = significantOpsDequeued;
    }

    public long getEnqueuedOperations() {
        return this.m_enqueuedOperations;
    }

    public void setEnqueuedOperations(long enqueuedOperations) {
        this.m_enqueuedOperations = enqueuedOperations;
    }

    public long getDequeuedOperations() {
        return this.m_dequeuedOperations;
    }

    public void setDequeuedOperations(long dequeuedOperations) {
        this.m_dequeuedOperations = dequeuedOperations;
    }

    public long getDequeuedItems() {
        return this.m_dequeuedItems;
    }

    public void setDequeuedItems(long dequeuedItems) {
        this.m_dequeuedItems = dequeuedItems;
    }

    public long getSignificantOpsCompleted() {
        return this.m_significantOpsCompleted;
    }

    public void setSignificantOpsCompleted(long significantOpsCompleted) {
        this.m_significantOpsCompleted = significantOpsCompleted;
    }

    public long getStartTime() {
        return this.m_startTime;
    }

    public void setStartTime(long updateStart) {
        this.m_startTime = updateStart;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ZeroUpdateOperation
    extends UpdateOperation {
        long timeStamp;
        long interval;
        int count;

        ZeroUpdateOperation(String fileName, long intitialTimeStamp) {
            super(fileName, "0", false);
            this.interval = 0L;
            this.timeStamp = intitialTimeStamp;
            this.count = 1;
        }

        @Override
        Object process(Object rrd) throws Exception {
            long ts = this.getFirstTimeStamp();
            for (int i = 0; i < this.count; ++i) {
                if (rrd == null) {
                    rrd = QueuingRrdStrategy.this.m_delegate.openFile(this.getFileName());
                }
                String update = ts + ":0";
                try {
                    QueuingRrdStrategy.this.m_delegate.updateFile(rrd, "", update);
                }
                catch (Exception e) {
                    throw new Exception("Error processing update " + i + " for file " + this.getFileName() + ": " + update, e);
                }
                ts += this.getInterval();
                QueuingRrdStrategy.this.setUpdatesCompleted(QueuingRrdStrategy.this.getUpdatesCompleted() + 1L);
                if (QueuingRrdStrategy.this.getUpdatesCompleted() % QueuingRrdStrategy.this.m_modulus != 0L) continue;
                QueuingRrdStrategy.this.logStats();
            }
            return rrd;
        }

        @Override
        public int getCount() {
            return this.count;
        }

        public void setCount(int newCount) {
            this.count = newCount;
        }

        public long getFirstTimeStamp() {
            return this.timeStamp;
        }

        public long getLastTimeStamp() {
            return this.timeStamp + this.interval * (long)(this.count - 1);
        }

        public long getInterval() {
            return this.interval;
        }

        public void setInterval(long newInterval) {
            this.interval = newInterval;
        }

        public void mergeUpdates(ZeroUpdateOperation op) throws IllegalArgumentException {
            long opSpacing = op.getFirstTimeStamp() - this.getLastTimeStamp();
            long tolerance = this.getInterval() / 5L;
            if (opSpacing == 0L) {
                throw new IllegalArgumentException("unable to merge op because the spacing " + opSpacing + " is 0");
            }
            if (this.getInterval() > 0L && Math.abs(opSpacing - this.getInterval()) >= tolerance) {
                throw new IllegalArgumentException("unable to merge op because the spacing " + opSpacing + " is different than the current interval " + this.getInterval());
            }
            if (this.getInterval() > 0L && op.getInterval() > 0L && Math.abs(op.getInterval() - this.getInterval()) >= tolerance) {
                throw new IllegalArgumentException("unable to merge op because the new op interval " + op.getInterval() + " is different than the current interval " + this.getInterval());
            }
            int newCount = this.getCount() + op.getCount();
            long newInterval = ((long)(this.getCount() - 1) * this.getInterval() + (long)(op.getCount() - 1) + op.getInterval() + opSpacing) / (long)(newCount - 1);
            this.setCount(newCount);
            this.setInterval(newInterval);
        }

        @Override
        void addToPendingList(LinkedList<Operation> pendingOperations) {
            if (pendingOperations.size() > 0 && pendingOperations.getLast() instanceof ZeroUpdateOperation) {
                ZeroUpdateOperation zeroOp = (ZeroUpdateOperation)pendingOperations.getLast();
                try {
                    zeroOp.mergeUpdates(this);
                }
                catch (IllegalArgumentException e) {
                    QueuingRrdStrategy.this.log().debug((Object)e.getMessage());
                    super.addToPendingList(pendingOperations);
                }
            } else {
                super.addToPendingList(pendingOperations);
            }
        }
    }

    public class UpdateOperation
    extends Operation {
        UpdateOperation(String fileName, String data) {
            super(fileName, 0, data, true);
        }

        UpdateOperation(String fileName, String data, boolean significant) {
            super(fileName, 0, data, significant);
        }

        Object process(Object rrd) throws Exception {
            if (rrd == null) {
                rrd = QueuingRrdStrategy.this.m_delegate.openFile(this.getFileName());
            }
            String update = (String)this.getData();
            try {
                QueuingRrdStrategy.this.m_delegate.updateFile(rrd, "", update);
            }
            catch (Exception e) {
                throw new Exception("Error processing update for file " + this.getFileName() + ": " + update, e);
            }
            QueuingRrdStrategy.this.setUpdatesCompleted(QueuingRrdStrategy.this.getUpdatesCompleted() + 1L);
            if (QueuingRrdStrategy.this.getUpdatesCompleted() % QueuingRrdStrategy.this.m_modulus == 0L) {
                QueuingRrdStrategy.this.logStats();
            }
            return rrd;
        }
    }

    public class CreateOperation
    extends Operation {
        CreateOperation(String fileName, Object rrdDef) {
            super(fileName, 1, rrdDef, true);
        }

        Object process(Object rrd) throws Exception {
            if (rrd != null) {
                QueuingRrdStrategy.this.log().debug((Object)"WHAT! rrd open but not created?");
                QueuingRrdStrategy.this.m_delegate.closeFile(rrd);
                rrd = null;
            }
            QueuingRrdStrategy.this.m_delegate.createFile(this.getData());
            QueuingRrdStrategy.this.setCreatesCompleted(QueuingRrdStrategy.this.getCreatesCompleted() + 1L);
            return rrd;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class Operation {
        String fileName;
        int type;
        Object data;
        boolean significant;

        Operation(String fileName, int type, Object data, boolean significant) {
            this.fileName = fileName;
            this.type = type;
            this.data = data;
            this.significant = significant;
        }

        int getCount() {
            return 1;
        }

        String getFileName() {
            return this.fileName;
        }

        int getType() {
            return this.type;
        }

        Object getData() {
            return this.data;
        }

        boolean isSignificant() {
            return this.significant;
        }

        void addToPendingList(LinkedList<Operation> pendingOperations) {
            pendingOperations.add(this);
        }

        abstract Object process(Object var1) throws Exception;
    }
}

