/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo.ext;

import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import org.snmp4j.agent.DefaultMOScope;
import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.MOContextScope;
import org.snmp4j.agent.MOGroup;
import org.snmp4j.agent.MOScope;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.ManagedObject;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public class StaticMOGroup
implements ManagedObject,
MOGroup {
    private SortedMap vbs = new TreeMap();
    private OID root;
    private MOScope scope;

    public StaticMOGroup(OID root, VariableBinding[] vbs) {
        this.root = root;
        this.scope = new DefaultMOScope(root, true, root.nextPeer(), false);
        for (int i = 0; i < vbs.length; ++i) {
            if (vbs[i].getOid() == null || vbs[i].getVariable() == null || vbs[i].getOid().size() < root.size() || vbs[i].getOid().leftMostCompare(root.size(), root) != 0) continue;
            this.vbs.put(vbs[i].getOid(), vbs[i].getVariable());
        }
    }

    public void registerMOs(MOServer server, OctetString context) throws DuplicateRegistrationException {
        server.register(this, context);
    }

    public void unregisterMOs(MOServer server, OctetString context) {
        server.unregister(this, context);
    }

    public MOScope getScope() {
        return this.scope;
    }

    public OID find(MOScope range) {
        SortedMap tail = this.vbs.tailMap(range.getLowerBound());
        OID first = tail.firstKey();
        if (range.getLowerBound().equals((Object)first) && !range.isLowerIncluded()) {
            if (tail.size() > 1) {
                Iterator it = tail.keySet().iterator();
                it.next();
                return (OID)it.next();
            }
        } else {
            return first;
        }
        return null;
    }

    public void get(SubRequest request) {
        OID oid = request.getVariableBinding().getOid();
        Variable vb = (Variable)this.vbs.get(oid);
        if (vb == null) {
            request.getVariableBinding().setVariable((Variable)Null.noSuchInstance);
        }
        request.getVariableBinding().setVariable(vb);
        request.completed();
    }

    public boolean next(SubRequest request) {
        MOContextScope scope = request.getQuery().getScope();
        SortedMap tail = this.vbs.tailMap(scope.getLowerBound());
        OID first = tail.firstKey();
        if (scope.getLowerBound().equals((Object)first) && !scope.isLowerIncluded()) {
            if (tail.size() > 1) {
                Iterator it = tail.keySet().iterator();
                it.next();
                first = (OID)it.next();
            } else {
                return false;
            }
        }
        if (first != null) {
            Variable vb = (Variable)this.vbs.get(first);
            if (vb == null) {
                request.getVariableBinding().setVariable((Variable)Null.noSuchInstance);
            }
            request.getVariableBinding().setOid(first);
            request.getVariableBinding().setVariable(vb);
            request.completed();
            return true;
        }
        return false;
    }

    public void prepare(SubRequest request) {
        request.setErrorStatus(17);
    }

    public void commit(SubRequest request) {
        request.setErrorStatus(14);
    }

    public void undo(SubRequest request) {
        request.setErrorStatus(15);
    }

    public void cleanup(SubRequest request) {
    }

    public String toString() {
        return "StaticMOGroup[root=" + this.root + ",vbs=" + this.vbs + "]";
    }
}

