/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml;

import java.util.Map;
import net.sf.jasperreports.engine.xml.TransformedPropertyRule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XmlConstantPropertyRule
extends TransformedPropertyRule {
    private static final Log log = LogFactory.getLog((Class)XmlConstantPropertyRule.class);
    private final Map constantsMap;

    public XmlConstantPropertyRule(String attributeName, Map constantsMap) {
        super(attributeName);
        this.constantsMap = constantsMap;
    }

    public XmlConstantPropertyRule(String attributeName, String propertyName, Map constantsMap) {
        super(attributeName, propertyName);
        this.constantsMap = constantsMap;
    }

    protected Object toPropertyValue(String attributeValue) {
        Object value = this.constantsMap.get(attributeValue);
        if (value == null) {
            log.warn((Object)("Unrecognized attribute value \"" + attributeValue + "\" for " + this.attributeName));
        }
        return value;
    }
}

