/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.icmp;

import java.net.InetAddress;
import org.opennms.netmgt.ping.Pinger;
import org.opennms.netmgt.provision.DetectorMonitor;
import org.opennms.netmgt.provision.support.AbstractDetector;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class IcmpDetector
extends AbstractDetector {
    public IcmpDetector() {
        this.init();
    }

    public void init() {
        this.setTimeout(800);
        this.setRetries(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isServiceDetected(InetAddress address, DetectorMonitor detectorMonitor) {
        StringBuffer sb = new StringBuffer();
        sb.delete(0, sb.length());
        sb.append("isServiceDetected: Testing ICMP based service for address: ");
        sb.append(address);
        sb.append("...");
        this.log().info(sb.toString());
        try {
            int i = 0;
            while (i < this.getRetries()) {
                Long retval = Pinger.ping((InetAddress)address, (long)this.getTimeout(), (int)this.getRetries());
                sb.delete(0, sb.length());
                sb.append("isServiceDetected: Response time for address: ");
                sb.append(address);
                sb.append(" is: ");
                sb.append(retval);
                sb.append('.');
                this.log().debug(retval.toString());
                if (retval != null) {
                    sb.delete(0, sb.length());
                    sb.append("isServiceDetected: ICMP based service for address: ");
                    sb.append(address);
                    sb.append(" is detected: ");
                    sb.append(true);
                    sb.append('.');
                    this.log().debug(sb.toString());
                    return true;
                }
                ++i;
            }
            return false;
        }
        catch (InterruptedException e) {
            sb.delete(0, sb.length());
            sb.append("isServiceDetected: ICMP based protocol for address: ");
            sb.append(address);
            sb.append(" is detected: ");
            sb.append(false);
            sb.append(". Received an Interrupted exception.");
            this.log().debug(sb.toString());
            return false;
        }
        catch (Exception e) {
            sb.delete(0, sb.length());
            sb.append("isServiceDetected: ICMP based protocol for address: ");
            sb.append(address);
            sb.append(" is detected: ");
            sb.append(false);
            sb.append(". Received an Exception.");
            this.log().debug(sb.toString());
            return false;
        }
    }

    protected void onInit() {
    }

    public void dispose() {
    }
}

