/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.viewsdisplay;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.viewsdisplay.View;
import org.xml.sax.ContentHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Viewinfo
implements Serializable {
    private int _disconnectTimeout = 130000;
    private boolean _has_disconnectTimeout;
    private String _defaultView = "WebConsoleView";
    private List<View> _viewList;

    public Viewinfo() {
        this.setDefaultView("WebConsoleView");
        this._viewList = new ArrayList<View>();
    }

    public void addView(View vView) throws IndexOutOfBoundsException {
        this._viewList.add(vView);
    }

    public void addView(int index, View vView) throws IndexOutOfBoundsException {
        this._viewList.add(index, vView);
    }

    public void deleteDisconnectTimeout() {
        this._has_disconnectTimeout = false;
    }

    public Enumeration<View> enumerateView() {
        return Collections.enumeration(this._viewList);
    }

    public String getDefaultView() {
        return this._defaultView;
    }

    public int getDisconnectTimeout() {
        return this._disconnectTimeout;
    }

    public View getView(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._viewList.size()) {
            throw new IndexOutOfBoundsException("getView: Index value '" + index + "' not in range [0.." + (this._viewList.size() - 1) + "]");
        }
        return this._viewList.get(index);
    }

    public View[] getView() {
        View[] array = new View[]{};
        return this._viewList.toArray(array);
    }

    public List<View> getViewCollection() {
        return this._viewList;
    }

    public int getViewCount() {
        return this._viewList.size();
    }

    public boolean hasDisconnectTimeout() {
        return this._has_disconnectTimeout;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<View> iterateView() {
        return this._viewList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllView() {
        this._viewList.clear();
    }

    public boolean removeView(View vView) {
        boolean removed = this._viewList.remove(vView);
        return removed;
    }

    public View removeViewAt(int index) {
        View obj = this._viewList.remove(index);
        return obj;
    }

    public void setDefaultView(String defaultView) {
        this._defaultView = defaultView;
    }

    public void setDisconnectTimeout(int disconnectTimeout) {
        this._disconnectTimeout = disconnectTimeout;
        this._has_disconnectTimeout = true;
    }

    public void setView(int index, View vView) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._viewList.size()) {
            throw new IndexOutOfBoundsException("setView: Index value '" + index + "' not in range [0.." + (this._viewList.size() - 1) + "]");
        }
        this._viewList.set(index, vView);
    }

    public void setView(View[] vViewArray) {
        this._viewList.clear();
        for (int i = 0; i < vViewArray.length; ++i) {
            this._viewList.add(vViewArray[i]);
        }
    }

    public void setView(List<View> vViewList) {
        this._viewList.clear();
        this._viewList.addAll(vViewList);
    }

    public void setViewCollection(List<View> viewList) {
        this._viewList = viewList;
    }

    public static Viewinfo unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (Viewinfo)Unmarshaller.unmarshal(Viewinfo.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

