/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.reportd;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.reportd.Parameter;
import org.xml.sax.ContentHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Report
implements Serializable {
    private String _reportTemplate;
    private String _reportName;
    private String _reportFormat = "pdf";
    private String _reportEngine = "opennms";
    private String _cronSchedule;
    private List<String> _recipientList;
    private List<Parameter> _parameterList;

    public Report() {
        this.setReportFormat("pdf");
        this.setReportEngine("opennms");
        this._recipientList = new ArrayList<String>();
        this._parameterList = new ArrayList<Parameter>();
    }

    public void addParameter(Parameter vParameter) throws IndexOutOfBoundsException {
        this._parameterList.add(vParameter);
    }

    public void addParameter(int index, Parameter vParameter) throws IndexOutOfBoundsException {
        this._parameterList.add(index, vParameter);
    }

    public void addRecipient(String vRecipient) throws IndexOutOfBoundsException {
        this._recipientList.add(vRecipient);
    }

    public void addRecipient(int index, String vRecipient) throws IndexOutOfBoundsException {
        this._recipientList.add(index, vRecipient);
    }

    public Enumeration<Parameter> enumerateParameter() {
        return Collections.enumeration(this._parameterList);
    }

    public Enumeration<String> enumerateRecipient() {
        return Collections.enumeration(this._recipientList);
    }

    public String getCronSchedule() {
        return this._cronSchedule;
    }

    public Parameter getParameter(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._parameterList.size()) {
            throw new IndexOutOfBoundsException("getParameter: Index value '" + index + "' not in range [0.." + (this._parameterList.size() - 1) + "]");
        }
        return this._parameterList.get(index);
    }

    public Parameter[] getParameter() {
        Parameter[] array = new Parameter[]{};
        return this._parameterList.toArray(array);
    }

    public List<Parameter> getParameterCollection() {
        return this._parameterList;
    }

    public int getParameterCount() {
        return this._parameterList.size();
    }

    public String getRecipient(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._recipientList.size()) {
            throw new IndexOutOfBoundsException("getRecipient: Index value '" + index + "' not in range [0.." + (this._recipientList.size() - 1) + "]");
        }
        return this._recipientList.get(index);
    }

    public String[] getRecipient() {
        String[] array = new String[]{};
        return this._recipientList.toArray(array);
    }

    public List<String> getRecipientCollection() {
        return this._recipientList;
    }

    public int getRecipientCount() {
        return this._recipientList.size();
    }

    public String getReportEngine() {
        return this._reportEngine;
    }

    public String getReportFormat() {
        return this._reportFormat;
    }

    public String getReportName() {
        return this._reportName;
    }

    public String getReportTemplate() {
        return this._reportTemplate;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<Parameter> iterateParameter() {
        return this._parameterList.iterator();
    }

    public Iterator<String> iterateRecipient() {
        return this._recipientList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllParameter() {
        this._parameterList.clear();
    }

    public void removeAllRecipient() {
        this._recipientList.clear();
    }

    public boolean removeParameter(Parameter vParameter) {
        boolean removed = this._parameterList.remove(vParameter);
        return removed;
    }

    public Parameter removeParameterAt(int index) {
        Parameter obj = this._parameterList.remove(index);
        return obj;
    }

    public boolean removeRecipient(String vRecipient) {
        boolean removed = this._recipientList.remove(vRecipient);
        return removed;
    }

    public String removeRecipientAt(int index) {
        String obj = this._recipientList.remove(index);
        return obj;
    }

    public void setCronSchedule(String cronSchedule) {
        this._cronSchedule = cronSchedule;
    }

    public void setParameter(int index, Parameter vParameter) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._parameterList.size()) {
            throw new IndexOutOfBoundsException("setParameter: Index value '" + index + "' not in range [0.." + (this._parameterList.size() - 1) + "]");
        }
        this._parameterList.set(index, vParameter);
    }

    public void setParameter(Parameter[] vParameterArray) {
        this._parameterList.clear();
        for (int i = 0; i < vParameterArray.length; ++i) {
            this._parameterList.add(vParameterArray[i]);
        }
    }

    public void setParameter(List<Parameter> vParameterList) {
        this._parameterList.clear();
        this._parameterList.addAll(vParameterList);
    }

    public void setParameterCollection(List<Parameter> parameterList) {
        this._parameterList = parameterList;
    }

    public void setRecipient(int index, String vRecipient) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._recipientList.size()) {
            throw new IndexOutOfBoundsException("setRecipient: Index value '" + index + "' not in range [0.." + (this._recipientList.size() - 1) + "]");
        }
        this._recipientList.set(index, vRecipient);
    }

    public void setRecipient(String[] vRecipientArray) {
        this._recipientList.clear();
        for (int i = 0; i < vRecipientArray.length; ++i) {
            this._recipientList.add(vRecipientArray[i]);
        }
    }

    public void setRecipient(List<String> vRecipientList) {
        this._recipientList.clear();
        this._recipientList.addAll(vRecipientList);
    }

    public void setRecipientCollection(List<String> recipientList) {
        this._recipientList = recipientList;
    }

    public void setReportEngine(String reportEngine) {
        this._reportEngine = reportEngine;
    }

    public void setReportFormat(String reportFormat) {
        this._reportFormat = reportFormat;
    }

    public void setReportName(String reportName) {
        this._reportName = reportName;
    }

    public void setReportTemplate(String reportTemplate) {
        this._reportTemplate = reportTemplate;
    }

    public static Report unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (Report)Unmarshaller.unmarshal(Report.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

