/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.datacollection;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.common.Rrd;
import org.opennms.netmgt.config.datacollection.Groups;
import org.opennms.netmgt.config.datacollection.ResourceType;
import org.opennms.netmgt.config.datacollection.Systems;
import org.xml.sax.ContentHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnmpCollection
implements Serializable {
    private String _name;
    private int _maxVarsPerPdu;
    private boolean _has_maxVarsPerPdu;
    private String _snmpStorageFlag;
    private Rrd _rrd;
    private List<ResourceType> _resourceTypeList = new ArrayList<ResourceType>();
    private Groups _groups;
    private Systems _systems;

    public void addResourceType(ResourceType vResourceType) throws IndexOutOfBoundsException {
        this._resourceTypeList.add(vResourceType);
    }

    public void addResourceType(int index, ResourceType vResourceType) throws IndexOutOfBoundsException {
        this._resourceTypeList.add(index, vResourceType);
    }

    public void deleteMaxVarsPerPdu() {
        this._has_maxVarsPerPdu = false;
    }

    public Enumeration<ResourceType> enumerateResourceType() {
        return Collections.enumeration(this._resourceTypeList);
    }

    public Groups getGroups() {
        return this._groups;
    }

    public int getMaxVarsPerPdu() {
        return this._maxVarsPerPdu;
    }

    public String getName() {
        return this._name;
    }

    public ResourceType getResourceType(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._resourceTypeList.size()) {
            throw new IndexOutOfBoundsException("getResourceType: Index value '" + index + "' not in range [0.." + (this._resourceTypeList.size() - 1) + "]");
        }
        return this._resourceTypeList.get(index);
    }

    public ResourceType[] getResourceType() {
        ResourceType[] array = new ResourceType[]{};
        return this._resourceTypeList.toArray(array);
    }

    public List<ResourceType> getResourceTypeCollection() {
        return this._resourceTypeList;
    }

    public int getResourceTypeCount() {
        return this._resourceTypeList.size();
    }

    public Rrd getRrd() {
        return this._rrd;
    }

    public String getSnmpStorageFlag() {
        return this._snmpStorageFlag;
    }

    public Systems getSystems() {
        return this._systems;
    }

    public boolean hasMaxVarsPerPdu() {
        return this._has_maxVarsPerPdu;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<ResourceType> iterateResourceType() {
        return this._resourceTypeList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllResourceType() {
        this._resourceTypeList.clear();
    }

    public boolean removeResourceType(ResourceType vResourceType) {
        boolean removed = this._resourceTypeList.remove(vResourceType);
        return removed;
    }

    public ResourceType removeResourceTypeAt(int index) {
        ResourceType obj = this._resourceTypeList.remove(index);
        return obj;
    }

    public void setGroups(Groups groups) {
        this._groups = groups;
    }

    public void setMaxVarsPerPdu(int maxVarsPerPdu) {
        this._maxVarsPerPdu = maxVarsPerPdu;
        this._has_maxVarsPerPdu = true;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setResourceType(int index, ResourceType vResourceType) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._resourceTypeList.size()) {
            throw new IndexOutOfBoundsException("setResourceType: Index value '" + index + "' not in range [0.." + (this._resourceTypeList.size() - 1) + "]");
        }
        this._resourceTypeList.set(index, vResourceType);
    }

    public void setResourceType(ResourceType[] vResourceTypeArray) {
        this._resourceTypeList.clear();
        for (int i = 0; i < vResourceTypeArray.length; ++i) {
            this._resourceTypeList.add(vResourceTypeArray[i]);
        }
    }

    public void setResourceType(List<ResourceType> vResourceTypeList) {
        this._resourceTypeList.clear();
        this._resourceTypeList.addAll(vResourceTypeList);
    }

    public void setResourceTypeCollection(List<ResourceType> resourceTypeList) {
        this._resourceTypeList = resourceTypeList;
    }

    public void setRrd(Rrd rrd) {
        this._rrd = rrd;
    }

    public void setSnmpStorageFlag(String snmpStorageFlag) {
        this._snmpStorageFlag = snmpStorageFlag;
    }

    public void setSystems(Systems systems) {
        this._systems = systems;
    }

    public static SnmpCollection unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (SnmpCollection)Unmarshaller.unmarshal(SnmpCollection.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

