/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.common;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.common.JavamailProperty;
import org.opennms.netmgt.config.common.ReadmailHost;
import org.opennms.netmgt.config.common.UserAuth;
import org.xml.sax.ContentHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadmailConfig
implements Serializable {
    private boolean _debug = true;
    private boolean _has_debug;
    private String _mailFolder = "INBOX";
    private long _attemptInterval = 1000L;
    private boolean _has_attemptInterval;
    private boolean _deleteAllMail = false;
    private boolean _has_deleteAllMail;
    private String _name;
    private List<JavamailProperty> _javamailPropertyList;
    private ReadmailHost _readmailHost;
    private UserAuth _userAuth;

    public ReadmailConfig() {
        this.setMailFolder("INBOX");
        this._javamailPropertyList = new ArrayList<JavamailProperty>();
    }

    public void addJavamailProperty(JavamailProperty vJavamailProperty) throws IndexOutOfBoundsException {
        this._javamailPropertyList.add(vJavamailProperty);
    }

    public void addJavamailProperty(int index, JavamailProperty vJavamailProperty) throws IndexOutOfBoundsException {
        this._javamailPropertyList.add(index, vJavamailProperty);
    }

    public void deleteAttemptInterval() {
        this._has_attemptInterval = false;
    }

    public void deleteDebug() {
        this._has_debug = false;
    }

    public void deleteDeleteAllMail() {
        this._has_deleteAllMail = false;
    }

    public Enumeration<JavamailProperty> enumerateJavamailProperty() {
        return Collections.enumeration(this._javamailPropertyList);
    }

    public long getAttemptInterval() {
        return this._attemptInterval;
    }

    public boolean getDebug() {
        return this._debug;
    }

    public boolean getDeleteAllMail() {
        return this._deleteAllMail;
    }

    public JavamailProperty getJavamailProperty(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._javamailPropertyList.size()) {
            throw new IndexOutOfBoundsException("getJavamailProperty: Index value '" + index + "' not in range [0.." + (this._javamailPropertyList.size() - 1) + "]");
        }
        return this._javamailPropertyList.get(index);
    }

    public JavamailProperty[] getJavamailProperty() {
        JavamailProperty[] array = new JavamailProperty[]{};
        return this._javamailPropertyList.toArray(array);
    }

    public List<JavamailProperty> getJavamailPropertyCollection() {
        return this._javamailPropertyList;
    }

    public int getJavamailPropertyCount() {
        return this._javamailPropertyList.size();
    }

    public String getMailFolder() {
        return this._mailFolder;
    }

    public String getName() {
        return this._name;
    }

    public ReadmailHost getReadmailHost() {
        return this._readmailHost;
    }

    public UserAuth getUserAuth() {
        return this._userAuth;
    }

    public boolean hasAttemptInterval() {
        return this._has_attemptInterval;
    }

    public boolean hasDebug() {
        return this._has_debug;
    }

    public boolean hasDeleteAllMail() {
        return this._has_deleteAllMail;
    }

    public boolean isDebug() {
        return this._debug;
    }

    public boolean isDeleteAllMail() {
        return this._deleteAllMail;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<JavamailProperty> iterateJavamailProperty() {
        return this._javamailPropertyList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllJavamailProperty() {
        this._javamailPropertyList.clear();
    }

    public boolean removeJavamailProperty(JavamailProperty vJavamailProperty) {
        boolean removed = this._javamailPropertyList.remove(vJavamailProperty);
        return removed;
    }

    public JavamailProperty removeJavamailPropertyAt(int index) {
        JavamailProperty obj = this._javamailPropertyList.remove(index);
        return obj;
    }

    public void setAttemptInterval(long attemptInterval) {
        this._attemptInterval = attemptInterval;
        this._has_attemptInterval = true;
    }

    public void setDebug(boolean debug) {
        this._debug = debug;
        this._has_debug = true;
    }

    public void setDeleteAllMail(boolean deleteAllMail) {
        this._deleteAllMail = deleteAllMail;
        this._has_deleteAllMail = true;
    }

    public void setJavamailProperty(int index, JavamailProperty vJavamailProperty) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._javamailPropertyList.size()) {
            throw new IndexOutOfBoundsException("setJavamailProperty: Index value '" + index + "' not in range [0.." + (this._javamailPropertyList.size() - 1) + "]");
        }
        this._javamailPropertyList.set(index, vJavamailProperty);
    }

    public void setJavamailProperty(JavamailProperty[] vJavamailPropertyArray) {
        this._javamailPropertyList.clear();
        for (int i = 0; i < vJavamailPropertyArray.length; ++i) {
            this._javamailPropertyList.add(vJavamailPropertyArray[i]);
        }
    }

    public void setJavamailProperty(List<JavamailProperty> vJavamailPropertyList) {
        this._javamailPropertyList.clear();
        this._javamailPropertyList.addAll(vJavamailPropertyList);
    }

    public void setJavamailPropertyCollection(List<JavamailProperty> javamailPropertyList) {
        this._javamailPropertyList = javamailPropertyList;
    }

    public void setMailFolder(String mailFolder) {
        this._mailFolder = mailFolder;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setReadmailHost(ReadmailHost readmailHost) {
        this._readmailHost = readmailHost;
    }

    public void setUserAuth(UserAuth userAuth) {
        this._userAuth = userAuth;
    }

    public static ReadmailConfig unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (ReadmailConfig)Unmarshaller.unmarshal(ReadmailConfig.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

