/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.security;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.security.UsmUserEntry;
import org.snmp4j.smi.OctetString;

public class UsmUserTable
implements Serializable {
    private static final long serialVersionUID = 6936547777550957622L;
    private static final LogAdapter logger = LogFactory.getLogger(class$org$snmp4j$security$UsmUserTable == null ? (class$org$snmp4j$security$UsmUserTable = UsmUserTable.class$("org.snmp4j.security.UsmUserTable")) : class$org$snmp4j$security$UsmUserTable);
    private Map table = new TreeMap();
    static /* synthetic */ Class class$org$snmp4j$security$UsmUserTable;

    public synchronized UsmUserEntry addUser(UsmUserEntry user) {
        if (logger.isDebugEnabled()) {
            logger.debug("Adding user " + user.getUserName() + " = " + user.getUsmUser());
        }
        return this.table.put(new UsmUserKey(user), user);
    }

    public synchronized void setUsers(Collection c) {
        if (logger.isDebugEnabled()) {
            logger.debug("Setting users to " + c);
        }
        this.table.clear();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            UsmUserEntry user = (UsmUserEntry)it.next();
            this.table.put(new UsmUserKey(user), user);
        }
    }

    public synchronized List getUserEntries(OctetString userName) {
        LinkedList<UsmUserEntry> users = new LinkedList<UsmUserEntry>();
        Iterator it = this.table.values().iterator();
        while (it.hasNext()) {
            UsmUserEntry value = (UsmUserEntry)it.next();
            if (!userName.equals(value.getUserName())) continue;
            users.add(value);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Returning user entries for " + userName + " = " + users);
        }
        return users;
    }

    public synchronized List getUserEntries() {
        LinkedList l = new LinkedList();
        Iterator it = this.table.values().iterator();
        while (it.hasNext()) {
            l.add(it.next());
        }
        return l;
    }

    public synchronized UsmUserEntry removeUser(OctetString engineID, OctetString securityName) {
        UsmUserEntry entry = (UsmUserEntry)this.table.remove(new UsmUserKey(engineID, securityName));
        if (logger.isDebugEnabled()) {
            logger.debug("Removed user with secName=" + securityName + " and engineID=" + engineID);
        }
        return entry;
    }

    public synchronized UsmUserEntry getUser(OctetString engineID, OctetString securityName) {
        return (UsmUserEntry)this.table.get(new UsmUserKey(engineID, securityName));
    }

    public synchronized UsmUserEntry getUser(OctetString securityName) {
        return (UsmUserEntry)this.table.get(new UsmUserKey(new OctetString(), securityName));
    }

    public synchronized void clear() {
        this.table.clear();
        if (logger.isDebugEnabled()) {
            logger.debug("Cleared UsmUserTable");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class UsmUserKey
    implements Comparable {
        OctetString engineID;
        OctetString securityName;

        public UsmUserKey(UsmUserEntry entry) {
            this.setEngineID(entry.getEngineID());
            this.securityName = entry.getUsmUser().getSecurityName();
        }

        public UsmUserKey(OctetString engineID, OctetString securityName) {
            this.setEngineID(engineID);
            this.securityName = securityName;
        }

        private void setEngineID(OctetString engineID) {
            this.engineID = engineID == null ? new OctetString() : engineID;
        }

        public int hashCode() {
            return this.engineID.hashCode() ^ 2 + this.securityName.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof UsmUserEntry || o instanceof UsmUserKey) {
                return this.compareTo(o) == 0;
            }
            return false;
        }

        public int compareTo(Object o) {
            if (o instanceof UsmUserEntry) {
                return this.compareTo(new UsmUserKey((UsmUserEntry)o));
            }
            UsmUserKey other = (UsmUserKey)o;
            int result = 0;
            if (this.engineID != null && other.engineID != null) {
                result = this.engineID.compareTo(other.engineID);
            } else if (this.engineID != null && other.engineID == null) {
                result = 1;
            } else if (this.engineID == null && other.engineID != null) {
                result = -1;
            }
            if (result == 0) {
                result = this.securityName.compareTo(other.securityName);
            }
            return result;
        }
    }
}

