/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.security;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.security.AuthMD5;
import org.snmp4j.security.AuthSHA;
import org.snmp4j.security.AuthenticationProtocol;
import org.snmp4j.security.PrivAES128;
import org.snmp4j.security.PrivAES192;
import org.snmp4j.security.PrivAES256;
import org.snmp4j.security.PrivDES;
import org.snmp4j.security.PrivacyProtocol;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;

public class SecurityProtocols
implements Serializable {
    private static final long serialVersionUID = 3800474900139635836L;
    private Hashtable authProtocols = new Hashtable(5);
    private Hashtable privProtocols = new Hashtable(5);
    public static final String SECURITY_PROTOCOLS_PROPERTIES = "org.snmp4j.securityProtocols";
    private static final String SECURITY_PROTOCOLS_PROPERTIES_DEFAULT = "SecurityProtocols.properties";
    private static final LogAdapter logger = LogFactory.getLogger(class$org$snmp4j$security$SecurityProtocols == null ? (class$org$snmp4j$security$SecurityProtocols = SecurityProtocols.class$("org.snmp4j.security.SecurityProtocols")) : class$org$snmp4j$security$SecurityProtocols);
    private static SecurityProtocols instance = null;
    private int maxAuthDigestLength = 0;
    private int maxPrivDecryptParamsLength = 0;
    static /* synthetic */ Class class$org$snmp4j$security$SecurityProtocols;

    protected SecurityProtocols() {
    }

    public static SecurityProtocols getInstance() {
        if (instance == null) {
            instance = new SecurityProtocols();
        }
        return instance;
    }

    public static void setSecurityProtocols(SecurityProtocols securityProtocols) {
        instance = securityProtocols;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void addDefaultProtocols() {
        if (SNMP4JSettings.isExtensibilityEnabled()) {
            String secProtocols;
            InputStream is = (class$org$snmp4j$security$SecurityProtocols == null ? (class$org$snmp4j$security$SecurityProtocols = SecurityProtocols.class$("org.snmp4j.security.SecurityProtocols")) : class$org$snmp4j$security$SecurityProtocols).getResourceAsStream(secProtocols = System.getProperty(SECURITY_PROTOCOLS_PROPERTIES, SECURITY_PROTOCOLS_PROPERTIES_DEFAULT));
            if (is == null) {
                throw new InternalError("Could not read '" + secProtocols + "' from classpath!");
            }
            Properties props = new Properties();
            try {
                props.load(is);
                Enumeration<?> en = props.propertyNames();
                while (en.hasMoreElements()) {
                    String className = (String)en.nextElement();
                    try {
                        Class<?> c = Class.forName(className);
                        Object proto = c.newInstance();
                        if (proto instanceof AuthenticationProtocol) {
                            this.addAuthenticationProtocol((AuthenticationProtocol)proto);
                            continue;
                        }
                        if (proto instanceof PrivacyProtocol) {
                            this.addPrivacyProtocol((PrivacyProtocol)proto);
                            continue;
                        }
                        logger.error("Failed to register security protocol because it does not implement required interfaces: " + className);
                    }
                    catch (Exception cnfe) {
                        logger.error(cnfe);
                        throw new InternalError(cnfe.toString());
                        return;
                    }
                }
            }
            catch (IOException iox) {
                String txt = "Could not read '" + secProtocols + "': " + iox.getMessage();
                logger.error(txt);
                throw new InternalError(txt);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    logger.warn(ex);
                }
            }
        }
        this.addAuthenticationProtocol(new AuthMD5());
        this.addAuthenticationProtocol(new AuthSHA());
        this.addPrivacyProtocol(new PrivDES());
        this.addPrivacyProtocol(new PrivAES128());
        this.addPrivacyProtocol(new PrivAES192());
        this.addPrivacyProtocol(new PrivAES256());
    }

    public synchronized void addAuthenticationProtocol(AuthenticationProtocol auth) {
        if (this.authProtocols.get(auth.getID()) == null) {
            this.authProtocols.put(auth.getID(), auth);
            if (auth.getDigestLength() > this.maxAuthDigestLength) {
                this.maxAuthDigestLength = auth.getDigestLength();
            }
        }
    }

    public AuthenticationProtocol getAuthenticationProtocol(OID id) {
        if (id == null) {
            return null;
        }
        return (AuthenticationProtocol)this.authProtocols.get(id);
    }

    public void removeAuthenticationProtocol(AuthenticationProtocol auth) {
        this.authProtocols.remove(auth.getID());
    }

    public synchronized void addPrivacyProtocol(PrivacyProtocol priv) {
        if (this.privProtocols.get(priv.getID()) == null) {
            this.privProtocols.put(priv.getID(), priv);
            if (priv.getDecryptParamsLength() > this.maxPrivDecryptParamsLength) {
                this.maxPrivDecryptParamsLength = priv.getDecryptParamsLength();
            }
        }
    }

    public PrivacyProtocol getPrivacyProtocol(OID id) {
        if (id == null) {
            return null;
        }
        return (PrivacyProtocol)this.privProtocols.get(id);
    }

    public void removePrivacyProtocol(PrivacyProtocol priv) {
        this.privProtocols.remove(priv.getID());
    }

    public byte[] passwordToKey(OID authProtocolID, OctetString passwordString, byte[] engineID) {
        AuthenticationProtocol protocol = (AuthenticationProtocol)this.authProtocols.get(authProtocolID);
        if (protocol == null) {
            return null;
        }
        return protocol.passwordToKey(passwordString, engineID);
    }

    public byte[] passwordToKey(OID privProtocolID, OID authProtocolID, OctetString passwordString, byte[] engineID) {
        AuthenticationProtocol authProtocol = (AuthenticationProtocol)this.authProtocols.get(authProtocolID);
        if (authProtocol == null) {
            return null;
        }
        PrivacyProtocol privProtocol = (PrivacyProtocol)this.privProtocols.get(privProtocolID);
        if (privProtocol == null) {
            return null;
        }
        byte[] key = authProtocol.passwordToKey(passwordString, engineID);
        if (key == null) {
            return null;
        }
        if (key.length >= privProtocol.getMinKeyLength()) {
            if (key.length > privProtocol.getMaxKeyLength()) {
                byte[] truncatedKey = new byte[privProtocol.getMaxKeyLength()];
                System.arraycopy(key, 0, truncatedKey, 0, privProtocol.getMaxKeyLength());
                return truncatedKey;
            }
            return key;
        }
        byte[] extKey = privProtocol.extendShortKey(key, passwordString, engineID, authProtocol);
        return extKey;
    }

    public int getMaxAuthDigestLength() {
        return this.maxAuthDigestLength;
    }

    public int getMaxPrivDecryptParamsLength() {
        return this.maxPrivDecryptParamsLength;
    }

    public byte[] truncateKey(byte[] key, int maxKeyLength) {
        byte[] truncatedNewKey = new byte[Math.min(maxKeyLength, key.length)];
        System.arraycopy(key, 0, truncatedNewKey, 0, truncatedNewKey.length);
        return truncatedNewKey;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

