/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.schema;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import liquibase.FileOpener;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringFileOpener
implements FileOpener {
    private ResourceLoader m_resourceLoader = new DefaultResourceLoader();

    public InputStream getResourceAsStream(String file) throws IOException {
        Resource resource = this.getResource(file);
        return resource.getInputStream();
    }

    public Enumeration<URL> getResources(String packageName) throws IOException {
        Vector<URL> tmp = new Vector<URL>();
        tmp.add(this.getResource(packageName).getURL());
        return tmp.elements();
    }

    public Resource getResource(String file) {
        File f = new File(file);
        if (f.exists()) {
            return this.getResourceLoader().getResource(file);
        }
        return this.getResourceLoader().getResource(this.adjustClasspath(file));
    }

    private String adjustClasspath(String file) {
        return !this.isClasspathPrefixPresent(file) ? "classpath:" + file : file;
    }

    public boolean isClasspathPrefixPresent(String file) {
        return file.startsWith("classpath:");
    }

    public ClassLoader toClassLoader() {
        return this.getResourceLoader().getClassLoader();
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.m_resourceLoader = resourceLoader;
    }

    public ResourceLoader getResourceLoader() {
        return this.m_resourceLoader;
    }
}

