/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.schema;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import liquibase.FileOpener;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseFactory;
import liquibase.log.LogFactory;
import org.opennms.core.schema.Migration;
import org.opennms.core.schema.MigrationException;
import org.opennms.core.schema.SpringFileOpener;
import org.opennms.core.utils.ThreadCategory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;

public class Migrator {
    public static final float POSTGRES_MIN_VERSION = 7.3f;
    public static final float POSTGRES_MAX_VERSION_PLUS_ONE = 9.1f;
    private DataSource m_dataSource;
    private DataSource m_adminDataSource;
    private Float m_databaseVersion;
    private boolean m_validateDatabaseVersion = true;
    private boolean m_createUser = true;
    private boolean m_createDatabase = true;

    public Migrator() {
        this.initLogging();
    }

    private void initLogging() {
        LogFactory.getLogger().setLevel(Level.INFO);
    }

    public DataSource getDataSource() {
        return this.m_dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.m_dataSource = dataSource;
    }

    public DataSource getAdminDataSource() {
        return this.m_adminDataSource;
    }

    public void setAdminDataSource(DataSource dataSource) {
        this.m_adminDataSource = dataSource;
    }

    public void setValidateDatabaseVersion(boolean validate) {
        this.m_validateDatabaseVersion = validate;
    }

    public void setCreateUser(boolean create) {
        this.m_createUser = create;
    }

    public void setCreateDatabase(boolean create) {
        this.m_createDatabase = create;
    }

    public Float getDatabaseVersion() throws MigrationException {
        if (this.m_databaseVersion == null) {
            String versionString = null;
            Statement st = null;
            ResultSet rs = null;
            Connection c = null;
            try {
                c = this.m_adminDataSource.getConnection();
                st = c.createStatement();
                rs = st.executeQuery("SELECT version()");
                if (!rs.next()) {
                    throw new MigrationException("Database didn't return any rows for 'SELECT version()'");
                }
                versionString = rs.getString(1);
                rs.close();
                st.close();
                this.cleanUpDatabase(c, st, rs);
            }
            catch (SQLException e) {
                try {
                    throw new MigrationException("an error occurred getting the version from the database", e);
                }
                catch (Throwable throwable) {
                    this.cleanUpDatabase(c, st, rs);
                    throw throwable;
                }
            }
            Matcher m = Pattern.compile("^PostgreSQL (\\d+\\.\\d+)").matcher(versionString);
            if (!m.find()) {
                throw new MigrationException("Could not parse version number out of version string: " + versionString);
            }
            this.m_databaseVersion = Float.valueOf(Float.parseFloat(m.group(1)));
        }
        return this.m_databaseVersion;
    }

    public void validateDatabaseVersion() throws MigrationException {
        if (!this.m_validateDatabaseVersion) {
            return;
        }
        Float dbv = this.getDatabaseVersion();
        if (dbv == null) {
            throw new MigrationException("unable to determine database version");
        }
        String message = "Unsupported database version \"" + dbv + "\" -- you need at least " + 7.3f + " and less than " + 9.1f + ".  Use the \"-Q\" option to disable this check if you feel brave and are willing " + "to find and fix bugs found yourself.";
        if (dbv.floatValue() < 7.3f || dbv.floatValue() >= 9.1f) {
            throw new MigrationException(message);
        }
    }

    public void createLangPlPgsql() throws MigrationException {
        Statement st = null;
        ResultSet rs = null;
        Connection c = null;
        try {
            c = this.m_adminDataSource.getConnection();
            st = c.createStatement();
            rs = st.executeQuery("SELECT oid FROM pg_proc WHERE proname='plpgsql_call_handler' AND proargtypes = ''");
            if (!rs.next()) {
                st.execute("CREATE FUNCTION plpgsql_call_handler () RETURNS OPAQUE AS '$libdir/plpgsql.so' LANGUAGE 'c'");
            }
            if (!(rs = st.executeQuery("SELECT pg_language.oid FROM pg_language, pg_proc WHERE pg_proc.proname='plpgsql_call_handler' AND pg_proc.proargtypes = '' AND pg_proc.oid = pg_language.lanplcallfoid AND pg_language.lanname = 'plpgsql'")).next()) {
                st.execute("CREATE TRUSTED PROCEDURAL LANGUAGE 'plpgsql' HANDLER plpgsql_call_handler LANCOMPILER 'PL/pgSQL'");
            }
            this.cleanUpDatabase(c, st, rs);
        }
        catch (SQLException e) {
            try {
                throw new MigrationException("an error occurred getting the version from the database", e);
            }
            catch (Throwable throwable) {
                this.cleanUpDatabase(c, st, rs);
                throw throwable;
            }
        }
    }

    public boolean databaseUserExists(Migration migration) throws MigrationException {
        Connection c;
        ResultSet rs;
        Statement st;
        block6: {
            block7: {
                st = null;
                rs = null;
                c = null;
                c = this.m_adminDataSource.getConnection();
                st = c.createStatement();
                rs = st.executeQuery("SELECT usename FROM pg_user WHERE usename = '" + migration.getDatabaseUser() + "'");
                if (!rs.next()) break block6;
                String datname = rs.getString("usename");
                if (datname == null || !datname.equalsIgnoreCase(migration.getDatabaseUser())) break block7;
                boolean bl = true;
                this.cleanUpDatabase(c, st, rs);
                return bl;
            }
            boolean bl = false;
            this.cleanUpDatabase(c, st, rs);
            return bl;
        }
        try {
            boolean datname = rs.next();
            this.cleanUpDatabase(c, st, rs);
            return datname;
        }
        catch (SQLException e) {
            try {
                throw new MigrationException("an error occurred determining whether the OpenNMS user exists", e);
            }
            catch (Throwable throwable) {
                this.cleanUpDatabase(c, st, rs);
                throw throwable;
            }
        }
    }

    public void createUser(Migration migration) throws MigrationException {
        if (!this.m_createUser || this.databaseUserExists(migration)) {
            return;
        }
        Statement st = null;
        ResultSet rs = null;
        Connection c = null;
        try {
            c = this.m_adminDataSource.getConnection();
            st = c.createStatement();
            st.execute("CREATE USER " + migration.getDatabaseUser() + " WITH PASSWORD '" + migration.getDatabasePassword() + "' CREATEDB CREATEUSER");
        }
        catch (SQLException e) {
            throw new MigrationException("an error occurred creating the OpenNMS user", e);
        }
        finally {
            this.cleanUpDatabase(c, st, rs);
        }
    }

    public boolean databaseExists(Migration migration) throws MigrationException {
        Connection c;
        ResultSet rs;
        Statement st;
        block6: {
            block7: {
                st = null;
                rs = null;
                c = null;
                c = this.m_adminDataSource.getConnection();
                st = c.createStatement();
                rs = st.executeQuery("SELECT datname from pg_database WHERE datname = '" + migration.getDatabaseName() + "'");
                if (!rs.next()) break block6;
                String datname = rs.getString("datname");
                if (datname == null || !datname.equalsIgnoreCase(migration.getDatabaseName())) break block7;
                boolean bl = true;
                this.cleanUpDatabase(c, st, rs);
                return bl;
            }
            boolean bl = false;
            this.cleanUpDatabase(c, st, rs);
            return bl;
        }
        try {
            boolean datname = rs.next();
            this.cleanUpDatabase(c, st, rs);
            return datname;
        }
        catch (SQLException e) {
            try {
                throw new MigrationException("an error occurred determining whether the OpenNMS user exists", e);
            }
            catch (Throwable throwable) {
                this.cleanUpDatabase(c, st, rs);
                throw throwable;
            }
        }
    }

    public void createDatabase(Migration migration) throws MigrationException {
        if (!this.m_createDatabase || this.databaseExists(migration)) {
            return;
        }
        if (!this.databaseUserExists(migration)) {
            throw new MigrationException(String.format("database will not be created: unable to grant access (user %s does not exist)", migration.getDatabaseUser()));
        }
        Statement st = null;
        ResultSet rs = null;
        Connection c = null;
        try {
            c = this.m_adminDataSource.getConnection();
            st = c.createStatement();
            st.execute("CREATE DATABASE \"" + migration.getDatabaseName() + "\" WITH ENCODING='UNICODE'");
            st.execute("GRANT ALL ON DATABASE \"" + migration.getDatabaseName() + "\" TO \"" + migration.getDatabaseUser() + "\"");
        }
        catch (SQLException e) {
            throw new MigrationException("an error occurred creating the OpenNMS database", e);
        }
        finally {
            this.cleanUpDatabase(c, st, rs);
        }
    }

    public void prepareDatabase(Migration migration) throws MigrationException {
        this.log().info("validating database version");
        this.validateDatabaseVersion();
        this.log().info("adding PL/PgSQL support to the database, if necessary");
        this.createLangPlPgsql();
        this.log().info("creating OpenNMS user, if necessary");
        this.createUser(migration);
        this.log().info("creating OpenNMS database, if necessary");
        this.createDatabase(migration);
    }

    public void migrate(Migration migration) throws MigrationException {
        Database database;
        Connection connection;
        SpringFileOpener sfo = new SpringFileOpener();
        sfo.setResourceLoader(this.getMigrationResourceLoader(migration));
        try {
            connection = this.m_dataSource.getConnection();
        }
        catch (Exception e) {
            throw new MigrationException("unable to get a database connection from the datasource", e);
        }
        try {
            database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation(connection);
        }
        catch (Exception e) {
            this.cleanUpDatabase(connection, null, null);
            throw new MigrationException("unable to determine the Liquibase database object", e);
        }
        Liquibase liquibase = new Liquibase(migration.getChangeLog(), (FileOpener)sfo, database);
        liquibase.setChangeLogParameterValue("install.database.admin.user", (Object)migration.getAdminUser());
        liquibase.setChangeLogParameterValue("install.database.admin.password", (Object)migration.getAdminPassword());
        liquibase.setChangeLogParameterValue("install.database.user", (Object)migration.getDatabaseUser());
        String contexts = System.getProperty("opennms.contexts", "production");
        try {
            liquibase.update(contexts);
        }
        catch (Exception e) {
            this.cleanUpDatabase(connection, null, null);
            throw new MigrationException("unable to update the database", e);
        }
        this.cleanUpDatabase(connection, null, null);
    }

    protected ResourceLoader getMigrationResourceLoader(Migration migration) {
        File changeLog = new File(migration.getChangeLog());
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            if (changeLog.exists()) {
                urls.add(changeLog.getParentFile().toURI().toURL());
            }
        }
        catch (MalformedURLException e) {
            this.log().warn("unable to figure out URL for " + migration.getChangeLog(), (Throwable)e);
        }
        URLClassLoader cl = new URLClassLoader(urls.toArray(new URL[0]), this.getClass().getClassLoader());
        return new DefaultResourceLoader((ClassLoader)cl);
    }

    private void cleanUpDatabase(Connection c, Statement st, ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                this.log().warn("unable to close version-check result set", (Throwable)e);
            }
        }
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException e) {
                this.log().warn("unable to close version-check statement", (Throwable)e);
            }
        }
        if (c != null) {
            try {
                c.close();
            }
            catch (SQLException e) {
                this.log().warn("unable to close version-check connection", (Throwable)e);
            }
        }
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(Migrator.class);
    }
}

