/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.MessageUtil;
import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.AnnotatedElement;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.VersionedDataInputStream;
import org.aspectj.weaver.WeaverMessages;
import org.aspectj.weaver.World;
import org.aspectj.weaver.patterns.AnnotationTypePattern;
import org.aspectj.weaver.patterns.Bindings;
import org.aspectj.weaver.patterns.ExactAnnotationTypePattern;
import org.aspectj.weaver.patterns.ExactTypePattern;
import org.aspectj.weaver.patterns.IScope;
import org.aspectj.weaver.patterns.PatternNodeVisitor;
import org.aspectj.weaver.patterns.TypePattern;

public class WildAnnotationTypePattern
extends AnnotationTypePattern {
    private TypePattern typePattern;
    private boolean resolved = false;
    Map annotationValues;
    private static final byte VERSION = 1;

    public WildAnnotationTypePattern(TypePattern typePattern) {
        this.typePattern = typePattern;
        this.setLocation(typePattern.getSourceContext(), typePattern.start, typePattern.end);
    }

    public WildAnnotationTypePattern(TypePattern typePattern, Map annotationValues) {
        this.typePattern = typePattern;
        this.annotationValues = annotationValues;
        this.setLocation(typePattern.getSourceContext(), typePattern.start, typePattern.end);
    }

    public TypePattern getTypePattern() {
        return this.typePattern;
    }

    public FuzzyBoolean matches(AnnotatedElement annotated) {
        return this.matches(annotated, null);
    }

    protected void resolveAnnotationValues(ResolvedType annotationType, IScope scope) {
        if (this.annotationValues == null) {
            return;
        }
        Set keys = this.annotationValues.keySet();
        ResolvedMember[] ms = annotationType.getDeclaredMethods();
        Iterator kIter = keys.iterator();
        while (kIter.hasNext()) {
            String k = (String)kIter.next();
            String v = (String)this.annotationValues.get(k);
            boolean validKey = false;
            for (int i = 0; i < ms.length; ++i) {
                IMessage m;
                ResolvedMember resolvedMember = ms[i];
                if (!resolvedMember.getName().equals(k) || !resolvedMember.isAbstract()) continue;
                validKey = true;
                ResolvedType t = resolvedMember.getReturnType().resolve(scope.getWorld());
                if (t.isEnum()) {
                    int pos = v.lastIndexOf(".");
                    if (pos == -1) {
                        m = MessageUtil.error(WeaverMessages.format("invalidAnnotationValue", v, "enum"), this.getSourceLocation());
                        scope.getWorld().getMessageHandler().handleMessage(m);
                        continue;
                    }
                    String typename = v.substring(0, pos);
                    ResolvedType rt = scope.lookupType(typename, this).resolve(scope.getWorld());
                    v = rt.getSignature() + v.substring(pos + 1);
                    this.annotationValues.put(k, v);
                    continue;
                }
                if (t.isPrimitiveType()) {
                    if (t.getSignature() == "I") {
                        try {
                            int value = Integer.parseInt(v);
                            this.annotationValues.put(k, Integer.toString(value));
                        }
                        catch (NumberFormatException nfe) {
                            m = MessageUtil.error(WeaverMessages.format("invalidAnnotationValue", v, "int"), this.getSourceLocation());
                            scope.getWorld().getMessageHandler().handleMessage(m);
                        }
                        continue;
                    }
                    if (t.getSignature() == "F") {
                        try {
                            float value = Float.parseFloat(v);
                            this.annotationValues.put(k, Float.toString(value));
                        }
                        catch (NumberFormatException nfe) {
                            m = MessageUtil.error(WeaverMessages.format("invalidAnnotationValue", v, "float"), this.getSourceLocation());
                            scope.getWorld().getMessageHandler().handleMessage(m);
                        }
                        continue;
                    }
                    if (t.getSignature() == "Z") {
                        if (v.equalsIgnoreCase("true") || v.equalsIgnoreCase("false")) continue;
                        IMessage m2 = MessageUtil.error(WeaverMessages.format("invalidAnnotationValue", v, "boolean"), this.getSourceLocation());
                        scope.getWorld().getMessageHandler().handleMessage(m2);
                        continue;
                    }
                    if (t.getSignature() == "S") {
                        try {
                            short value = Short.parseShort(v);
                            this.annotationValues.put(k, Short.toString(value));
                        }
                        catch (NumberFormatException nfe) {
                            m = MessageUtil.error(WeaverMessages.format("invalidAnnotationValue", v, "short"), this.getSourceLocation());
                            scope.getWorld().getMessageHandler().handleMessage(m);
                        }
                        continue;
                    }
                    if (t.getSignature() == "J") {
                        try {
                            long value = Long.parseLong(v);
                            this.annotationValues.put(k, Long.toString(value));
                        }
                        catch (NumberFormatException nfe) {
                            m = MessageUtil.error(WeaverMessages.format("invalidAnnotationValue", v, "long"), this.getSourceLocation());
                            scope.getWorld().getMessageHandler().handleMessage(m);
                        }
                        continue;
                    }
                    if (t.getSignature() == "D") {
                        try {
                            double value = Double.parseDouble(v);
                            this.annotationValues.put(k, Double.toString(value));
                        }
                        catch (NumberFormatException nfe) {
                            m = MessageUtil.error(WeaverMessages.format("invalidAnnotationValue", v, "double"), this.getSourceLocation());
                            scope.getWorld().getMessageHandler().handleMessage(m);
                        }
                        continue;
                    }
                    if (t.getSignature() == "B") {
                        try {
                            byte value = Byte.parseByte(v);
                            this.annotationValues.put(k, Byte.toString(value));
                        }
                        catch (NumberFormatException nfe) {
                            m = MessageUtil.error(WeaverMessages.format("invalidAnnotationValue", v, "byte"), this.getSourceLocation());
                            scope.getWorld().getMessageHandler().handleMessage(m);
                        }
                        continue;
                    }
                    if (t.getSignature() == "C") {
                        if (v.length() != 3) {
                            IMessage m3 = MessageUtil.error(WeaverMessages.format("invalidAnnotationValue", v, "char"), this.getSourceLocation());
                            scope.getWorld().getMessageHandler().handleMessage(m3);
                            continue;
                        }
                        this.annotationValues.put(k, v.substring(1, 2));
                        continue;
                    }
                    throw new RuntimeException("Not implemented for " + t);
                }
                if (t.equals(UnresolvedType.JAVA_LANG_STRING)) continue;
                throw new RuntimeException("Compiler limitation: annotation value support not implemented for type " + t);
            }
            if (validKey) continue;
            IMessage m = MessageUtil.error(WeaverMessages.format("unknownAnnotationValue", annotationType, k), this.getSourceLocation());
            scope.getWorld().getMessageHandler().handleMessage(m);
        }
    }

    public FuzzyBoolean matches(AnnotatedElement annotated, ResolvedType[] parameterAnnotations) {
        block6: {
            block5: {
                if (!this.resolved) {
                    throw new IllegalStateException("Can't match on an unresolved annotation type pattern");
                }
                if (this.annotationValues != null) {
                    throw new IllegalStateException("Cannot use annotationvalues with a wild annotation pattern");
                }
                if (!this.isForParameterAnnotationMatch()) break block5;
                if (parameterAnnotations == null || parameterAnnotations.length == 0) break block6;
                for (int i = 0; i < parameterAnnotations.length; ++i) {
                    if (!this.typePattern.matches(parameterAnnotations[i], TypePattern.STATIC).alwaysTrue()) continue;
                    return FuzzyBoolean.YES;
                }
                break block6;
            }
            ResolvedType[] annTypes = annotated.getAnnotationTypes();
            if (annTypes != null && annTypes.length != 0) {
                for (int i = 0; i < annTypes.length; ++i) {
                    if (!this.typePattern.matches(annTypes[i], TypePattern.STATIC).alwaysTrue()) continue;
                    return FuzzyBoolean.YES;
                }
            }
        }
        return FuzzyBoolean.NO;
    }

    public void resolve(World world) {
        this.resolved = true;
    }

    public AnnotationTypePattern resolveBindings(IScope scope, Bindings bindings, boolean allowBinding) {
        if (!scope.getWorld().isInJava5Mode()) {
            scope.message(MessageUtil.error(WeaverMessages.format("annotationsRequireJava5"), this.getSourceLocation()));
            return this;
        }
        if (this.resolved) {
            return this;
        }
        this.typePattern = this.typePattern.resolveBindings(scope, bindings, false, false);
        this.resolved = true;
        if (this.typePattern instanceof ExactTypePattern) {
            ExactTypePattern et = (ExactTypePattern)this.typePattern;
            if (!et.getExactType().resolve(scope.getWorld()).isAnnotation()) {
                IMessage m = MessageUtil.error(WeaverMessages.format("referenceToNonAnnotationType", et.getExactType().getName()), this.getSourceLocation());
                scope.getWorld().getMessageHandler().handleMessage(m);
                this.resolved = false;
            }
            ResolvedType annotationType = et.getExactType().resolve(scope.getWorld());
            this.resolveAnnotationValues(annotationType, scope);
            ExactAnnotationTypePattern eatp = new ExactAnnotationTypePattern(annotationType, this.annotationValues);
            eatp.copyLocationFrom(this);
            if (this.isForParameterAnnotationMatch()) {
                eatp.setForParameterAnnotationMatch();
            }
            return eatp;
        }
        return this;
    }

    public AnnotationTypePattern parameterizeWith(Map typeVariableMap, World w) {
        WildAnnotationTypePattern ret = new WildAnnotationTypePattern(this.typePattern.parameterizeWith(typeVariableMap, w));
        ret.copyLocationFrom(this);
        ret.resolved = this.resolved;
        return ret;
    }

    public void write(DataOutputStream s) throws IOException {
        s.writeByte(8);
        s.writeByte(1);
        this.typePattern.write(s);
        this.writeLocation(s);
        s.writeBoolean(this.isForParameterAnnotationMatch());
        if (this.annotationValues == null) {
            s.writeInt(0);
        } else {
            s.writeInt(this.annotationValues.size());
            Set key = this.annotationValues.keySet();
            Iterator keys = key.iterator();
            while (keys.hasNext()) {
                String k = (String)keys.next();
                s.writeUTF(k);
                s.writeUTF((String)this.annotationValues.get(k));
            }
        }
    }

    public static AnnotationTypePattern read(VersionedDataInputStream s, ISourceContext context) throws IOException {
        int annotationValueCount;
        byte version = s.readByte();
        if (version > 1) {
            throw new BCException("ExactAnnotationTypePattern was written by a newer version of AspectJ");
        }
        TypePattern t = TypePattern.read(s, context);
        WildAnnotationTypePattern ret = new WildAnnotationTypePattern(t);
        ret.readLocation(context, s);
        if (s.getMajorVersion() >= 4 && s.readBoolean()) {
            ret.setForParameterAnnotationMatch();
        }
        if (s.getMajorVersion() >= 5 && (annotationValueCount = s.readInt()) > 0) {
            HashMap<String, String> aValues = new HashMap<String, String>();
            for (int i = 0; i < annotationValueCount; ++i) {
                String key = s.readUTF();
                String val = s.readUTF();
                aValues.put(key, val);
            }
            ret.annotationValues = aValues;
        }
        return ret;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WildAnnotationTypePattern)) {
            return false;
        }
        WildAnnotationTypePattern other = (WildAnnotationTypePattern)obj;
        return other.typePattern.equals(this.typePattern) && this.isForParameterAnnotationMatch() == other.isForParameterAnnotationMatch() && (this.annotationValues == null ? other.annotationValues == null : ((Object)this.annotationValues).equals(other.annotationValues));
    }

    public int hashCode() {
        return ((17 + 37 * this.typePattern.hashCode()) * 37 + (this.isForParameterAnnotationMatch() ? 0 : 1)) * 37 + (this.annotationValues == null ? 0 : ((Object)this.annotationValues).hashCode());
    }

    public String toString() {
        return "@(" + this.typePattern.toString() + ")";
    }

    public Object accept(PatternNodeVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }
}

