/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.opennms.netmgt.model.OnmsLocationMonitor;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.PollStatus;

@Entity
@Table(name="location_specific_status_changes")
public class OnmsLocationSpecificStatus {
    private Integer m_id;
    private OnmsLocationMonitor m_locationMonitor;
    private OnmsMonitoredService m_monitoredService;
    private PollStatus m_pollResult;

    public OnmsLocationSpecificStatus() {
    }

    public OnmsLocationSpecificStatus(OnmsLocationMonitor locationMonitor, OnmsMonitoredService monitoredService, PollStatus pollResult) {
        this.m_locationMonitor = locationMonitor;
        this.m_monitoredService = monitoredService;
        this.m_pollResult = pollResult;
    }

    @Id
    @SequenceGenerator(name="opennmsSequence", sequenceName="opennmsNxtId")
    @GeneratedValue(generator="opennmsSequence")
    public Integer getId() {
        return this.m_id;
    }

    public void setId(Integer id) {
        this.m_id = id;
    }

    @ManyToOne(optional=false, fetch=FetchType.EAGER)
    @JoinColumn(name="locationMonitorId")
    public OnmsLocationMonitor getLocationMonitor() {
        return this.m_locationMonitor;
    }

    public void setLocationMonitor(OnmsLocationMonitor locationMonitor) {
        this.m_locationMonitor = locationMonitor;
    }

    @ManyToOne(optional=false, fetch=FetchType.EAGER)
    @JoinColumn(name="ifServiceId")
    public OnmsMonitoredService getMonitoredService() {
        return this.m_monitoredService;
    }

    public void setMonitoredService(OnmsMonitoredService monitoredService) {
        this.m_monitoredService = monitoredService;
    }

    @Embedded
    public PollStatus getPollResult() {
        return this.m_pollResult;
    }

    public void setPollResult(PollStatus newStatus) {
        this.m_pollResult = newStatus;
    }

    @Transient
    public int getStatusCode() {
        return this.m_pollResult.getStatusCode();
    }
}

