/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.reporting.core.svclayer.support;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.api.reporting.ReportException;
import org.opennms.api.reporting.ReportFormat;
import org.opennms.api.reporting.ReportService;
import org.opennms.api.reporting.parameter.ReportParameters;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.javamail.JavaMailer;
import org.opennms.javamail.JavaMailerException;
import org.opennms.netmgt.config.UserFactory;
import org.opennms.netmgt.config.UserManager;
import org.opennms.netmgt.model.ReportCatalogEntry;
import org.opennms.reporting.core.DeliveryOptions;
import org.opennms.reporting.core.svclayer.ReportServiceLocator;
import org.opennms.reporting.core.svclayer.ReportStoreService;
import org.opennms.reporting.core.svclayer.ReportWrapperService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultReportWrapperService
implements ReportWrapperService {
    private ReportServiceLocator m_reportServiceLocator;
    private ThreadCategory log;
    private ReportStoreService m_reportStoreService;
    private static final String LOG4J_CATEGORY = "OpenNMS.Report";

    public DefaultReportWrapperService() {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        this.log = ThreadCategory.getInstance(DefaultReportWrapperService.class);
    }

    @Override
    public DeliveryOptions getDeliveryOptions(String reportId, String userId) {
        DeliveryOptions options = new DeliveryOptions();
        options.setFormat(ReportFormat.HTML);
        options.setPersist(true);
        options.setSendMail(false);
        UserManager userFactory = UserFactory.getInstance();
        try {
            String emailAddress = userFactory.getEmail(userId);
            if (emailAddress != null) {
                options.setMailTo(userFactory.getEmail(userId));
            }
        }
        catch (MarshalException e) {
            this.log.error("marshal exception trying to set destination email address", (Throwable)e);
        }
        catch (ValidationException e) {
            this.log.error("validation exception trying to set destination email address", (Throwable)e);
        }
        catch (IOException e) {
            this.log.error("IO exception trying to set destination email address", (Throwable)e);
        }
        options.setInstanceId(reportId + "_" + userId);
        return options;
    }

    @Override
    public List<ReportFormat> getFormats(String reportId) {
        return this.getReportService(reportId).getFormats(reportId);
    }

    @Override
    public ReportParameters getParameters(String reportId) {
        return this.getReportService(reportId).getParameters(reportId);
    }

    @Override
    public Boolean hasParameters(String reportId) {
        HashMap reportParms = this.getParameters(reportId).getReportParms();
        if (reportParms == null || reportParms.isEmpty()) {
            return false;
        }
        return true;
    }

    @Override
    public void render(String reportId, String location, ReportFormat format, OutputStream outputStream) {
        try {
            this.getReportService(reportId).render(reportId, location, format, outputStream);
        }
        catch (ReportException e) {
            this.log.error("failed to render report", (Throwable)e);
        }
    }

    @Override
    public void run(ReportParameters parameters, DeliveryOptions deliveryOptions, String reportId) {
        if (!deliveryOptions.getPersist().booleanValue()) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            BufferedOutputStream bout = new BufferedOutputStream(out);
            try {
                this.getReportService(reportId).runAndRender(parameters.getReportParms(), reportId, deliveryOptions.getFormat(), (OutputStream)bout);
            }
            catch (ReportException reportException) {
                this.log.error("failed to run or render report: " + reportId, (Throwable)reportException);
            }
            this.mailReport(deliveryOptions, out);
        } else {
            try {
                String outputPath = this.getReportService(reportId).run(parameters.getReportParms(), reportId);
                ReportCatalogEntry catalogEntry = new ReportCatalogEntry();
                catalogEntry.setReportId(reportId);
                catalogEntry.setTitle(deliveryOptions.getInstanceId());
                catalogEntry.setLocation(outputPath);
                catalogEntry.setDate(new Date());
                this.m_reportStoreService.save(catalogEntry);
                if (deliveryOptions.getMailTo().length() != 0) {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    BufferedOutputStream bout = new BufferedOutputStream(out);
                    this.getReportService(reportId).render(reportId, outputPath, deliveryOptions.getFormat(), (OutputStream)bout);
                    this.mailReport(deliveryOptions, out);
                }
            }
            catch (ReportException reportException) {
                this.log.error("failed to run or render report: " + reportId, (Throwable)reportException);
            }
        }
    }

    private void mailReport(DeliveryOptions deliveryOptions, ByteArrayOutputStream outputStream) {
        try {
            JavaMailer jm = new JavaMailer();
            jm.setTo(deliveryOptions.getMailTo());
            jm.setSubject("OpenNMS Report");
            jm.setMessageText("Here is your report from the OpenNMS report service.");
            jm.setInputStream((InputStream)new ByteArrayInputStream(outputStream.toByteArray()));
            switch (deliveryOptions.getFormat()) {
                case HTML: {
                    jm.setInputStreamName("report.htm");
                    jm.setInputStreamContentType("text/html");
                    break;
                }
                case PDF: {
                    jm.setInputStreamName("report.pdf");
                    jm.setInputStreamContentType("application/pdf");
                    break;
                }
                case SVG: {
                    jm.setInputStreamName("svgreport.pdf");
                    jm.setInputStreamContentType("application/pdf");
                    break;
                }
                default: {
                    jm.setInputStreamName("report.htm");
                    jm.setInputStreamContentType("text/html");
                }
            }
            jm.mailSend();
        }
        catch (JavaMailerException e) {
            this.log.error("Caught JavaMailer exception sending report", (Throwable)e);
        }
    }

    @Override
    public boolean validate(ReportParameters parameters, String reportId) {
        return this.getReportService(reportId).validate(parameters.getReportParms(), reportId);
    }

    private ReportService getReportService(String reportId) {
        return this.m_reportServiceLocator.getReportServiceForId(reportId);
    }

    public void setReportServiceLocator(ReportServiceLocator reportServiceLocator) {
        this.m_reportServiceLocator = reportServiceLocator;
    }

    public void setReportStoreService(ReportStoreService reportStoreService) {
        this.m_reportStoreService = reportStoreService;
    }

    @Override
    public void runAndRender(ReportParameters parameters, OutputStream outputStream) {
        HashMap reportParms = parameters.getReportParms();
        for (String key : reportParms.keySet()) {
            String value = reportParms.get(key) == null ? "NULL" : reportParms.get(key).toString();
            this.log.debug("param " + key + " set " + value);
        }
        try {
            this.getReportService(parameters.getReportId()).runAndRender(parameters.getReportParms(), parameters.getReportId(), parameters.getFormat(), outputStream);
        }
        catch (ReportException reportException) {
            this.log.error("failed to run or render report: " + parameters.getReportId(), (Throwable)reportException);
        }
    }
}

