/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.reporting.core.svclayer.support;

import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opennms.api.reporting.ReportException;
import org.opennms.api.reporting.ReportFormat;
import org.opennms.api.reporting.ReportService;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.databaseReports.Report;
import org.opennms.netmgt.dao.DatabaseReportConfigDao;
import org.opennms.netmgt.dao.ReportCatalogDao;
import org.opennms.netmgt.model.ReportCatalogEntry;
import org.opennms.reporting.core.svclayer.ReportServiceLocator;
import org.opennms.reporting.core.svclayer.ReportStoreService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultReportStoreService
implements ReportStoreService {
    private ReportCatalogDao m_reportCatalogDao;
    private ReportServiceLocator m_reportServiceLocator;
    private DatabaseReportConfigDao m_databaseReportConfigDao;
    private static final String LOG4J_CATEGORY = "OpenNMS.Report";
    private ThreadCategory log;

    public DefaultReportStoreService() {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        this.log = ThreadCategory.getInstance(DefaultReportStoreService.class);
    }

    @Override
    public void delete(Integer[] ids) {
        for (Integer id : ids) {
            this.delete(id);
        }
    }

    @Override
    public void delete(Integer id) {
        String deleteFile = new String(((ReportCatalogEntry)this.m_reportCatalogDao.get((Serializable)id)).getLocation());
        boolean success = new File(deleteFile).delete();
        if (success) {
            this.log().debug("deleted report XML file: " + deleteFile);
        } else {
            this.log().warn("unable to delete report XML file: " + deleteFile + " will delete reportCatalogEntry anyway");
        }
        this.m_reportCatalogDao.delete(id);
    }

    @Override
    public List<ReportCatalogEntry> getAll() {
        return this.m_reportCatalogDao.findAll();
    }

    @Override
    public Map<String, Object> getFormatMap() {
        HashMap<String, Object> formatMap = new HashMap<String, Object>();
        List reports = this.m_databaseReportConfigDao.getReports();
        for (Report report : reports) {
            String id = report.getId();
            String service = report.getReportService();
            List formats = this.m_reportServiceLocator.getReportService(service).getFormats(id);
            formatMap.put(id, formats);
        }
        return formatMap;
    }

    @Override
    public void render(Integer id, ReportFormat format, OutputStream outputStream) {
        ReportCatalogEntry catalogEntry = (ReportCatalogEntry)this.m_reportCatalogDao.get((Serializable)id);
        String reportServiceName = this.m_databaseReportConfigDao.getReportService(catalogEntry.getReportId());
        ReportService reportService = this.m_reportServiceLocator.getReportService(reportServiceName);
        this.log().debug("attempting to rended the report as " + format.toString() + " using " + reportServiceName);
        try {
            reportService.render(catalogEntry.getReportId(), catalogEntry.getLocation(), format, outputStream);
        }
        catch (ReportException e) {
            this.log.error("unable to render report", (Throwable)e);
        }
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    @Override
    public void save(ReportCatalogEntry reportCatalogEntry) {
        this.m_reportCatalogDao.save((Object)reportCatalogEntry);
    }

    @Override
    public void setReportCatalogDao(ReportCatalogDao reportCatalogDao) {
        this.m_reportCatalogDao = reportCatalogDao;
    }

    public void setDatabaseReportConfigDao(DatabaseReportConfigDao databaseReportConfigDao) {
        this.m_databaseReportConfigDao = databaseReportConfigDao;
    }

    @Override
    public void setReportServiceLocator(ReportServiceLocator reportServiceLocator) {
        this.m_reportServiceLocator = reportServiceLocator;
    }
}

