/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.reporting.core.svclayer.support;

import org.opennms.api.reporting.ReportService;
import org.opennms.netmgt.dao.DatabaseReportConfigDao;
import org.opennms.reporting.core.svclayer.ReportServiceLocator;
import org.opennms.reporting.core.svclayer.ReportServiceLocatorException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class DefaultReportServiceLocator
implements ApplicationContextAware,
ReportServiceLocator {
    private ApplicationContext m_applicationContext;
    private DatabaseReportConfigDao m_databaseReportConfigDao;

    public ReportService getReportService(String reportServiceName) throws ReportServiceLocatorException {
        ReportService reportService = (ReportService)this.m_applicationContext.getBean(reportServiceName);
        if (reportService == null) {
            throw new ReportServiceLocatorException("cannot locate report service bean: " + reportServiceName);
        }
        return reportService;
    }

    public ReportService getReportServiceForId(String reportId) throws ReportServiceLocatorException {
        return this.getReportService(this.m_databaseReportConfigDao.getReportService(reportId));
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.m_applicationContext = applicationContext;
    }

    public void setDatabaseReportConfigDao(DatabaseReportConfigDao databaseReportConfigDao) {
        this.m_databaseReportConfigDao = databaseReportConfigDao;
    }
}

