/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.reporting.core.svclayer.support;

import java.util.ArrayList;
import java.util.Calendar;
import org.opennms.api.reporting.parameter.ReportDateParm;
import org.opennms.api.reporting.parameter.ReportIntParm;
import org.opennms.api.reporting.parameter.ReportParameters;
import org.opennms.api.reporting.parameter.ReportStringParm;
import org.opennms.netmgt.config.reporting.DateParm;
import org.opennms.netmgt.config.reporting.IntParm;
import org.opennms.netmgt.config.reporting.Parameters;
import org.opennms.netmgt.config.reporting.StringParm;
import org.opennms.reporting.core.svclayer.ParameterConversionService;

public class DefaultParameterConversionService
implements ParameterConversionService {
    public ReportParameters convert(Parameters configParameters) {
        ReportParameters reportParameters = new ReportParameters();
        ArrayList<ReportDateParm> dateParms = new ArrayList<ReportDateParm>();
        DateParm[] dates = configParameters.getDateParm();
        if (dates.length > 0) {
            for (int i = 0; i < dates.length; ++i) {
                ReportDateParm dateParm = new ReportDateParm();
                dateParm.setUseAbsoluteDate(Boolean.valueOf(dates[i].getUseAbsoluteDate()));
                dateParm.setDisplayName(dates[i].getDisplayName());
                dateParm.setName(dates[i].getName());
                dateParm.setCount(new Integer(dates[i].getDefaultCount()));
                dateParm.setInterval(dates[i].getDefaultInterval());
                Calendar cal = Calendar.getInstance();
                if (dates[i].getDefaultTime() != null) {
                    dateParm.setHours(Integer.valueOf(dates[i].getDefaultTime().getHours()));
                    cal.set(11, dateParm.getHours());
                    dateParm.setMinutes(Integer.valueOf(dates[i].getDefaultTime().getMinutes()));
                    cal.set(12, dateParm.getMinutes());
                } else {
                    cal.set(11, 0);
                    cal.set(12, 0);
                }
                cal.set(13, 0);
                cal.set(14, 0);
                int amount = 0 - dates[i].getDefaultCount();
                if (dates[i].getDefaultInterval().equals("year")) {
                    cal.add(1, amount);
                } else if (dates[i].getDefaultInterval().equals("month")) {
                    cal.add(2, amount);
                } else {
                    cal.add(5, amount);
                }
                dateParm.setValue(cal.getTime());
                dateParms.add(dateParm);
            }
        }
        reportParameters.setDateParms(dateParms);
        ArrayList<ReportStringParm> stringParms = new ArrayList<ReportStringParm>();
        StringParm[] strings = configParameters.getStringParm();
        if (strings.length > 0) {
            for (int i = 0; i < strings.length; ++i) {
                ReportStringParm stringParm = new ReportStringParm();
                stringParm.setDisplayName(strings[i].getDisplayName());
                stringParm.setName(strings[i].getName());
                stringParm.setInputType(strings[i].getInputType());
                stringParm.setValue(strings[i].getDefault());
                stringParms.add(stringParm);
            }
        }
        reportParameters.setStringParms(stringParms);
        ArrayList<ReportIntParm> intParms = new ArrayList<ReportIntParm>();
        IntParm[] integers = configParameters.getIntParm();
        if (integers.length > 0) {
            for (int i = 0; i < integers.length; ++i) {
                ReportIntParm intParm = new ReportIntParm();
                intParm.setDisplayName(integers[i].getDisplayName());
                intParm.setName(integers[i].getName());
                intParm.setInputType(integers[i].getInputType());
                intParm.setValue(integers[i].getDefault());
                intParms.add(intParm);
            }
        }
        reportParameters.setIntParms(intParms);
        return reportParameters;
    }
}

