/*
 * Decompiled with CFR 0.152.
 */
package net.simon04.jelementtree;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.simon04.jelementtree.ElementPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementTree
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 24L;
    private String tag;
    private Map<String, String> attributes = new TreeMap<String, String>();
    private ElementTree parent;
    private List<ElementTree> children = new LinkedList<ElementTree>();
    private String text;
    private String tail;

    public ElementTree(String string) {
        this.tag = string;
    }

    public ElementTree setAttribute(String string, String string2) {
        this.attributes.put(string, string2);
        return this;
    }

    public ElementTree addChild(ElementTree elementTree) {
        elementTree.parent = this;
        this.children.add(elementTree);
        return this;
    }

    public ElementTree addChild(int n, ElementTree elementTree) {
        elementTree.parent = this;
        this.children.add(n, elementTree);
        return this;
    }

    public ElementTree createChild(String string) {
        ElementTree elementTree = new ElementTree(string);
        this.addChild(elementTree);
        return elementTree;
    }

    public ElementTree setText(String string) {
        this.text = string;
        return this;
    }

    public ElementTree setTail(String string) {
        this.tail = string;
        return this;
    }

    public ElementTree setNamespace(String string) {
        return this.setNamespace(null, string);
    }

    public ElementTree setNamespace(String string, String string2) {
        String string3 = string == null ? "xmlns" : "xmlns:" + string;
        return this.setAttribute(string3, string2);
    }

    public List<ElementTree> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public ElementTree getChild(int n) {
        if (n < 0) {
            n += this.children.size();
        }
        return this.children.get(n);
    }

    public ElementTree getFirstChild() {
        return this.children.isEmpty() ? null : this.children.get(0);
    }

    public ElementTree getLastChild() {
        return this.children.isEmpty() ? null : this.children.get(this.children.size() - 1);
    }

    public String getAttribute(String string) {
        return this.attributes.get(string);
    }

    public String getTag() {
        return this.tag;
    }

    public String getTail() {
        return this.tail;
    }

    public String getText() {
        return this.text;
    }

    public Map<String, String> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public ElementTree getParent() {
        return this.parent;
    }

    public ElementTree getRoot() {
        ElementTree elementTree = this;
        while (elementTree.getParent() != null) {
            elementTree = elementTree.getParent();
        }
        return elementTree;
    }

    public ElementTree clone() {
        ElementTree elementTree = new ElementTree(this.tag);
        elementTree.attributes.putAll(this.attributes);
        elementTree.children.addAll(this.children);
        elementTree.text = this.text;
        elementTree.tail = this.tail;
        return elementTree;
    }

    public String toXML() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.parent == null) {
            stringBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        }
        stringBuilder.append("<");
        stringBuilder.append(this.tag);
        for (Map.Entry<String, String> object : this.attributes.entrySet()) {
            stringBuilder.append(" ");
            stringBuilder.append(object.getKey());
            stringBuilder.append("=\"");
            stringBuilder.append(ElementTree.escapeText(object.getValue()));
            stringBuilder.append("\"");
        }
        if (this.text == null && this.children.isEmpty()) {
            stringBuilder.append("/>");
        } else {
            stringBuilder.append(">");
            if (!this.children.isEmpty()) {
                stringBuilder.append("\n");
            }
            if (this.text != null) {
                stringBuilder.append(ElementTree.escapeText(this.text));
            }
            for (ElementTree elementTree : this.children) {
                stringBuilder.append(elementTree.toXML());
            }
            stringBuilder.append("</");
            stringBuilder.append(this.tag);
            stringBuilder.append(">\n");
        }
        if (this.tail != null) {
            stringBuilder.append(this.tail);
        }
        return stringBuilder.toString();
    }

    public List<ElementTree> findAll(String string) {
        return new ElementPath(string).findAll(this);
    }

    public ElementTree find(String string) {
        List<ElementTree> list = this.findAll(string);
        return list.size() == 0 ? null : list.get(0);
    }

    public String findText(String string) {
        ElementTree elementTree = this.find(string);
        return elementTree == null ? null : elementTree.getText();
    }

    private static String escapeText(String string) {
        return string.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\"", "&quot;").replaceAll("\n", "&#10;");
    }

    public String toString() {
        return this.toXML();
    }

    public static ElementTree fromString(String string) {
        return ElementTree.fromReader(new StringReader(string));
    }

    public static ElementTree fromReader(Reader reader) {
        try {
            XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
            XMLStreamReader xMLStreamReader = xMLInputFactory.createXMLStreamReader(reader);
            return ElementTree.fromParser(xMLStreamReader);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new RuntimeException(xMLStreamException.getMessage(), xMLStreamException);
        }
    }

    public static ElementTree fromStream(InputStream inputStream) {
        try {
            XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
            XMLStreamReader xMLStreamReader = xMLInputFactory.createXMLStreamReader(inputStream);
            return ElementTree.fromParser(xMLStreamReader);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new RuntimeException(xMLStreamException.getMessage(), xMLStreamException);
        }
    }

    private static ElementTree fromParser(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        ElementTree elementTree = null;
        while (xMLStreamReader.hasNext()) {
            switch (xMLStreamReader.getEventType()) {
                case 1: {
                    int n;
                    String string = xMLStreamReader.getName().getLocalPart();
                    String string2 = xMLStreamReader.getName().getPrefix();
                    if (string2 != null && string2.length() != 0) {
                        string = string2 + ":" + string;
                    }
                    elementTree = elementTree == null ? new ElementTree(string) : elementTree.createChild(string);
                    for (n = 0; n < xMLStreamReader.getAttributeCount(); ++n) {
                        elementTree.setAttribute(xMLStreamReader.getAttributeLocalName(n), xMLStreamReader.getAttributeValue(n));
                    }
                    for (n = 0; n < xMLStreamReader.getNamespaceCount(); ++n) {
                        elementTree.setNamespace(xMLStreamReader.getNamespacePrefix(n), xMLStreamReader.getNamespaceURI(n));
                    }
                    break;
                }
                case 2: {
                    if (elementTree == null || elementTree.parent == null) break;
                    elementTree = elementTree.parent;
                    break;
                }
                case 4: {
                    String string = xMLStreamReader.getText();
                    if (string == null || string.trim().length() == 0 || elementTree == null) break;
                    if (elementTree.children.isEmpty()) {
                        elementTree.text = string.trim();
                        break;
                    }
                    elementTree.getLastChild().tail = string.trim();
                }
            }
            xMLStreamReader.next();
        }
        return elementTree;
    }
}

