/*
 * Decompiled with CFR 0.152.
 */
package net.simon04.jelementtree;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.simon04.jelementtree.ElementTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementPath {
    private List<Operator> ops = new LinkedList<Operator>();
    private PathType type;
    private static String TAGPATTERN;

    ElementPath(String string) {
        PathType pathType = string.startsWith("/") ? PathType.ROOT : (this.type = string.startsWith("\\.") ? PathType.ELEMENT : PathType.CHILDREN);
        while (string.length() != 0) {
            Matcher matcher = Pattern.compile("^/?\\.\\.").matcher(string);
            if (matcher.find()) {
                this.ops.add(new Operator(){

                    @Override
                    public List<ElementTree> convert(ElementTree elementTree) {
                        return Arrays.asList(elementTree.getParent());
                    }
                });
            } else {
                matcher = Pattern.compile("^/?\\.").matcher(string);
                if (!matcher.find()) {
                    matcher = Pattern.compile("^//").matcher(string);
                    if (matcher.find()) {
                        this.ops.add(new Operator(){

                            @Override
                            public List<ElementTree> convert(ElementTree elementTree) {
                                LinkedList<ElementTree> linkedList = new LinkedList<ElementTree>();
                                linkedList.add(elementTree);
                                for (ElementTree elementTree2 : elementTree.getChildren()) {
                                    linkedList.addAll(this.convert(elementTree2));
                                }
                                return linkedList;
                            }
                        });
                    } else {
                        matcher = Pattern.compile("^\\*").matcher(string);
                        if (!matcher.find()) {
                            String string2;
                            matcher = Pattern.compile("^(" + TAGPATTERN + "+)").matcher(string);
                            if (matcher.find()) {
                                string2 = matcher.group(1);
                                this.ops.add(new Operator(){

                                    @Override
                                    public List<ElementTree> convert(ElementTree elementTree) {
                                        if (elementTree.getTag().equals(string2)) {
                                            return Arrays.asList(elementTree);
                                        }
                                        return Arrays.asList(new Object[0]);
                                    }
                                });
                            } else {
                                matcher = Pattern.compile("^\\[@(" + TAGPATTERN + "+)(=('" + TAGPATTERN + "+'))?\\]").matcher(string);
                                if (matcher.find()) {
                                    string2 = matcher.group(1);
                                    final String string3 = matcher.group(3).length() == 0 ? null : matcher.group(3);
                                    this.ops.add(new Operator(){

                                        @Override
                                        public List<ElementTree> convert(ElementTree elementTree) {
                                            if (string3 == null && elementTree.getAttribute(string2) != null || string3 != null && elementTree.getAttribute(string2).equals(string3)) {
                                                return Arrays.asList(elementTree);
                                            }
                                            return Arrays.asList(new Object[0]);
                                        }
                                    });
                                } else {
                                    matcher = Pattern.compile("^\\[(" + TAGPATTERN + "+)\\]").matcher(string);
                                    if (matcher.find()) {
                                        string2 = matcher.group(1);
                                        this.ops.add(new Operator(){

                                            @Override
                                            public List<ElementTree> convert(ElementTree elementTree) {
                                                boolean bl = false;
                                                for (ElementTree elementTree2 : elementTree.getChildren()) {
                                                    if (!elementTree2.getTag().equals(string2)) continue;
                                                    bl = true;
                                                    break;
                                                }
                                                if (bl) {
                                                    return Arrays.asList(elementTree);
                                                }
                                                return Arrays.asList(new Object[0]);
                                            }
                                        });
                                    } else {
                                        matcher = Pattern.compile("^/").matcher(string);
                                        if (matcher.find()) {
                                            this.ops.add(new Operator(){

                                                @Override
                                                public List<ElementTree> convert(ElementTree elementTree) {
                                                    return elementTree.getChildren();
                                                }
                                            });
                                        } else {
                                            throw new IllegalArgumentException("Invalid pattern specified; error at " + string);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            string = matcher.replaceFirst("");
        }
    }

    List<ElementTree> findAll(ElementTree elementTree) {
        LinkedHashSet<ElementTree> linkedHashSet = new LinkedHashSet<ElementTree>();
        switch (this.type) {
            case ELEMENT: {
                linkedHashSet.add(elementTree);
                break;
            }
            case CHILDREN: {
                linkedHashSet.addAll(elementTree.getChildren());
                break;
            }
            case ROOT: {
                linkedHashSet.add(elementTree.getRoot());
            }
        }
        for (Operator operator : this.ops) {
            LinkedHashSet<ElementTree> linkedHashSet2 = new LinkedHashSet<ElementTree>();
            for (ElementTree elementTree2 : linkedHashSet) {
                linkedHashSet2.addAll(operator.convert(elementTree2));
            }
            linkedHashSet = linkedHashSet2;
        }
        return new LinkedList<ElementTree>(linkedHashSet);
    }

    static {
        StringBuilder stringBuilder = new StringBuilder(1024).append("[").append(":").append("[A-Z]").append("_").append("[a-z]").append("[\\xC0-\\xD6]").append("[\\xD8-\\xF6]").append("[\\xF8-\\u02FF]").append("[\\u0370-\\u037D]").append("[\\u037F-\\u1FFF]").append("[\\u200C-\\u200D]").append("[\\u2070-\\u218F]").append("[\\u2C00-\\u2FEF]").append("[\\u3001-\\uD7FF]").append("[\\uF900-\\uFDCF]").append("[\\uFDF0-\\uFFFD]").append("[\\u10000-\\uEFFFF]").append("]");
        StringBuilder stringBuilder2 = new StringBuilder(1024).append("[").append((CharSequence)stringBuilder).append("\\-").append("\\.").append("\\xB7").append("[\\u0300-\\u036F]").append("[\\u203F-\\u2040]").append("]+");
        TAGPATTERN = stringBuilder.append((CharSequence)stringBuilder2).toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PathType {
        ROOT,
        ELEMENT,
        CHILDREN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Operator {
        public List<ElementTree> convert(ElementTree var1);
    }
}

