/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.remote;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.opennms.netmgt.model.NetworkBuilder;
import org.opennms.netmgt.model.OnmsDistPoller;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.poller.remote.OnmsPollModel;
import org.opennms.netmgt.poller.remote.PolledService;
import org.opennms.netmgt.poller.remote.PollerConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DemoPollerConfiguration
implements PollerConfiguration {
    Date m_timestamp;
    PolledService[] m_polledServices;

    DemoPollerConfiguration(Date timestamp) {
        this.m_timestamp = timestamp;
        OnmsServiceType http = new OnmsServiceType("HTTP");
        ArrayList<PolledService> polledServices = new ArrayList<PolledService>();
        OnmsDistPoller distPoller = new OnmsDistPoller("locahost", "127.0.0.1");
        NetworkBuilder m_builder = new NetworkBuilder(distPoller);
        m_builder.addNode("Google").setId(Integer.valueOf(1));
        m_builder.addInterface("64.233.161.99").setId(11);
        polledServices.add(this.createPolledService(111, m_builder.addService(http), new HashMap<String, Object>(), 3000L));
        m_builder.addInterface("64.233.161.104").setId(12);
        polledServices.add(this.createPolledService(121, m_builder.addService(http), new HashMap<String, Object>(), 3000L));
        m_builder.addNode("OpenNMS").setId(Integer.valueOf(2));
        m_builder.addInterface("209.61.128.9").setId(21);
        polledServices.add(this.createPolledService(211, m_builder.addService(http), new HashMap<String, Object>(), 3000L));
        this.m_polledServices = polledServices.toArray(new PolledService[polledServices.size()]);
    }

    DemoPollerConfiguration() {
        this(new Date());
    }

    @Override
    public Date getConfigurationTimestamp() {
        return this.m_timestamp;
    }

    @Override
    public PolledService[] getPolledServices() {
        return this.m_polledServices;
    }

    private PolledService createPolledService(int serviceID, OnmsMonitoredService service, Map<String, Object> monitorConfiguration, long interval) {
        service.setId(Integer.valueOf(serviceID));
        return new PolledService(service, monitorConfiguration, new OnmsPollModel(interval));
    }

    public int getFirstId() {
        return this.getFirstService().getServiceId();
    }

    public PolledService getFirstService() {
        return this.m_polledServices[0];
    }
}

