/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.ping.Pinger;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.NetworkInterfaceNotSupportedException;
import org.opennms.netmgt.poller.monitors.IPv4Monitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Distributable(value={DistributionContext.DAEMON})
public final class IcmpMonitor
extends IPv4Monitor {
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        NetworkInterface iface = svc.getNetInterface();
        if (iface.getType() != 1) {
            throw new NetworkInterfaceNotSupportedException("Unsupported interface type, only TYPE_IPV4 currently supported");
        }
        ThreadCategory log = ThreadCategory.getInstance(((Object)((Object)this)).getClass());
        Long rtt = null;
        InetAddress host = (InetAddress)iface.getAddress();
        try {
            int retries = ParameterMap.getKeyedInteger(parameters, (String)"retry", (int)2);
            long timeout = ParameterMap.getKeyedLong(parameters, (String)"timeout", (long)800L);
            rtt = Pinger.ping((InetAddress)host, (long)timeout, (int)retries);
        }
        catch (Exception e) {
            log.debug("failed to ping " + host, (Throwable)e);
        }
        if (rtt != null) {
            return PollStatus.available((Double)rtt.doubleValue());
        }
        return PollStatus.unavailable();
    }
}

