/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller;

import java.io.File;
import org.opennms.netmgt.collectd.CollectionResource;
import org.opennms.netmgt.collectd.CollectionSetVisitor;
import org.opennms.netmgt.collectd.ServiceParameters;
import org.opennms.netmgt.model.RrdRepository;

public class LatencyCollectionResource
implements CollectionResource {
    private String m_serviceName;
    private String m_ipAddress;

    public LatencyCollectionResource(String serviceName, String ipAddress) {
        this.m_serviceName = serviceName;
        this.m_ipAddress = ipAddress;
    }

    public String getInstance() {
        return this.m_ipAddress + "[" + this.m_serviceName + "]";
    }

    public String getServiceName() {
        return this.m_serviceName;
    }

    public String getIpAddress() {
        return this.m_ipAddress;
    }

    public String getLabel() {
        return this.m_serviceName;
    }

    public String getResourceTypeName() {
        return "if";
    }

    public int getType() {
        return 0;
    }

    public boolean rescanNeeded() {
        return false;
    }

    public boolean shouldPersist(ServiceParameters params) {
        return true;
    }

    public void visit(CollectionSetVisitor visitor) {
    }

    public String getOwnerName() {
        return this.m_ipAddress;
    }

    public File getResourceDir(RrdRepository repository) {
        return new File(repository.getRrdBaseDir(), this.m_ipAddress);
    }

    public String toString() {
        return this.m_serviceName + "@" + this.m_ipAddress;
    }
}

