/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.capsd.plugins.IcmpPlugin;
import org.opennms.netmgt.config.OpennmsServerConfigFactory;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventListener;
import org.opennms.netmgt.poller.QueryManager;
import org.opennms.netmgt.poller.pollables.PendingPollEvent;
import org.opennms.netmgt.poller.pollables.PollContext;
import org.opennms.netmgt.poller.pollables.PollEvent;
import org.opennms.netmgt.poller.pollables.PollableService;
import org.opennms.netmgt.xml.event.Event;

public class DefaultPollContext
implements PollContext,
EventListener {
    private volatile PollerConfig m_pollerConfig;
    private volatile QueryManager m_queryManager;
    private volatile EventIpcManager m_eventManager;
    private volatile String m_name;
    private volatile String m_localHostName;
    private volatile boolean m_listenerAdded = false;
    private final List<PendingPollEvent> m_pendingPollEvents = new LinkedList<PendingPollEvent>();

    public EventIpcManager getEventManager() {
        return this.m_eventManager;
    }

    public void setEventManager(EventIpcManager eventManager) {
        this.m_eventManager = eventManager;
    }

    public void setLocalHostName(String localHostName) {
        this.m_localHostName = localHostName;
    }

    public String getLocalHostName() {
        return this.m_localHostName;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public PollerConfig getPollerConfig() {
        return this.m_pollerConfig;
    }

    public void setPollerConfig(PollerConfig pollerConfig) {
        this.m_pollerConfig = pollerConfig;
    }

    public QueryManager getQueryManager() {
        return this.m_queryManager;
    }

    public void setQueryManager(QueryManager queryManager) {
        this.m_queryManager = queryManager;
    }

    public String getCriticalServiceName() {
        return this.getPollerConfig().getCriticalService();
    }

    public boolean isNodeProcessingEnabled() {
        return this.getPollerConfig().nodeOutageProcessingEnabled();
    }

    public boolean isPollingAllIfCritServiceUndefined() {
        return this.getPollerConfig().pollAllIfNoCriticalServiceDefined();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollEvent sendEvent(Event event) {
        if (!this.m_listenerAdded) {
            this.getEventManager().addEventListener(this);
            this.m_listenerAdded = true;
        }
        PendingPollEvent pollEvent = new PendingPollEvent(event);
        List<PendingPollEvent> list = this.m_pendingPollEvents;
        synchronized (list) {
            this.m_pendingPollEvents.add(pollEvent);
        }
        this.getEventManager().sendNow(event);
        return pollEvent;
    }

    ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public Event createEvent(String uei, int nodeId, InetAddress address, String svcName, Date date, String reason) {
        ThreadCategory log = ThreadCategory.getInstance(this.getClass());
        if (log.isDebugEnabled()) {
            log.debug("createEvent: uei = " + uei + " nodeid = " + nodeId);
        }
        EventBuilder bldr = new EventBuilder(uei, this.getName(), date);
        bldr.setNodeid(nodeId);
        if (address != null) {
            bldr.setInterface(address.getHostAddress());
        }
        if (svcName != null) {
            bldr.setService(svcName);
        }
        bldr.setHost(this.getLocalHostName());
        if (uei.equals("uei.opennms.org/nodes/nodeDown") && this.getPollerConfig().pathOutageEnabled()) {
            String[] criticalPath = this.getQueryManager().getCriticalPath(nodeId);
            if (criticalPath[0] != null && !criticalPath[0].equals("")) {
                if (!this.testCriticalPath(criticalPath)) {
                    log.debug("Critical path test failed for node " + nodeId);
                    bldr.addParam("eventReason", "pathOutage");
                    bldr.addParam("criticalPathIp", criticalPath[0]);
                    bldr.addParam("criticalPathServiceName", criticalPath[1]);
                } else {
                    log.debug("Critical path test passed for node " + nodeId);
                }
            } else {
                log.debug("No Critical path to test for node " + nodeId);
            }
        }
        if (uei.equals("uei.opennms.org/nodes/nodeLostService")) {
            bldr.addParam("eventReason", reason == null ? "Unknown" : reason);
        }
        if (uei.equals("uei.opennms.org/nodes/nodeUp") || uei.equals("uei.opennms.org/nodes/nodeDown")) {
            String nodeLabel = this.getNodeLabel(nodeId);
            bldr.addParam("nodelabel", nodeLabel);
        }
        return bldr.getEvent();
    }

    public void openOutage(final PollableService svc, final PollEvent svcLostEvent) {
        this.log().debug("openOutage: Opening outage for: " + svc + " with event:" + svcLostEvent);
        final int nodeId = svc.getNodeId();
        final String ipAddr = svc.getIpAddr();
        final String svcName = svc.getSvcName();
        Runnable r = new Runnable(){

            public void run() {
                DefaultPollContext.this.log().debug("run: Opening outage with query manager: " + svc + " with event:" + svcLostEvent);
                DefaultPollContext.this.getQueryManager().openOutage(DefaultPollContext.this.getPollerConfig().getNextOutageIdSql(), nodeId, ipAddr, svcName, svcLostEvent.getEventId(), EventConstants.formatToString((Date)svcLostEvent.getDate()));
            }
        };
        if (svcLostEvent instanceof PendingPollEvent) {
            ((PendingPollEvent)svcLostEvent).addPending(r);
        } else {
            r.run();
        }
    }

    public void resolveOutage(PollableService svc, final PollEvent svcRegainEvent) {
        final int nodeId = svc.getNodeId();
        final String ipAddr = svc.getIpAddr();
        final String svcName = svc.getSvcName();
        Runnable r = new Runnable(){

            public void run() {
                DefaultPollContext.this.getQueryManager().resolveOutage(nodeId, ipAddr, svcName, svcRegainEvent.getEventId(), EventConstants.formatToString((Date)svcRegainEvent.getDate()));
            }
        };
        if (svcRegainEvent instanceof PendingPollEvent) {
            ((PendingPollEvent)svcRegainEvent).addPending(r);
        } else {
            r.run();
        }
    }

    public void reparentOutages(String ipAddr, int oldNodeId, int newNodeId) {
        this.getQueryManager().reparentOutages(ipAddr, oldNodeId, newNodeId);
    }

    public boolean isServiceUnresponsiveEnabled() {
        return this.getPollerConfig().serviceUnresponsiveEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(Event e) {
        List<PendingPollEvent> list = this.m_pendingPollEvents;
        synchronized (list) {
            this.log().debug("onEvent: Received event: " + e + " uei: " + e.getUei() + ", dbid: " + e.getDbid());
            for (PendingPollEvent pollEvent : this.m_pendingPollEvents) {
                this.log().debug("onEvent: comparing events to poll event: " + pollEvent);
                if (!e.equals(pollEvent.getEvent())) continue;
                this.log().debug("onEvent: completing pollevent: " + pollEvent);
                pollEvent.complete(e);
            }
            Iterator<PendingPollEvent> it = this.m_pendingPollEvents.iterator();
            while (it.hasNext()) {
                PendingPollEvent pollEvent;
                pollEvent = it.next();
                this.log().debug("onEvent: determining if pollEvent is pending: " + pollEvent);
                if (pollEvent.isPending()) continue;
                this.log().debug("onEvent: processing pending pollEvent...: " + pollEvent);
                pollEvent.processPending();
                it.remove();
                this.log().debug("onEvent: processing of pollEvent completed.: " + pollEvent);
            }
        }
    }

    boolean testCriticalPath(String[] criticalPath) {
        InetAddress addr = null;
        boolean result = true;
        ThreadCategory log = this.log();
        log.debug("Test critical path IP " + criticalPath[0]);
        try {
            addr = InetAddress.getByName(criticalPath[0]);
        }
        catch (UnknownHostException e) {
            log.error("failed to convert string address to InetAddress " + criticalPath[0]);
            return true;
        }
        IcmpPlugin p = new IcmpPlugin();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("retry", new Long(OpennmsServerConfigFactory.getInstance().getDefaultCriticalPathRetries()));
        map.put("timeout", new Long(OpennmsServerConfigFactory.getInstance().getDefaultCriticalPathTimeout()));
        result = p.isProtocolSupported(addr, map);
        return result;
    }

    String getNodeLabel(int nodeId) {
        String nodeLabel = null;
        try {
            nodeLabel = this.getQueryManager().getNodeLabel(nodeId);
        }
        catch (SQLException sqlE) {
            this.log().warn("Failed to retrieve node label for nodeid " + nodeId, (Throwable)sqlE);
        }
        if (nodeLabel == null) {
            nodeLabel = String.valueOf(nodeId);
        }
        return nodeLabel;
    }
}

