/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd.scheduler;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.opennms.core.concurrent.RunnableConsumerThreadPool;
import org.opennms.core.fiber.PausableFiber;
import org.opennms.core.queue.FifoQueue;
import org.opennms.core.queue.FifoQueueException;
import org.opennms.core.queue.FifoQueueImpl;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.linkd.scheduler.ReadyRunnable;
import org.opennms.netmgt.linkd.scheduler.ScheduleTimer;

public class Scheduler
implements Runnable,
PausableFiber,
ScheduleTimer {
    public Map<Long, PeekableFifoQueue<ReadyRunnable>> m_queues;
    public int m_scheduled;
    public RunnableConsumerThreadPool m_runner;
    private String m_name;
    public int m_status;
    private Thread m_worker;

    public Scheduler(String parent, int maxSize) {
        this.m_name = parent + "Scheduler-" + maxSize;
        this.m_status = 0;
        this.m_runner = new RunnableConsumerThreadPool(this.m_name + " Pool", 0.6f, 1.0f, maxSize);
        this.m_queues = Collections.synchronizedMap(new TreeMap());
        this.m_scheduled = 0;
        this.m_worker = null;
    }

    public Scheduler(String parent, int maxSize, float lowMark, float hiMark) {
        this.m_name = parent + "Scheduler-" + maxSize;
        this.m_status = 0;
        this.m_runner = new RunnableConsumerThreadPool(this.m_name + " Pool", lowMark, hiMark, maxSize);
        this.m_queues = Collections.synchronizedMap(new TreeMap());
        this.m_scheduled = 0;
        this.m_worker = null;
    }

    public synchronized void schedule(ReadyRunnable runnable, long interval) {
        Long key;
        if (this.log().isDebugEnabled()) {
            this.log().debug("schedule: Adding ready runnable at interval " + interval);
        }
        if (!this.m_queues.containsKey(key = new Long(interval))) {
            if (this.log().isDebugEnabled()) {
                this.log().debug("schedule: interval queue did not exist, a new one has been created");
            }
            this.m_queues.put(key, new PeekableFifoQueue());
        }
        try {
            this.m_queues.get(key).add(runnable);
            if (this.m_scheduled++ == 0) {
                if (this.log().isDebugEnabled()) {
                    this.log().debug("schedule: queue element added, calling notify all since none were scheduled");
                }
                this.notifyAll();
            } else if (this.log().isDebugEnabled()) {
                this.log().debug("schedule: queue element added, notification not performed");
            }
        }
        catch (InterruptedException ie) {
            if (this.log().isInfoEnabled()) {
                this.log().info("schedule: failed to add new ready runnable instance " + runnable + " to scheduler", (Throwable)ie);
            }
            Thread.currentThread().interrupt();
        }
        catch (FifoQueueException ex) {
            if (this.log().isInfoEnabled()) {
                this.log().info("schedule: failed to add new ready runnable instance " + runnable + " to scheduler", (Throwable)ex);
            }
            throw new UndeclaredThrowableException(ex);
        }
    }

    public synchronized void schedule(long interval, final ReadyRunnable runnable) {
        final long timeToRun = this.getCurrentTime() + interval;
        ReadyRunnable timeKeeper = new ReadyRunnable(){

            public boolean isReady() {
                return Scheduler.this.getCurrentTime() >= timeToRun && runnable.isReady();
            }

            public String getInfo() {
                return runnable.getInfo();
            }

            public void run() {
                runnable.run();
            }

            public void schedule() {
                runnable.schedule();
            }

            public void suspend() {
                runnable.suspend();
            }

            public void wakeUp() {
                runnable.wakeUp();
            }

            public boolean isSuspended() {
                return runnable.isSuspended();
            }

            public boolean equals(ReadyRunnable r) {
                return runnable.equals(r);
            }

            public void unschedule() {
                runnable.unschedule();
            }

            public String toString() {
                return runnable.toString() + " (ready in " + Math.max(0L, timeToRun - Scheduler.this.getCurrentTime()) + "ms)";
            }

            public String getPackageName() {
                return runnable.getPackageName();
            }

            public void setPackageName(String pkg) {
                runnable.setPackageName(pkg);
            }
        };
        this.schedule(timeKeeper, interval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unschedule(ReadyRunnable runnable) {
        if (this.log().isDebugEnabled()) {
            this.log().debug("unschedule: Removing all " + runnable.getInfo());
        }
        boolean done = false;
        Map<Long, PeekableFifoQueue<ReadyRunnable>> map = this.m_queues;
        synchronized (map) {
            Iterator<Long> iter = this.m_queues.keySet().iterator();
            while (iter.hasNext() && !done) {
                Long key = iter.next();
                this.unschedule(runnable, key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unschedule(ReadyRunnable runnable, long interval) {
        if (this.log().isDebugEnabled()) {
            this.log().debug("unschedule: Removing " + runnable.getInfo() + " at interval " + interval);
        }
        Long key = new Long(interval);
        Map<Long, PeekableFifoQueue<ReadyRunnable>> map = this.m_queues;
        synchronized (map) {
            if (!this.m_queues.containsKey(key)) {
                if (this.log().isDebugEnabled()) {
                    this.log().debug("unschedule: interval queue did not exist, exit");
                }
                return;
            }
            PeekableFifoQueue<ReadyRunnable> in = this.m_queues.get(key);
            if (in.isEmpty()) {
                if (this.log().isDebugEnabled()) {
                    this.log().debug("unschedule: interval queue is empty, exit");
                }
                return;
            }
            ReadyRunnable readyRun = null;
            int maxLoops = in.size();
            boolean first = true;
            do {
                try {
                    readyRun = in.remove();
                    if (in.size() == maxLoops && first) {
                        ++maxLoops;
                    }
                    first = false;
                    if (readyRun != null && readyRun.equals(runnable)) {
                        if (this.log().isDebugEnabled()) {
                            this.log().debug("unschedule: removing found " + readyRun.getInfo());
                        }
                        --this.m_scheduled;
                        continue;
                    }
                    in.add(readyRun);
                }
                catch (InterruptedException ie) {
                    if (this.log().isInfoEnabled()) {
                        this.log().info("unschedule: failed to remove instance " + runnable.getInfo() + " from scheduler", (Throwable)ie);
                    }
                    Thread.currentThread().interrupt();
                }
                catch (FifoQueueException ex) {
                    if (this.log().isInfoEnabled()) {
                        this.log().info("unschedule: failed to remove instance " + runnable.getInfo() + " from scheduler", (Throwable)ex);
                    }
                    throw new UndeclaredThrowableException(ex);
                }
            } while (--maxLoops > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ReadyRunnable getReadyRunnable(ReadyRunnable runnable) {
        if (this.log().isDebugEnabled()) {
            this.log().debug("getReadyRunnable: Retriving " + runnable.getInfo());
        }
        ReadyRunnable rr = null;
        Map<Long, PeekableFifoQueue<ReadyRunnable>> map = this.m_queues;
        synchronized (map) {
            Iterator<Long> iter = this.m_queues.keySet().iterator();
            while (iter.hasNext() && rr == null) {
                Long interval = iter.next();
                rr = this.getReadyRunnable(runnable, interval);
            }
        }
        if (rr == null && this.log().isInfoEnabled()) {
            this.log().info("getReadyRunnable: instance " + runnable.getInfo() + " not found on scheduler");
        }
        return rr;
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ReadyRunnable getReadyRunnable(ReadyRunnable runnable, long interval) {
        Long key;
        if (this.log().isDebugEnabled()) {
            this.log().debug("getReadyRunnable: Retriving " + runnable.getInfo() + " at interval " + interval);
        }
        if (!this.m_queues.containsKey(key = new Long(interval))) {
            this.log().warn("getReadyRunnable: interval queue did not exist, exit");
            return null;
        }
        ReadyRunnable rr = null;
        Map<Long, PeekableFifoQueue<ReadyRunnable>> map = this.m_queues;
        synchronized (map) {
            PeekableFifoQueue<ReadyRunnable> in = this.m_queues.get(key);
            if (in.isEmpty()) {
                this.log().warn("getReadyRunnable: queue is Empty");
                return null;
            }
            int maxLoops = in.size();
            ReadyRunnable readyRun = null;
            boolean first = true;
            do {
                try {
                    readyRun = in.remove();
                    if (in.size() == maxLoops && first) {
                        ++maxLoops;
                    }
                    first = false;
                    if (readyRun != null && readyRun.equals(runnable)) {
                        if (this.log().isDebugEnabled()) {
                            this.log().debug("getReadyRunnable: found ready runnable " + readyRun);
                        }
                        rr = readyRun;
                    }
                    in.add(readyRun);
                }
                catch (InterruptedException ie) {
                    if (this.log().isInfoEnabled()) {
                        this.log().info("getReadyRunnable: failed to get instance " + readyRun.getInfo() + " from scheduler", (Throwable)ie);
                    }
                    Thread.currentThread().interrupt();
                }
                catch (FifoQueueException ex) {
                    if (this.log().isInfoEnabled()) {
                        this.log().info("getReadyRunnable: failed to get instance " + readyRun.getInfo() + " from scheduler", (Throwable)ex);
                    }
                    throw new UndeclaredThrowableException(ex);
                }
            } while (--maxLoops > 0);
        }
        if (rr == null && this.log().isInfoEnabled()) {
            this.log().info("getReadyRunnable: instance " + runnable.getInfo() + " not found on scheduler");
        }
        return rr;
    }

    public long getCurrentTime() {
        return System.currentTimeMillis();
    }

    public synchronized void start() {
        if (this.m_worker != null) {
            throw new IllegalStateException("The fiber has already run or is running");
        }
        this.m_runner.start();
        this.m_worker = new Thread((Runnable)this, this.getName());
        this.m_worker.start();
        this.m_status = 1;
        if (this.log().isDebugEnabled()) {
            this.log().debug("start: scheduler started");
        }
    }

    public synchronized void stop() {
        if (this.m_worker == null) {
            throw new IllegalStateException("The fiber has never been started");
        }
        this.m_status = 3;
        this.m_worker.interrupt();
        this.m_runner.stop();
        if (this.log().isDebugEnabled()) {
            this.log().debug("stop: scheduler stopped");
        }
    }

    public synchronized void pause() {
        if (this.m_worker == null) {
            throw new IllegalStateException("The fiber has never been started");
        }
        if (this.m_status == 4 || this.m_status == 3) {
            throw new IllegalStateException("The fiber is not running or a stop is pending");
        }
        if (this.m_status == 6) {
            return;
        }
        this.m_status = 5;
        this.notifyAll();
    }

    public synchronized void resume() {
        if (this.m_worker == null) {
            throw new IllegalStateException("The fiber has never been started");
        }
        if (this.m_status == 4 || this.m_status == 3) {
            throw new IllegalStateException("The fiber is not running or a stop is pending");
        }
        if (this.m_status == 2) {
            return;
        }
        this.m_status = 7;
        this.notifyAll();
    }

    public synchronized int getStatus() {
        if (this.m_worker != null && !this.m_worker.isAlive()) {
            this.m_status = 4;
        }
        return this.m_status;
    }

    public String getName() {
        return this.m_runner.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Scheduler scheduler = this;
        synchronized (scheduler) {
            this.m_status = 2;
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug("run: scheduler running");
        }
        while (true) {
            scheduler = this;
            synchronized (scheduler) {
                if (this.m_status != 2 && this.m_status != 6 && this.m_status != 5 && this.m_status != 7) {
                    if (this.log().isDebugEnabled()) {
                        this.log().debug("run: status = " + this.m_status + ", time to exit");
                    }
                    break;
                }
                if (this.m_scheduled == 0) {
                    try {
                        if (this.log().isDebugEnabled()) {
                            this.log().debug("run: no interfaces scheduled, waiting...");
                        }
                        this.wait();
                    }
                    catch (InterruptedException ex) {
                        break;
                    }
                }
            }
            int runned = 0;
            FifoQueue out = this.m_runner.getRunQueue();
            Object object = this.m_queues;
            synchronized (object) {
                for (Long key : this.m_queues.keySet()) {
                    PeekableFifoQueue<ReadyRunnable> in = this.m_queues.get(key);
                    if (in.isEmpty()) continue;
                    ReadyRunnable readyRun = null;
                    int maxLoops = in.size();
                    do {
                        try {
                            readyRun = in.peek();
                            if (readyRun == null || !readyRun.isReady()) continue;
                            if (this.log().isDebugEnabled()) {
                                this.log().debug("run: found ready runnable " + readyRun.getInfo());
                            }
                            in.remove();
                            out.add((Object)readyRun);
                            ++runned;
                        }
                        catch (InterruptedException ex) {
                            return;
                        }
                        catch (FifoQueueException qe) {
                            throw new UndeclaredThrowableException(qe);
                        }
                    } while (readyRun != null && readyRun.isReady() && --maxLoops > 0);
                }
            }
            object = this;
            synchronized (object) {
                this.m_scheduled -= runned;
                if (runned == 0) {
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException ex) {
                        break;
                    }
                }
            }
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug("run: scheduler exiting, state = STOPPED");
        }
        Scheduler scheduler2 = this;
        synchronized (scheduler2) {
            this.m_status = 4;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class PeekableFifoQueue<T>
    extends FifoQueueImpl<T> {
        private T m_hold = null;

        PeekableFifoQueue() {
        }

        public synchronized T peek() throws InterruptedException, FifoQueueException {
            if (this.m_hold == null) {
                this.m_hold = super.remove(1L);
            }
            return this.m_hold;
        }

        public synchronized T remove() throws InterruptedException, FifoQueueException {
            Object rval = null;
            if (this.m_hold != null) {
                rval = this.m_hold;
                this.m_hold = null;
            } else {
                rval = super.remove();
            }
            return (T)rval;
        }

        public synchronized T remove(long timeout) throws InterruptedException, FifoQueueException {
            Object rval = null;
            if (this.m_hold != null) {
                rval = this.m_hold;
                this.m_hold = null;
            } else {
                rval = super.remove(timeout);
            }
            return (T)rval;
        }

        public boolean isEmpty() {
            if (this.m_hold != null) {
                return false;
            }
            return super.isEmpty();
        }
    }
}

