/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.discovery;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.ping.PingResponseCallback;
import org.opennms.protocols.icmp.ICMPEchoPacket;

public class DiscoveryPingResponseCallback
implements PingResponseCallback {
    static final String EVENT_SOURCE_VALUE = "OpenNMS.Discovery";

    public void handleResponse(InetAddress address, ICMPEchoPacket packet) {
        EventBuilder eb = new EventBuilder("uei.opennms.org/internal/discovery/newSuspect", EVENT_SOURCE_VALUE);
        eb.setInterface(address.getHostAddress());
        try {
            eb.setHost(InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException uhE) {
            eb.setHost("unresolved.host");
            this.log().warn("Failed to resolve local hostname", (Throwable)uhE);
        }
        eb.addParam("RTT", packet.getReceivedTime() - packet.getSentTime());
        try {
            EventIpcManagerFactory.getIpcManager().sendNow(eb.getEvent());
            if (this.log().isDebugEnabled()) {
                this.log().debug("Sent event: uei.opennms.org/internal/discovery/newSuspect");
            }
        }
        catch (Throwable t) {
            this.log().warn("run: unexpected throwable exception caught during send to middleware", t);
        }
    }

    public void handleTimeout(InetAddress address, ICMPEchoPacket packet) {
        this.log().debug("request timed out: " + address);
    }

    public void handleError(InetAddress address, ICMPEchoPacket packet, Throwable t) {
        this.log().debug("an error occurred pinging " + address, t);
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

