/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.PollOutagesConfigManager;
import org.opennms.netmgt.config.poller.Outages;
import org.opennms.netmgt.dao.castor.CastorUtils;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public final class PollOutagesConfigFactory
extends PollOutagesConfigManager {
    private static PollOutagesConfigFactory m_singleton = null;
    private static boolean m_loaded = false;

    PollOutagesConfigFactory(String configFile) throws IOException, MarshalException, ValidationException {
        this.setConfig((Outages)CastorUtils.unmarshal(Outages.class, (Resource)new FileSystemResource(configFile)));
    }

    public PollOutagesConfigFactory(InputStream stream) throws MarshalException, ValidationException {
        this.setConfig((Outages)CastorUtils.unmarshal(Outages.class, (InputStream)stream));
    }

    @Deprecated
    public PollOutagesConfigFactory(Reader rdr) throws MarshalException, ValidationException {
        this.setConfig((Outages)CastorUtils.unmarshal(Outages.class, (Reader)rdr));
    }

    public static synchronized void init() throws IOException, MarshalException, ValidationException {
        if (m_loaded) {
            return;
        }
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.POLL_OUTAGES_CONFIG_FILE_NAME);
        m_singleton = new PollOutagesConfigFactory(cfgFile.getPath());
        m_loaded = true;
    }

    public static synchronized void reload() throws IOException, MarshalException, ValidationException {
        PollOutagesConfigFactory.init();
        PollOutagesConfigFactory.getInstance().update();
    }

    public static synchronized PollOutagesConfigFactory getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The factory has not been initialized");
        }
        return m_singleton;
    }

    public static synchronized void setInstance(PollOutagesConfigFactory instance) {
        m_loaded = true;
        m_singleton = instance;
    }

    protected void saveXML(String xmlString) throws IOException, MarshalException, ValidationException {
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.POLL_OUTAGES_CONFIG_FILE_NAME);
        OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(cfgFile), "UTF-8");
        fileWriter.write(xmlString);
        ((Writer)fileWriter).flush();
        ((Writer)fileWriter).close();
    }

    public void update() throws IOException, MarshalException, ValidationException {
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.POLL_OUTAGES_CONFIG_FILE_NAME);
        this.setConfig((Outages)CastorUtils.unmarshal(Outages.class, (Resource)new FileSystemResource(cfgFile)));
    }
}

