/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;
import org.opennms.netmgt.collectd.AttributeDefinition;
import org.opennms.netmgt.collectd.ByNameComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeGroupType {
    private String m_name;
    private String m_ifType;
    private SortedSet<AttributeDefinition> m_attributeTypes = new TreeSet<AttributeDefinition>(new ByNameComparator());

    public AttributeGroupType(String groupName, String groupIfType) {
        if (groupName == null) {
            throw new NullPointerException("groupName cannot be null");
        }
        if (groupIfType == null) {
            throw new NullPointerException("groupIfType cannot be null");
        }
        this.m_name = groupName;
        this.m_ifType = groupIfType;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AttributeGroupType) {
            AttributeGroupType groupType = (AttributeGroupType)obj;
            return this.m_name.equals(groupType.m_name);
        }
        return false;
    }

    public int hashCode() {
        return this.m_name.hashCode();
    }

    public String getIfType() {
        return this.m_ifType;
    }

    public String getName() {
        return this.m_name;
    }

    public void addAttributeType(AttributeDefinition attrType) {
        this.m_attributeTypes.add(attrType);
    }

    public SortedSet<AttributeDefinition> getAttributeTypes() {
        return Collections.unmodifiableSortedSet(this.m_attributeTypes);
    }

    public String toString() {
        return "AttrGroupType[name=" + this.m_name + ", ifType=" + this.m_ifType + ']';
    }
}

