/*
 * Decompiled with CFR 0.152.
 */
package rpc.security.ntlm;

import gnu.crypto.hash.MD4;
import gnu.crypto.hash.MD5;
import gnu.crypto.prng.ARCFour;
import gnu.crypto.prng.IRandom;
import gnu.crypto.prng.LimitReachedException;
import java.io.UnsupportedEncodingException;
import java.security.DigestException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Random;
import rpc.security.ntlm.Responses;

class NTLMKeyFactory {
    Random random = new Random();
    private static final byte[] clientSigningMagicConstant;
    private static final byte[] serverSigningMagicConstant;
    private static final byte[] clientSealingMagicConstant;
    private static final byte[] serverSealingMagicConstant;

    static {
        byte[] byArray = new byte[59];
        byArray[0] = 115;
        byArray[1] = 101;
        byArray[2] = 115;
        byArray[3] = 115;
        byArray[4] = 105;
        byArray[5] = 111;
        byArray[6] = 110;
        byArray[7] = 32;
        byArray[8] = 107;
        byArray[9] = 101;
        byArray[10] = 121;
        byArray[11] = 32;
        byArray[12] = 116;
        byArray[13] = 111;
        byArray[14] = 32;
        byArray[15] = 99;
        byArray[16] = 108;
        byArray[17] = 105;
        byArray[18] = 101;
        byArray[19] = 110;
        byArray[20] = 116;
        byArray[21] = 45;
        byArray[22] = 116;
        byArray[23] = 111;
        byArray[24] = 45;
        byArray[25] = 115;
        byArray[26] = 101;
        byArray[27] = 114;
        byArray[28] = 118;
        byArray[29] = 101;
        byArray[30] = 114;
        byArray[31] = 32;
        byArray[32] = 115;
        byArray[33] = 105;
        byArray[34] = 103;
        byArray[35] = 110;
        byArray[36] = 105;
        byArray[37] = 110;
        byArray[38] = 103;
        byArray[39] = 32;
        byArray[40] = 107;
        byArray[41] = 101;
        byArray[42] = 121;
        byArray[43] = 32;
        byArray[44] = 109;
        byArray[45] = 97;
        byArray[46] = 103;
        byArray[47] = 105;
        byArray[48] = 99;
        byArray[49] = 32;
        byArray[50] = 99;
        byArray[51] = 111;
        byArray[52] = 110;
        byArray[53] = 115;
        byArray[54] = 116;
        byArray[55] = 97;
        byArray[56] = 110;
        byArray[57] = 116;
        clientSigningMagicConstant = byArray;
        byte[] byArray2 = new byte[59];
        byArray2[0] = 115;
        byArray2[1] = 101;
        byArray2[2] = 115;
        byArray2[3] = 115;
        byArray2[4] = 105;
        byArray2[5] = 111;
        byArray2[6] = 110;
        byArray2[7] = 32;
        byArray2[8] = 107;
        byArray2[9] = 101;
        byArray2[10] = 121;
        byArray2[11] = 32;
        byArray2[12] = 116;
        byArray2[13] = 111;
        byArray2[14] = 32;
        byArray2[15] = 115;
        byArray2[16] = 101;
        byArray2[17] = 114;
        byArray2[18] = 118;
        byArray2[19] = 101;
        byArray2[20] = 114;
        byArray2[21] = 45;
        byArray2[22] = 116;
        byArray2[23] = 111;
        byArray2[24] = 45;
        byArray2[25] = 99;
        byArray2[26] = 108;
        byArray2[27] = 105;
        byArray2[28] = 101;
        byArray2[29] = 110;
        byArray2[30] = 116;
        byArray2[31] = 32;
        byArray2[32] = 115;
        byArray2[33] = 105;
        byArray2[34] = 103;
        byArray2[35] = 110;
        byArray2[36] = 105;
        byArray2[37] = 110;
        byArray2[38] = 103;
        byArray2[39] = 32;
        byArray2[40] = 107;
        byArray2[41] = 101;
        byArray2[42] = 121;
        byArray2[43] = 32;
        byArray2[44] = 109;
        byArray2[45] = 97;
        byArray2[46] = 103;
        byArray2[47] = 105;
        byArray2[48] = 99;
        byArray2[49] = 32;
        byArray2[50] = 99;
        byArray2[51] = 111;
        byArray2[52] = 110;
        byArray2[53] = 115;
        byArray2[54] = 116;
        byArray2[55] = 97;
        byArray2[56] = 110;
        byArray2[57] = 116;
        serverSigningMagicConstant = byArray2;
        byte[] byArray3 = new byte[59];
        byArray3[0] = 115;
        byArray3[1] = 101;
        byArray3[2] = 115;
        byArray3[3] = 115;
        byArray3[4] = 105;
        byArray3[5] = 111;
        byArray3[6] = 110;
        byArray3[7] = 32;
        byArray3[8] = 107;
        byArray3[9] = 101;
        byArray3[10] = 121;
        byArray3[11] = 32;
        byArray3[12] = 116;
        byArray3[13] = 111;
        byArray3[14] = 32;
        byArray3[15] = 99;
        byArray3[16] = 108;
        byArray3[17] = 105;
        byArray3[18] = 101;
        byArray3[19] = 110;
        byArray3[20] = 116;
        byArray3[21] = 45;
        byArray3[22] = 116;
        byArray3[23] = 111;
        byArray3[24] = 45;
        byArray3[25] = 115;
        byArray3[26] = 101;
        byArray3[27] = 114;
        byArray3[28] = 118;
        byArray3[29] = 101;
        byArray3[30] = 114;
        byArray3[31] = 32;
        byArray3[32] = 115;
        byArray3[33] = 101;
        byArray3[34] = 97;
        byArray3[35] = 108;
        byArray3[36] = 105;
        byArray3[37] = 110;
        byArray3[38] = 103;
        byArray3[39] = 32;
        byArray3[40] = 107;
        byArray3[41] = 101;
        byArray3[42] = 121;
        byArray3[43] = 32;
        byArray3[44] = 109;
        byArray3[45] = 97;
        byArray3[46] = 103;
        byArray3[47] = 105;
        byArray3[48] = 99;
        byArray3[49] = 32;
        byArray3[50] = 99;
        byArray3[51] = 111;
        byArray3[52] = 110;
        byArray3[53] = 115;
        byArray3[54] = 116;
        byArray3[55] = 97;
        byArray3[56] = 110;
        byArray3[57] = 116;
        clientSealingMagicConstant = byArray3;
        byte[] byArray4 = new byte[59];
        byArray4[0] = 115;
        byArray4[1] = 101;
        byArray4[2] = 115;
        byArray4[3] = 115;
        byArray4[4] = 105;
        byArray4[5] = 111;
        byArray4[6] = 110;
        byArray4[7] = 32;
        byArray4[8] = 107;
        byArray4[9] = 101;
        byArray4[10] = 121;
        byArray4[11] = 32;
        byArray4[12] = 116;
        byArray4[13] = 111;
        byArray4[14] = 32;
        byArray4[15] = 115;
        byArray4[16] = 101;
        byArray4[17] = 114;
        byArray4[18] = 118;
        byArray4[19] = 101;
        byArray4[20] = 114;
        byArray4[21] = 45;
        byArray4[22] = 116;
        byArray4[23] = 111;
        byArray4[24] = 45;
        byArray4[25] = 99;
        byArray4[26] = 108;
        byArray4[27] = 105;
        byArray4[28] = 101;
        byArray4[29] = 110;
        byArray4[30] = 116;
        byArray4[31] = 32;
        byArray4[32] = 115;
        byArray4[33] = 101;
        byArray4[34] = 97;
        byArray4[35] = 108;
        byArray4[36] = 105;
        byArray4[37] = 110;
        byArray4[38] = 103;
        byArray4[39] = 32;
        byArray4[40] = 107;
        byArray4[41] = 101;
        byArray4[42] = 121;
        byArray4[43] = 32;
        byArray4[44] = 109;
        byArray4[45] = 97;
        byArray4[46] = 103;
        byArray4[47] = 105;
        byArray4[48] = 99;
        byArray4[49] = 32;
        byArray4[50] = 99;
        byArray4[51] = 111;
        byArray4[52] = 110;
        byArray4[53] = 115;
        byArray4[54] = 116;
        byArray4[55] = 97;
        byArray4[56] = 110;
        byArray4[57] = 116;
        serverSealingMagicConstant = byArray4;
    }

    NTLMKeyFactory() {
    }

    byte[] getNTLMUserSessionKey(String password) throws UnsupportedEncodingException, DigestException {
        byte[] key = new byte[16];
        byte[] ntlmHash = Responses.ntlmHash(password);
        MD4 md4 = new MD4();
        md4.update(ntlmHash, 0, ntlmHash.length);
        key = md4.digest();
        return key;
    }

    byte[] getNTLMv2UserSessionKey(String target, String user, String password, byte[] challenge, byte[] blob) throws Exception {
        byte[] key = new byte[16];
        byte[] ntlm2Hash = Responses.ntlmv2Hash(target, user, password);
        byte[] data = new byte[challenge.length + blob.length];
        System.arraycopy(challenge, 0, data, 0, challenge.length);
        System.arraycopy(blob, 0, data, challenge.length, blob.length);
        byte[] mac = Responses.hmacMD5(data, ntlm2Hash);
        key = Responses.hmacMD5(mac, ntlm2Hash);
        return key;
    }

    byte[] getNTLM2SessionResponseUserSessionKey(String password, byte[] servernonce) throws NoSuchAlgorithmException, UnsupportedEncodingException, DigestException {
        return Responses.hmacMD5(servernonce, this.getNTLMUserSessionKey(password));
    }

    byte[] getSecondarySessionKey() {
        byte[] key = new byte[16];
        this.random.nextBytes(key);
        return key;
    }

    IRandom getARCFOUR(byte[] key) {
        HashMap<String, byte[]> attrib = new HashMap<String, byte[]>();
        ARCFour keystream = new ARCFour();
        attrib.put("gnu.crypto.prng.arcfour.key-material", key);
        keystream.init(attrib);
        return keystream;
    }

    byte[] applyARCFOUR(IRandom keystream, byte[] data) throws IllegalStateException, LimitReachedException {
        byte[] retData = new byte[data.length];
        int i = 0;
        while (i < data.length) {
            retData[i] = (byte)(data[i] ^ keystream.nextByte());
            ++i;
        }
        return retData;
    }

    byte[] decryptSecondarySessionKey(byte[] encryptedData, byte[] key) throws IllegalStateException, LimitReachedException {
        return this.applyARCFOUR(this.getARCFOUR(key), encryptedData);
    }

    byte[] encryptSecondarySessionKey(byte[] plainData, byte[] key) throws IllegalStateException, LimitReachedException {
        return this.applyARCFOUR(this.getARCFOUR(key), plainData);
    }

    byte[] generateClientSigningKeyUsingNegotiatedSecondarySessionKey(byte[] secondarySessionKey) {
        byte[] dataforhash = new byte[secondarySessionKey.length + clientSigningMagicConstant.length];
        System.arraycopy(secondarySessionKey, 0, dataforhash, 0, secondarySessionKey.length);
        System.arraycopy(clientSigningMagicConstant, 0, dataforhash, secondarySessionKey.length, clientSigningMagicConstant.length);
        MD5 md5 = new MD5();
        md5.update(dataforhash, 0, dataforhash.length);
        return md5.digest();
    }

    byte[] generateClientSealingKeyUsingNegotiatedSecondarySessionKey(byte[] secondarySessionKey) {
        byte[] dataforhash = new byte[secondarySessionKey.length + clientSealingMagicConstant.length];
        System.arraycopy(secondarySessionKey, 0, dataforhash, 0, secondarySessionKey.length);
        System.arraycopy(clientSealingMagicConstant, 0, dataforhash, secondarySessionKey.length, clientSealingMagicConstant.length);
        MD5 md5 = new MD5();
        md5.update(dataforhash, 0, dataforhash.length);
        return md5.digest();
    }

    byte[] generateServerSigningKeyUsingNegotiatedSecondarySessionKey(byte[] secondarySessionKey) {
        byte[] dataforhash = new byte[secondarySessionKey.length + serverSigningMagicConstant.length];
        System.arraycopy(secondarySessionKey, 0, dataforhash, 0, secondarySessionKey.length);
        System.arraycopy(serverSigningMagicConstant, 0, dataforhash, secondarySessionKey.length, serverSigningMagicConstant.length);
        MD5 md5 = new MD5();
        md5.update(dataforhash, 0, dataforhash.length);
        return md5.digest();
    }

    byte[] generateServerSealingKeyUsingNegotiatedSecondarySessionKey(byte[] secondarySessionKey) {
        byte[] dataforhash = new byte[secondarySessionKey.length + serverSealingMagicConstant.length];
        System.arraycopy(secondarySessionKey, 0, dataforhash, 0, secondarySessionKey.length);
        System.arraycopy(serverSealingMagicConstant, 0, dataforhash, secondarySessionKey.length, serverSealingMagicConstant.length);
        MD5 md5 = new MD5();
        md5.update(dataforhash, 0, dataforhash.length);
        return md5.digest();
    }

    byte[] signingPt1(int sequenceNumber, byte[] signingKey, byte[] data, int lengthOfBuffer) throws NoSuchAlgorithmException, IllegalStateException, LimitReachedException {
        byte[] seqNumPlusData = new byte[4 + lengthOfBuffer];
        seqNumPlusData[0] = (byte)(sequenceNumber & 0xFF);
        seqNumPlusData[1] = (byte)(sequenceNumber >> 8 & 0xFF);
        seqNumPlusData[2] = (byte)(sequenceNumber >> 16 & 0xFF);
        seqNumPlusData[3] = (byte)(sequenceNumber >> 24 & 0xFF);
        System.arraycopy(data, 0, seqNumPlusData, 4, lengthOfBuffer);
        byte[] retval = new byte[16];
        retval[0] = 1;
        byte[] sign = Responses.hmacMD5(seqNumPlusData, signingKey);
        int i = 0;
        while (i < 8) {
            retval[i + 4] = sign[i];
            ++i;
        }
        retval[12] = (byte)(sequenceNumber & 0xFF);
        retval[13] = (byte)(sequenceNumber >> 8 & 0xFF);
        retval[14] = (byte)(sequenceNumber >> 16 & 0xFF);
        retval[15] = (byte)(sequenceNumber >> 24 & 0xFF);
        return retval;
    }

    void signingPt2(byte[] verifier, IRandom rc4) throws IllegalStateException, LimitReachedException {
        int i = 0;
        while (i < 8) {
            verifier[i + 4] = (byte)(verifier[i + 4] ^ rc4.nextByte());
            ++i;
        }
    }

    boolean compareSignature(byte[] src, byte[] target) {
        return Arrays.equals(src, target);
    }
}

