/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opennms.core.utils.IntSet;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.CollectdConfigFactory;
import org.opennms.netmgt.config.DataCollectionConfig;
import org.opennms.netmgt.config.StorageStrategy;
import org.opennms.netmgt.config.datacollection.ResourceType;
import org.opennms.netmgt.dao.LocationMonitorDao;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.dao.ResourceDao;
import org.opennms.netmgt.dao.support.DistributedStatusResourceType;
import org.opennms.netmgt.dao.support.DomainResourceType;
import org.opennms.netmgt.dao.support.GenericIndexResourceType;
import org.opennms.netmgt.dao.support.InterfaceSnmpResourceType;
import org.opennms.netmgt.dao.support.NodeResourceType;
import org.opennms.netmgt.dao.support.NodeSnmpResourceType;
import org.opennms.netmgt.dao.support.ResponseTimeResourceType;
import org.opennms.netmgt.dao.support.RrdFileConstants;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsLocationMonitor;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.OnmsResourceType;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.ObjectRetrievalFailureException;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultResourceDao
implements ResourceDao,
InitializingBean {
    public static final String STRINGS_PROPERTIES_FILE_NAME = "strings.properties";
    public static final String INTERFACE_GRAPH_TYPE = "interface";
    public static final String RESPONSE_DIRECTORY = "response";
    public static final String SNMP_DIRECTORY = "snmp";
    private NodeDao m_nodeDao;
    private LocationMonitorDao m_locationMonitorDao;
    private File m_rrdDirectory;
    private CollectdConfigFactory m_collectdConfig;
    private DataCollectionConfig m_dataCollectionConfig;
    private Map<String, OnmsResourceType> m_resourceTypes;
    private NodeResourceType m_nodeResourceType;
    private DomainResourceType m_domainResourceType;

    public void setRrdDirectory(File rrdDirectory) {
        this.m_rrdDirectory = rrdDirectory;
    }

    @Override
    public File getRrdDirectory() {
        return this.m_rrdDirectory;
    }

    @Override
    public File getRrdDirectory(boolean verify) {
        if (verify && !this.getRrdDirectory().isDirectory()) {
            throw new ObjectRetrievalFailureException("RRD directory does not exist: " + this.getRrdDirectory().getAbsolutePath(), (Object)this.getRrdDirectory());
        }
        return this.getRrdDirectory();
    }

    public DataCollectionConfig getDataCollectionConfig() {
        return this.m_dataCollectionConfig;
    }

    public void setDataCollectionConfig(DataCollectionConfig dataCollectionConfig) {
        this.m_dataCollectionConfig = dataCollectionConfig;
    }

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    public CollectdConfigFactory getCollectdConfig() {
        return this.m_collectdConfig;
    }

    public void setCollectdConfig(CollectdConfigFactory collectdConfig) {
        this.m_collectdConfig = collectdConfig;
    }

    public LocationMonitorDao getLocationMonitorDao() {
        return this.m_locationMonitorDao;
    }

    public void setLocationMonitorDao(LocationMonitorDao locationMonitorDao) {
        this.m_locationMonitorDao = locationMonitorDao;
    }

    public void afterPropertiesSet() throws IOException {
        if (this.m_rrdDirectory == null) {
            throw new IllegalStateException("rrdDirectory property has not been set");
        }
        if (this.m_collectdConfig == null) {
            throw new IllegalStateException("collectdConfig property has not been set");
        }
        if (this.m_dataCollectionConfig == null) {
            throw new IllegalStateException("dataCollectionConfig property has not been set");
        }
        if (this.m_nodeDao == null) {
            throw new IllegalStateException("nodeDao property has not been set");
        }
        if (this.m_locationMonitorDao == null) {
            throw new IllegalStateException("locationMonitorDao property has not been set");
        }
        this.initResourceTypes();
    }

    private void initResourceTypes() throws IOException {
        LinkedHashMap<String, OnmsResourceType> resourceTypes = new LinkedHashMap<String, OnmsResourceType>();
        Object resourceType = new NodeSnmpResourceType(this);
        resourceTypes.put(resourceType.getName(), (OnmsResourceType)resourceType);
        resourceType = new InterfaceSnmpResourceType(this, this.m_nodeDao);
        resourceTypes.put(resourceType.getName(), (OnmsResourceType)resourceType);
        resourceType = new ResponseTimeResourceType(this, this.m_nodeDao);
        resourceTypes.put(resourceType.getName(), (OnmsResourceType)resourceType);
        resourceType = new DistributedStatusResourceType(this, this.m_locationMonitorDao);
        resourceTypes.put(resourceType.getName(), (OnmsResourceType)resourceType);
        resourceTypes.putAll(this.getGenericIndexResourceTypes());
        this.m_nodeResourceType = new NodeResourceType(this);
        resourceTypes.put(this.m_nodeResourceType.getName(), this.m_nodeResourceType);
        this.m_domainResourceType = new DomainResourceType(this);
        resourceTypes.put(this.m_domainResourceType.getName(), this.m_domainResourceType);
        this.m_resourceTypes = resourceTypes;
    }

    private Map<String, GenericIndexResourceType> getGenericIndexResourceTypes() {
        LinkedHashMap<String, GenericIndexResourceType> resourceTypes = new LinkedHashMap<String, GenericIndexResourceType>();
        Map<String, ResourceType> configuredResourceTypes = this.m_dataCollectionConfig.getConfiguredResourceTypes();
        for (ResourceType resourceType : configuredResourceTypes.values()) {
            StorageStrategy storageStrategy;
            Class<?> cinst;
            String className = resourceType.getStorageStrategy().getClazz();
            try {
                cinst = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new ObjectRetrievalFailureException(StorageStrategy.class, (Object)className, "Could not load class '" + className + "' for resource type '" + resourceType.getName() + "'", (Throwable)e);
            }
            try {
                storageStrategy = (StorageStrategy)cinst.newInstance();
            }
            catch (InstantiationException e) {
                throw new ObjectRetrievalFailureException(StorageStrategy.class, (Object)className, "Could not instantiate class '" + className + "' for resource type '" + resourceType.getName() + "'", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new ObjectRetrievalFailureException(StorageStrategy.class, (Object)className, "Could not instantiate class '" + className + "' for resource type '" + resourceType.getName() + "'", (Throwable)e);
            }
            storageStrategy.setResourceTypeName(resourceType.getName());
            GenericIndexResourceType genericIndexResourceType = new GenericIndexResourceType(this, resourceType.getName(), resourceType.getLabel(), resourceType.getResourceLabel(), storageStrategy);
            resourceTypes.put(genericIndexResourceType.getName(), genericIndexResourceType);
        }
        return resourceTypes;
    }

    @Override
    public Collection<OnmsResourceType> getResourceTypes() {
        return this.m_resourceTypes.values();
    }

    @Override
    public OnmsResource getResourceById(String id) {
        try {
            return this.loadResourceById(id);
        }
        catch (ObjectRetrievalFailureException e) {
            return null;
        }
    }

    @Override
    public OnmsResource loadResourceById(String id) {
        OnmsResource resource = null;
        Pattern p = Pattern.compile("([^\\[]+)\\[([^\\]]*)\\](?:\\.|$)");
        Matcher m = p.matcher(id);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String resourceTypeName = DefaultResourceDao.decode(m.group(1));
            String resourceName = DefaultResourceDao.decode(m.group(2));
            try {
                resource = resource == null ? this.getTopLevelResource(resourceTypeName, resourceName) : this.getChildResource(resource, resourceTypeName, resourceName);
            }
            catch (DataAccessException e) {
                throw new ObjectRetrievalFailureException(OnmsResource.class, (Object)id, "Could not get resource for resource ID '" + id + "'", (Throwable)e);
            }
            m.appendReplacement(sb, "");
        }
        m.appendTail(sb);
        if (sb.length() > 0) {
            throw new IllegalArgumentException("resource ID '" + id + "' does not match pattern '" + p.toString() + "' at '" + sb + "'");
        }
        return resource;
    }

    @Override
    public List<OnmsResource> getResourceListById(String id) {
        OnmsResource topLevelResource = null;
        Pattern p = Pattern.compile("([^\\[]+)\\[([^\\]]*)\\](?:\\.|$)");
        Matcher m = p.matcher(id);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String resourceTypeName = DefaultResourceDao.decode(m.group(1));
            String resourceName = DefaultResourceDao.decode(m.group(2));
            try {
                if (topLevelResource != null) {
                    return this.getChildResourceList(topLevelResource);
                }
                topLevelResource = this.getTopLevelResource(resourceTypeName, resourceName);
            }
            catch (DataAccessException e) {
                throw new ObjectRetrievalFailureException(OnmsResource.class, (Object)id, "Could not get resource for resource ID '" + id + "'", (Throwable)e);
            }
            m.appendReplacement(sb, "");
        }
        m.appendTail(sb);
        if (sb.length() > 0) {
            throw new IllegalArgumentException("resource ID '" + id + "' does not match pattern '" + p.toString() + "' at '" + sb + "'");
        }
        return null;
    }

    protected OnmsResource getTopLevelResource(String resourceType, String resource) {
        if ("node".equals(resourceType)) {
            return this.getNodeEntityResource(resource);
        }
        if ("nodeSource".equals(resourceType)) {
            return this.getForeignSourceNodeEntityResource(resource);
        }
        if ("domain".equals(resourceType)) {
            return this.getDomainEntityResource(resource);
        }
        throw new ObjectRetrievalFailureException("Top-level resource type of '" + resourceType + "' is unknown", (Object)resourceType);
    }

    protected OnmsResource getChildResource(OnmsResource parentResource, String resourceType, String resource) {
        for (OnmsResource r : parentResource.getChildResources()) {
            if (!resourceType.equals(r.getResourceType().getName()) || !resource.equals(r.getName())) continue;
            return r;
        }
        throw new ObjectRetrievalFailureException(OnmsResource.class, (Object)(resourceType + "/" + resource), "Could not find child resource '" + resource + "' with resource type '" + resourceType + "' on resource '" + resource + "'", null);
    }

    protected List<OnmsResource> getChildResourceList(OnmsResource parentResource) {
        if (this.log().isDebugEnabled()) {
            this.log().debug("DefaultResourceDao: getChildResourceList for " + parentResource.toString());
        }
        return parentResource.getChildResources();
    }

    @Override
    public List<OnmsResource> findNodeResources() {
        LinkedList<OnmsResource> resources = new LinkedList<OnmsResource>();
        IntSet snmpNodes = this.findSnmpNodeDirectories();
        Set<String> responseTimeInterfaces = this.findChildrenMatchingFilter(new File(this.getRrdDirectory(), RESPONSE_DIRECTORY), RrdFileConstants.INTERFACE_DIRECTORY_FILTER);
        Set<String> distributedResponseTimeInterfaces = this.findChildrenChildrenMatchingFilter(new File(new File(this.getRrdDirectory(), RESPONSE_DIRECTORY), "distributed"), RrdFileConstants.INTERFACE_DIRECTORY_FILTER);
        List<OnmsNode> nodes = this.m_nodeDao.findAll();
        IntSet nodesFound = new IntSet();
        for (OnmsNode node : nodes) {
            if (nodesFound.contains(node.getId().intValue())) continue;
            boolean found = false;
            if (snmpNodes.contains(node.getId().intValue())) {
                found = true;
            } else if (responseTimeInterfaces.size() > 0 || distributedResponseTimeInterfaces.size() > 0) {
                for (OnmsIpInterface ip : node.getIpInterfaces()) {
                    if (!responseTimeInterfaces.contains(ip.getIpAddress()) && !distributedResponseTimeInterfaces.contains(ip.getIpAddress())) continue;
                    found = true;
                    break;
                }
            }
            if (!found) continue;
            resources.add(this.m_nodeResourceType.createChildResource(node));
            nodesFound.add(node.getId().intValue());
        }
        return resources;
    }

    @Override
    public List<OnmsResource> findDomainResources() {
        LinkedList<OnmsResource> resources = new LinkedList<OnmsResource>();
        File snmp = new File(this.getRrdDirectory(), SNMP_DIRECTORY);
        File[] domainDirs = snmp.listFiles(RrdFileConstants.DOMAIN_DIRECTORY_FILTER);
        if (domainDirs != null && domainDirs.length > 0) {
            for (File domainDir : domainDirs) {
                if (!this.m_collectdConfig.domainExists(domainDir.getName()) && !this.m_collectdConfig.packageExists(domainDir.getName())) continue;
                resources.add(this.m_domainResourceType.createChildResource(domainDir.getName()));
            }
        }
        return resources;
    }

    protected OnmsResource getNodeEntityResource(String resource) {
        int nodeId;
        try {
            nodeId = Integer.parseInt(resource);
        }
        catch (NumberFormatException e) {
            throw new ObjectRetrievalFailureException(OnmsNode.class, (Object)resource, "Top-level resource of resource type node is not numeric: " + resource, null);
        }
        OnmsNode node = (OnmsNode)this.m_nodeDao.get(nodeId);
        if (node == null) {
            throw new ObjectRetrievalFailureException(OnmsNode.class, (Object)resource, "Top-level resource of resource type node could not be found: " + resource, null);
        }
        OnmsResource onmsResource = this.getResourceForNode(node);
        return onmsResource;
    }

    protected OnmsResource getForeignSourceNodeEntityResource(String resource) {
        String[] ident = resource.split(":");
        OnmsNode node = this.m_nodeDao.findByForeignId(ident[0], ident[1]);
        if (node == null) {
            throw new ObjectRetrievalFailureException(OnmsNode.class, (Object)resource, "Top-level resource of resource type node could not be found: " + resource, null);
        }
        OnmsResource onmsResource = this.getResourceForNode(node);
        return onmsResource;
    }

    protected OnmsResource getDomainEntityResource(String domain) {
        if (!this.m_collectdConfig.domainExists(domain) && !this.m_collectdConfig.packageExists(domain)) {
            throw new ObjectRetrievalFailureException(OnmsResource.class, (Object)domain, "Domain not found as a configured domain or package in collectd configuration", null);
        }
        File directory = new File(this.getRrdDirectory(), SNMP_DIRECTORY);
        File domainDir = new File(directory, domain);
        if (!domainDir.isDirectory()) {
            throw new ObjectRetrievalFailureException(OnmsResource.class, (Object)domain, "Domain not found due to domain RRD directory not existing or not a directory: " + domainDir.getAbsolutePath(), null);
        }
        if (!RrdFileConstants.DOMAIN_DIRECTORY_FILTER.accept(domainDir)) {
            throw new ObjectRetrievalFailureException(OnmsResource.class, (Object)domain, "Domain not found due to domain RRD directory not matching the domain directory filter: " + domainDir.getAbsolutePath(), null);
        }
        return this.m_domainResourceType.createChildResource(domain);
    }

    private IntSet findSnmpNodeDirectories() {
        IntSet nodes = new IntSet();
        File directory = new File(this.getRrdDirectory(), SNMP_DIRECTORY);
        File[] nodeDirs = directory.listFiles(RrdFileConstants.NODE_DIRECTORY_FILTER);
        if (nodeDirs == null || nodeDirs.length == 0) {
            return nodes;
        }
        for (File nodeDir : nodeDirs) {
            try {
                int nodeId = Integer.parseInt(nodeDir.getName());
                nodes.add(nodeId);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return nodes;
    }

    private Set<String> findChildrenMatchingFilter(File directory, FileFilter filter) {
        HashSet<String> children = new HashSet<String>();
        File[] nodeDirs = directory.listFiles(filter);
        if (nodeDirs == null || nodeDirs.length == 0) {
            return children;
        }
        for (File nodeDir : nodeDirs) {
            children.add(nodeDir.getName());
        }
        return children;
    }

    private Set<String> findChildrenChildrenMatchingFilter(File directory, FileFilter filter) {
        HashSet<String> children = new HashSet<String>();
        File[] locationMonitorDirs = directory.listFiles();
        if (locationMonitorDirs == null) {
            return children;
        }
        for (File locationMonitorDir : locationMonitorDirs) {
            File[] intfDirs = locationMonitorDir.listFiles(filter);
            if (intfDirs == null || intfDirs.length == 0) continue;
            for (File intfDir : intfDirs) {
                children.add(intfDir.getName());
            }
        }
        return children;
    }

    public static String decode(String string) {
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    @Override
    public OnmsResource getResourceForNode(OnmsNode node) {
        Assert.notNull((Object)node, (String)"node argument must not be null");
        return this.m_nodeResourceType.createChildResource(node);
    }

    private OnmsResource getChildResourceForNode(OnmsNode node, String resourceTypeName, String resourceName) {
        OnmsResource nodeResource = this.getResourceForNode(node);
        if (nodeResource == null) {
            return null;
        }
        List childResources = nodeResource.getChildResources();
        for (OnmsResource childResource : childResources) {
            if (!resourceTypeName.equals(childResource.getResourceType().getName()) || !resourceName.equals(childResource.getName())) continue;
            return childResource;
        }
        return null;
    }

    @Override
    public OnmsResource getResourceForIpInterface(OnmsIpInterface ipInterface) {
        Assert.notNull((Object)ipInterface, (String)"ipInterface argument must not be null");
        Assert.notNull((Object)ipInterface.getNode(), (String)"getNode() on ipInterface must not return null");
        return this.getChildResourceForNode(ipInterface.getNode(), "responseTime", ipInterface.getIpAddress());
    }

    @Override
    public OnmsResource getResourceForIpInterface(OnmsIpInterface ipInterface, OnmsLocationMonitor locMon) {
        Assert.notNull((Object)ipInterface, (String)"ipInterface argument must not be null");
        Assert.notNull((Object)locMon, (String)"locMon argument must not be null");
        Assert.notNull((Object)ipInterface.getNode(), (String)"getNode() on ipInterface must not return null");
        return this.getChildResourceForNode(ipInterface.getNode(), "distributedStatus", locMon.getId() + File.separator + ipInterface.getIpAddress());
    }

    @Override
    public List<OnmsResource> findTopLevelResources() {
        ArrayList<OnmsResource> resources = new ArrayList<OnmsResource>();
        resources.addAll(this.findNodeResources());
        resources.addAll(this.findDomainResources());
        return resources;
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance();
    }
}

