/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.sms.monitor.internal.config;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import org.apache.commons.io.FileUtils;
import org.opennms.sms.monitor.internal.SequenceException;
import org.opennms.sms.monitor.internal.config.MobileSequenceConfig;
import org.opennms.sms.monitor.internal.config.MobileSequenceNamespacePrefixMapper;
import org.opennms.sms.monitor.internal.config.SequenceSessionVariable;
import org.opennms.sms.monitor.internal.config.SmsFromRecipientResponseMatcher;
import org.opennms.sms.monitor.internal.config.SmsSequenceRequest;
import org.opennms.sms.monitor.internal.config.SmsSequenceResponse;
import org.opennms.sms.monitor.internal.config.SmsSourceMatcher;
import org.opennms.sms.monitor.internal.config.TextResponseMatcher;
import org.opennms.sms.monitor.internal.config.UssdSequenceRequest;
import org.opennms.sms.monitor.internal.config.UssdSequenceResponse;
import org.opennms.sms.monitor.internal.config.UssdSessionStatusMatcher;

public class SequenceConfigFactory {
    private static SequenceConfigFactory m_singleton = null;
    private JAXBContext m_context;

    private SequenceConfigFactory() {
    }

    public static synchronized SequenceConfigFactory getInstance() {
        if (m_singleton == null) {
            m_singleton = new SequenceConfigFactory();
        }
        return m_singleton;
    }

    protected synchronized void initializeContext() throws JAXBException {
        if (this.m_context == null) {
            this.m_context = JAXBContext.newInstance((Class[])new Class[]{MobileSequenceConfig.class, SequenceSessionVariable.class, SmsSequenceRequest.class, UssdSequenceRequest.class, SmsSequenceResponse.class, UssdSequenceResponse.class, SmsFromRecipientResponseMatcher.class, SmsSourceMatcher.class, TextResponseMatcher.class, UssdSessionStatusMatcher.class});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Marshaller getMarshaller() throws JAXBException {
        JAXBContext jAXBContext = this.m_context;
        synchronized (jAXBContext) {
            Marshaller m = this.m_context.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)true);
            m.setProperty("com.sun.xml.bind.namespacePrefixMapper", (Object)new MobileSequenceNamespacePrefixMapper());
            return m;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Unmarshaller getUnmarshaller() throws JAXBException {
        JAXBContext jAXBContext = this.m_context;
        synchronized (jAXBContext) {
            Unmarshaller u = this.m_context.createUnmarshaller();
            u.setSchema(null);
            u.setEventHandler((ValidationEventHandler)new DefaultValidationEventHandler());
            return u;
        }
    }

    public MobileSequenceConfig getSequenceForXml(String sequenceXml) throws SequenceException {
        try {
            this.initializeContext();
            StringReader r = new StringReader(sequenceXml);
            MobileSequenceConfig s = (MobileSequenceConfig)this.getUnmarshaller().unmarshal((Reader)r);
            return s;
        }
        catch (JAXBException e) {
            throw new SequenceException("An error occurred reading the sequence.", e);
        }
    }

    public MobileSequenceConfig getSequenceForFile(File sequenceFile) throws SequenceException {
        try {
            return this.getSequenceForXml(FileUtils.readFileToString((File)sequenceFile));
        }
        catch (IOException e) {
            throw new SequenceException("An error occurred reading the sequence from " + sequenceFile.getPath(), e);
        }
    }
}

