/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.sms.monitor.internal;

import java.net.SocketTimeoutException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.opennms.core.tasks.Callback;
import org.opennms.sms.monitor.MobileSequenceSession;
import org.opennms.sms.monitor.internal.config.MobileSequenceResponse;
import org.opennms.sms.monitor.internal.config.MobileSequenceTransaction;
import org.opennms.sms.reflector.smsservice.MobileMsgRequest;
import org.opennms.sms.reflector.smsservice.MobileMsgResponse;
import org.opennms.sms.reflector.smsservice.MobileMsgResponseHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MobileTransactionExecution {
    private MobileSequenceTransaction m_transaction;
    private Long m_sendTime;
    private Long m_receiveTime;
    private Throwable m_error;

    public MobileTransactionExecution(MobileSequenceTransaction transaction) {
        this.m_transaction = transaction;
    }

    private void setSendTime(Long sendTime) {
        this.m_sendTime = sendTime;
    }

    private void setReceiveTime(Long receiveTime) {
        this.m_receiveTime = receiveTime;
    }

    public Long getLatency() {
        return this.m_sendTime == null || this.m_receiveTime == null ? null : Long.valueOf(this.m_receiveTime - this.m_sendTime);
    }

    public Throwable getError() {
        return this.m_error;
    }

    public void setError(Throwable error) {
        this.m_error = error;
    }

    public MobileSequenceTransaction getTransaction() {
        return this.m_transaction;
    }

    Callback<MobileMsgResponse> getCallback() {
        return new Callback<MobileMsgResponse>(){

            public void complete(MobileMsgResponse t) {
                if (t != null) {
                    MobileTransactionExecution.this.setSendTime(t.getRequest().getSentTime());
                    MobileTransactionExecution.this.setReceiveTime(t.getReceiveTime());
                }
            }

            public void handleException(Throwable t) {
                MobileTransactionExecution.this.setError(t);
            }
        };
    }

    void sendRequest(MobileSequenceSession session, Callback<MobileMsgResponse> cb) {
        this.getTransaction().sendRequest(session, new TransactionResponseHandler(session, cb));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class TransactionResponseHandler
    implements MobileMsgResponseHandler {
        private final Callback<MobileMsgResponse> m_cb;
        private final MobileSequenceSession m_session;
        private final Set<MobileSequenceResponse> m_pendingResponses;

        private TransactionResponseHandler(MobileSequenceSession session, Callback<MobileMsgResponse> cb) {
            this.m_cb = cb;
            this.m_session = session;
            this.m_pendingResponses = Collections.synchronizedSet(new LinkedHashSet<MobileSequenceResponse>(MobileTransactionExecution.this.getTransaction().getResponses()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean matches(MobileMsgRequest request, MobileMsgResponse response) {
            Set<MobileSequenceResponse> set = this.m_pendingResponses;
            synchronized (set) {
                for (MobileSequenceResponse r : this.m_pendingResponses) {
                    if (!r.matches(this.m_session, request, response)) continue;
                    return true;
                }
                return false;
            }
        }

        public void handleTimeout(MobileMsgRequest request) {
            SocketTimeoutException err = new SocketTimeoutException("timed out processing request " + request);
            MobileTransactionExecution.this.setError(err);
            this.m_cb.handleException((Throwable)err);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean handleResponse(MobileMsgRequest request, MobileMsgResponse response) {
            if (request != null) {
                MobileTransactionExecution.this.setSendTime(request.getSentTime());
            }
            if (response != null) {
                MobileTransactionExecution.this.setReceiveTime(response.getReceiveTime());
            }
            Set<MobileSequenceResponse> set = this.m_pendingResponses;
            synchronized (set) {
                Iterator<MobileSequenceResponse> it = this.m_pendingResponses.iterator();
                while (it.hasNext()) {
                    MobileSequenceResponse r = it.next();
                    if (!r.matches(this.m_session, request, response)) continue;
                    r.processResponse(this.m_session, request, response);
                    it.remove();
                }
            }
            this.m_cb.complete((Object)response);
            return !this.m_pendingResponses.isEmpty();
        }

        public void handleError(MobileMsgRequest request, Throwable t) {
            MobileTransactionExecution.this.setError(t);
            this.m_cb.handleException(t);
        }
    }
}

