/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.sms.monitor.internal;

import org.opennms.sms.monitor.internal.config.MobileSequenceConfig;
import org.opennms.sms.monitor.internal.config.MobileSequenceRequest;
import org.opennms.sms.monitor.internal.config.MobileSequenceResponse;
import org.opennms.sms.monitor.internal.config.MobileSequenceTransaction;
import org.opennms.sms.monitor.internal.config.SequenceResponseMatcher;
import org.opennms.sms.monitor.internal.config.SequenceSessionVariable;
import org.opennms.sms.monitor.internal.config.SmsSequenceRequest;
import org.opennms.sms.monitor.internal.config.SmsSequenceResponse;
import org.opennms.sms.monitor.internal.config.SmsSourceMatcher;
import org.opennms.sms.monitor.internal.config.TextResponseMatcher;
import org.opennms.sms.monitor.internal.config.UssdSequenceRequest;
import org.opennms.sms.monitor.internal.config.UssdSequenceResponse;
import org.opennms.sms.monitor.internal.config.UssdSessionStatusMatcher;
import org.opennms.sms.monitor.session.SessionVariableGenerator;
import org.smslib.USSDSessionStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MobileSequenceConfigBuilder {
    private MobileSequenceConfig m_sequence;

    public MobileSequenceConfigBuilder() {
        this(new MobileSequenceConfig());
    }

    public MobileSequenceConfigBuilder(MobileSequenceConfig sequence) {
        this.m_sequence = sequence;
    }

    public MobileSequenceConfig getSequence() {
        return this.m_sequence;
    }

    public MobileSequenceTransactionBuilder addTransaction() {
        MobileSequenceTransaction t = new MobileSequenceTransaction();
        this.getSequence().addTransaction(t);
        return new MobileSequenceTransactionBuilder(t);
    }

    public MobileSequenceTransactionBuilder request(MobileSequenceRequest request) {
        return this.addTransaction().setRequest(request);
    }

    public MobileSequenceTransactionBuilder smsRequest(String label, String gatewayId, String recipient, String text) {
        SmsSequenceRequest smsRequest = new SmsSequenceRequest();
        smsRequest.setLabel(label);
        smsRequest.setGatewayId(gatewayId);
        smsRequest.setRecipient(recipient);
        smsRequest.setText(text);
        return this.request(smsRequest);
    }

    public MobileSequenceTransactionBuilder ussdRequest(String label, String gatewayId, String text) {
        UssdSequenceRequest ussdRequest = new UssdSequenceRequest();
        ussdRequest.setLabel(label);
        ussdRequest.setGatewayId(gatewayId);
        ussdRequest.setText(text);
        return this.request(ussdRequest);
    }

    public SessionVariableBuilder variable(String name, Class<? extends SessionVariableGenerator> variableClass) {
        SequenceSessionVariable var = new SequenceSessionVariable(name, variableClass.getName());
        this.m_sequence.addSessionVariable(var);
        return new SessionVariableBuilder(var);
    }

    public static class SessionVariableBuilder {
        private SequenceSessionVariable m_var;

        public SessionVariableBuilder(SequenceSessionVariable var) {
            this.m_var = var;
        }

        public SessionVariableBuilder parameter(String key, Object val) {
            this.m_var.addParameter(key, val == null ? null : val.toString());
            return this;
        }
    }

    public static class UssdResponseBuilder {
        private UssdSequenceResponse m_response;

        public UssdResponseBuilder(UssdSequenceResponse response) {
            this.m_response = response;
        }

        public UssdResponseBuilder addMatcher(SequenceResponseMatcher matcher) {
            this.m_response.addMatcher(matcher);
            return this;
        }

        public UssdResponseBuilder matching(String regex) {
            return this.addMatcher(new TextResponseMatcher(regex));
        }

        public UssdResponseBuilder withSessionStatus(USSDSessionStatus sessionStatus) {
            return this.addMatcher(new UssdSessionStatusMatcher(sessionStatus));
        }

        public UssdResponseBuilder onGateway(String gatewayId) {
            this.m_response.setGatewayId(gatewayId);
            return this;
        }
    }

    public static class SmsResponseBuilder {
        private MobileSequenceResponse m_response;

        public SmsResponseBuilder(MobileSequenceResponse response) {
            this.m_response = response;
        }

        public SmsResponseBuilder addMatcher(SequenceResponseMatcher matcher) {
            this.m_response.addMatcher(matcher);
            return this;
        }

        public SmsResponseBuilder matching(String regex) {
            return this.addMatcher(new TextResponseMatcher(regex));
        }

        public SmsResponseBuilder srcMatches(String originator) {
            this.addMatcher(new SmsSourceMatcher(originator));
            return this;
        }

        public SmsResponseBuilder onGateway(String gatewayId) {
            this.m_response.setGatewayId(gatewayId);
            return this;
        }
    }

    public static class MobileSequenceTransactionBuilder {
        private MobileSequenceTransaction m_transaction;

        public MobileSequenceTransactionBuilder(MobileSequenceTransaction transaction) {
            this.m_transaction = transaction;
        }

        public MobileSequenceTransactionBuilder setRequest(MobileSequenceRequest sequenceRequest) {
            this.m_transaction.setRequest(sequenceRequest);
            return this;
        }

        public MobileSequenceTransaction getTransaction() {
            return this.m_transaction;
        }

        public void addResponse(MobileSequenceResponse response) {
            this.m_transaction.addResponse(response);
        }

        public SmsResponseBuilder expectSmsResponse() {
            return this.expectSmsResponse(null);
        }

        public SmsResponseBuilder expectSmsResponse(String label) {
            SmsSequenceResponse response = new SmsSequenceResponse(label);
            this.addResponse(response);
            return new SmsResponseBuilder(response);
        }

        public UssdResponseBuilder expectUssdResponse() {
            return this.expectUssdResponse(null);
        }

        public UssdResponseBuilder expectUssdResponse(String label) {
            UssdSequenceResponse response = new UssdSequenceResponse(label);
            this.addResponse(response);
            return new UssdResponseBuilder(response);
        }

        public MobileSequenceTransactionBuilder withTransactionLabel(String transactionLabel) {
            this.m_transaction.setLabel(transactionLabel);
            return this;
        }

        public MobileSequenceTransactionBuilder withGatewayId(String gatewayId) {
            this.m_transaction.setGatewayId(gatewayId);
            return this;
        }
    }
}

