/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.sms.monitor;

import java.util.Map;
import org.apache.log4j.Logger;
import org.opennms.core.tasks.DefaultTaskCoordinator;
import org.opennms.core.utils.BeanUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.monitors.IPv4Monitor;
import org.opennms.sms.monitor.MobileSequenceSession;
import org.opennms.sms.monitor.internal.SequenceException;
import org.opennms.sms.monitor.internal.config.MobileSequenceConfig;
import org.opennms.sms.monitor.internal.config.SequenceConfigFactory;
import org.opennms.sms.phonebook.Phonebook;
import org.opennms.sms.phonebook.PhonebookException;
import org.opennms.sms.reflector.smsservice.MobileMsgTracker;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Distributable(value={DistributionContext.DAEMON})
public class MobileMsgSequenceMonitor
extends IPv4Monitor {
    public static final String DEFAULT_CONTEXT_NAME = "mobileMessagePollerContext";
    public static final String CONTEXT_KEY = "mobileMessageContextName";
    private static Logger log = Logger.getLogger(MobileMsgSequenceMonitor.class);
    private Phonebook m_phonebook;
    private MobileMsgTracker m_tracker;
    private DefaultTaskCoordinator m_coordinator;

    public void initialize(Map<String, Object> params) {
        super.initialize(params);
        String contextName = ParameterMap.getKeyedString(params, (String)CONTEXT_KEY, (String)DEFAULT_CONTEXT_NAME);
        this.m_phonebook = (Phonebook)BeanUtils.getBean((String)contextName, (String)"phonebook", Phonebook.class);
        this.m_tracker = (MobileMsgTracker)BeanUtils.getBean((String)contextName, (String)"mobileMsgTracker", MobileMsgTracker.class);
        this.m_coordinator = (DefaultTaskCoordinator)BeanUtils.getBean((String)contextName, (String)"sequenceTaskCoordinator", DefaultTaskCoordinator.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        try {
            String config = ParameterMap.getKeyedString(parameters, (String)"sequence", (String)"");
            if (!StringUtils.hasLength((String)config)) {
                return PollStatus.unavailable((String)"Sequence configuration was empty.  You must specify a 'sequence' parameter in the SMSSequenceMonitor poller configuration!");
            }
            SequenceConfigFactory factory = SequenceConfigFactory.getInstance();
            MobileSequenceConfig sequenceConfig = factory.getSequenceForXml(config);
            if (!sequenceConfig.hasTransactions()) {
                log.warn((Object)("No transactions were configured for host " + svc.getIpAddr()));
                return PollStatus.unavailable((String)("No transactions were configured for host " + svc.getIpAddr()));
            }
            MobileSequenceSession session = new MobileSequenceSession(parameters, sequenceConfig.getSessionVariables(), this.m_tracker);
            session.setRecipient(this.m_phonebook.getTargetForAddress(svc.getIpAddr()));
            session.checkoutVariables();
            Map<String, Number> results = null;
            try {
                results = sequenceConfig.executeSequence(session, this.m_coordinator);
            }
            finally {
                session.checkinVariables();
            }
            Map<String, Number> responseTimes = results;
            PollStatus response = PollStatus.available();
            response.setProperties(responseTimes);
            return response;
        }
        catch (PhonebookException e) {
            log.warn((Object)("Unable to locate recpient phone number for IP address " + svc.getIpAddr()), (Throwable)e);
            return PollStatus.unavailable((String)("Unable to find phone number for IP address " + svc.getIpAddr()));
        }
        catch (SequenceException e) {
            log.warn((Object)("Unable to parse sequence configuration for host " + svc.getIpAddr()), (Throwable)e);
            return PollStatus.unavailable((String)"unable to read sequence configuration");
        }
        catch (Throwable e) {
            log.debug((Object)"Sequence failed", e);
            return PollStatus.unavailable((String)("Sequence failed: " + e.getLocalizedMessage()));
        }
    }
}

