/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.vulnerability.filter;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Date;
import org.opennms.web.vulnerability.filter.Filter;

public class ResolvedDateAfterFilter
implements Filter {
    public static final String TYPE = "resolvedafter";
    protected static final DateFormat DATE_FORMAT = DateFormat.getDateTimeInstance(3, 2);
    protected Date date;

    public ResolvedDateAfterFilter(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        this.date = date;
    }

    public ResolvedDateAfterFilter(long epochTime) {
        this(new Date(epochTime));
    }

    public String getSql() {
        return " resolvedTime > to_timestamp('" + this.date.toString() + "'," + "'Dy Mon DD HH24:MI:SS Tz YYYY'" + ")";
    }

    public String getParamSql() {
        return " resolvedTime > ?";
    }

    public int bindParam(PreparedStatement ps, int parameterIndex) throws SQLException {
        ps.setTimestamp(parameterIndex, new Timestamp(this.date.getTime()));
        return 1;
    }

    public String getDescription() {
        return "resolvedafter=" + this.date.getTime();
    }

    public String getTextDescription() {
        return "resolved time after \"" + DATE_FORMAT.format(this.date) + "\"";
    }

    public String toString() {
        return "<Resolved Date After Filter: " + this.getDescription() + ">";
    }

    public Date getDate() {
        return this.date;
    }

    public boolean equals(Object obj) {
        return this.toString().equals(obj.toString());
    }
}

