/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.vulnerability.filter;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.opennms.web.vulnerability.filter.Filter;

public class ProtocolFilter
implements Filter {
    public static final String TYPE = "protocol";
    protected String protocol;

    public ProtocolFilter(String protocol) {
        if (protocol == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        this.protocol = protocol;
    }

    public String getSql() {
        return " PROTOCOL='" + this.protocol + "'";
    }

    public String getParamSql() {
        return " PROTOCOL=?";
    }

    public int bindParam(PreparedStatement ps, int parameterIndex) throws SQLException {
        ps.setString(parameterIndex, this.protocol);
        return 1;
    }

    public String getDescription() {
        return "protocol=" + this.protocol;
    }

    public String getTextDescription() {
        return "protocol is " + this.protocol;
    }

    public String toString() {
        return "<Vulnerability Protocol Filter: " + this.getDescription() + ">";
    }

    public String getProtocol() {
        return this.protocol;
    }

    public boolean equals(Object obj) {
        return this.toString().equals(obj.toString());
    }
}

