/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.vulnerability.filter;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.opennms.web.element.NetworkElementFactory;
import org.opennms.web.vulnerability.filter.Filter;

public class NodeFilter
implements Filter {
    public static final String TYPE = "node";
    protected int nodeId;

    public NodeFilter(int nodeId) {
        this.nodeId = nodeId;
    }

    public String getSql() {
        return " VULNERABILITIES.NODEID=" + this.nodeId;
    }

    public String getParamSql() {
        return " VULNERABILITIES.NODEID=?";
    }

    public int bindParam(PreparedStatement ps, int parameterIndex) throws SQLException {
        ps.setInt(parameterIndex, this.nodeId);
        return 1;
    }

    public String getDescription() {
        return "node=" + this.nodeId;
    }

    public String getTextDescription() {
        String nodeName = Integer.toString(this.nodeId);
        try {
            nodeName = NetworkElementFactory.getNodeLabel(this.nodeId);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return "node is " + nodeName;
    }

    public String toString() {
        return "<Vulnerability Node Filter: " + this.getDescription() + ">";
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public boolean equals(Object obj) {
        return this.toString().equals(obj.toString());
    }
}

