/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.vulnerability.filter;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.web.vulnerability.filter.Filter;

public class NegativeSeverityFilter
implements Filter {
    public static final String TYPE = "severitynot";
    protected int severity;

    public NegativeSeverityFilter(int severity) {
        this.severity = severity;
    }

    public NegativeSeverityFilter(OnmsSeverity severity) {
        this(severity.getId());
    }

    public String getSql() {
        return " SEVERITY<>" + this.severity;
    }

    public String getParamSql() {
        return " SEVERITY<>?";
    }

    public int bindParam(PreparedStatement ps, int parameterIndex) throws SQLException {
        ps.setInt(parameterIndex, this.severity);
        return 1;
    }

    public String getDescription() {
        return "severitynot=" + this.severity;
    }

    public String getTextDescription() {
        return "severity is not " + OnmsSeverity.get((int)new Integer(this.severity)).getLabel();
    }

    public String toString() {
        return "<Vulnerability Negative Severity Filter: " + this.getDescription() + ">";
    }

    public int getSeverity() {
        return this.severity;
    }

    public boolean equals(Object obj) {
        return this.toString().equals(obj.toString());
    }
}

