/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.vulnerability.filter;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.opennms.web.element.NetworkElementFactory;
import org.opennms.web.vulnerability.filter.Filter;

public class NegativeNodeFilter
implements Filter {
    public static final String TYPE = "nodenot";
    protected int nodeId;

    public NegativeNodeFilter(int nodeId) {
        this.nodeId = nodeId;
    }

    public String getSql() {
        return " (VULNERABILITIES.NODEID<>" + this.nodeId + " OR VULNERABILITIES.NODEID IS NULL)";
    }

    public String getParamSql() {
        return " (VULNERABILITIES.NODEID<>? OR VULNERABILITIES.NODEID IS NULL)";
    }

    public int bindParam(PreparedStatement ps, int parameterIndex) throws SQLException {
        ps.setInt(parameterIndex, this.nodeId);
        return 1;
    }

    public String getDescription() {
        return "nodenot=" + this.nodeId;
    }

    public String getTextDescription() {
        String nodeName = Integer.toString(this.nodeId);
        try {
            nodeName = NetworkElementFactory.getNodeLabel(this.nodeId);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return "node is not " + nodeName;
    }

    public String toString() {
        return "<Vulnerability Negative Node Filter: " + this.getDescription() + ">";
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public boolean equals(Object obj) {
        return this.toString().equals(obj.toString());
    }
}

