/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.vulnerability.filter;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.opennms.web.vulnerability.filter.Filter;

public class NegativeInterfaceFilter
implements Filter {
    public static final String TYPE = "interfacenot";
    protected String ipAddress;

    public NegativeInterfaceFilter(String ipAddress) {
        if (ipAddress == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        this.ipAddress = ipAddress;
    }

    public String getSql() {
        return " (IPADDR<>'" + this.ipAddress + "' OR IPADDR IS NULL)";
    }

    public String getParamSql() {
        return " (IPADDR<>? OR IPADDR IS NULL)";
    }

    public int bindParam(PreparedStatement ps, int parameterIndex) throws SQLException {
        ps.setString(parameterIndex, this.ipAddress);
        return 1;
    }

    public String getDescription() {
        return "interfacenot=" + this.ipAddress;
    }

    public String getTextDescription() {
        return "IP address is not " + this.ipAddress;
    }

    public String toString() {
        return "<Vulnerability Negative Interface Filter: " + this.getDescription() + ">";
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public boolean equals(Object obj) {
        return this.toString().equals(obj.toString());
    }
}

