/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer.support;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.opennms.netmgt.model.OnmsNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RtcNodeModel {
    private static final DecimalFormat AVAILABILITY_FORMAT = new DecimalFormat("0.000%");
    private List<RtcNode> m_nodeList = new ArrayList<RtcNode>();

    public void addNode(RtcNode node) {
        this.m_nodeList.add(node);
    }

    public List<RtcNode> getNodeList() {
        return this.m_nodeList;
    }

    static {
        AVAILABILITY_FORMAT.setMultiplier(100);
    }

    public static class RtcNode {
        private OnmsNode m_node;
        private int m_serviceCount;
        private int m_downServiceCount;
        private double m_availability;

        public RtcNode(OnmsNode node, int serviceCount, int downServiceCount, double availability) {
            this.m_node = node;
            this.m_serviceCount = serviceCount;
            this.m_downServiceCount = downServiceCount;
            this.m_availability = availability;
        }

        public double getAvailability() {
            return this.m_availability;
        }

        public String getAvailabilityAsString() {
            return AVAILABILITY_FORMAT.format(this.m_availability);
        }

        public int getDownServiceCount() {
            return this.m_downServiceCount;
        }

        public OnmsNode getNode() {
            return this.m_node;
        }

        public int getServiceCount() {
            return this.m_serviceCount;
        }

        public String toString() {
            return this.m_node.getLabel() + ": " + this.m_downServiceCount + " of " + this.m_serviceCount + ": " + this.getAvailabilityAsString();
        }
    }
}

