/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opennms.netmgt.config.surveillanceViews.Category;
import org.opennms.netmgt.config.surveillanceViews.ColumnDef;
import org.opennms.netmgt.config.surveillanceViews.RowDef;
import org.opennms.netmgt.config.surveillanceViews.View;
import org.opennms.netmgt.dao.CategoryDao;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.dao.SurveillanceViewConfigDao;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.web.Util;
import org.opennms.web.svclayer.AggregateStatus;
import org.opennms.web.svclayer.ProgressMonitor;
import org.opennms.web.svclayer.SimpleWebTable;
import org.opennms.web.svclayer.SurveillanceService;
import org.springframework.orm.ObjectRetrievalFailureException;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSurveillanceService
implements SurveillanceService {
    private NodeDao m_nodeDao;
    private CategoryDao m_categoryDao;
    private SurveillanceViewConfigDao m_surveillanceConfigDao;

    public SimpleWebTable createSurveillanceTable() {
        return this.createSurveillanceTable("default", new ProgressMonitor());
    }

    @Override
    public SimpleWebTable createSurveillanceTable(String surveillanceViewName, ProgressMonitor progressMonitor) {
        surveillanceViewName = surveillanceViewName == null ? this.m_surveillanceConfigDao.getDefaultView().getName() : surveillanceViewName;
        View view = this.m_surveillanceConfigDao.getView(surveillanceViewName);
        SurveillanceView sView = new SurveillanceView(surveillanceViewName, this.m_surveillanceConfigDao, this.m_categoryDao);
        progressMonitor.setPhaseCount(sView.getRowCount() + sView.getColumnCount() + 2);
        SimpleWebTable webTable = new SimpleWebTable();
        webTable.setTitle(view.getName());
        webTable.addColumn("Nodes Down", "simpleWebTableHeader");
        for (int colIndex = 0; colIndex < sView.getColumnCount(); ++colIndex) {
            webTable.addColumn(sView.getColumnLabel(colIndex), "simpleWebTableHeader").setLink(this.computeReportCategoryLink(sView.getColumnReportCategory(colIndex)));
        }
        CellStatusStrategy strategy = new CellStatusStrategy();
        AggregateStatus[][] cellStatus = strategy.calculateCellStatus(sView, progressMonitor);
        progressMonitor.beginNextPhase("Calculating Status Values");
        for (int rowIndex = 0; rowIndex < sView.getRowCount(); ++rowIndex) {
            webTable.newRow();
            webTable.addCell(sView.getRowLabel(rowIndex), "simpleWebTableRowLabel").setLink(this.computeReportCategoryLink(sView.getRowReportCategory(rowIndex)));
            for (int colIndex = 0; colIndex < sView.getColumnCount(); ++colIndex) {
                AggregateStatus aggStatus = cellStatus[rowIndex][colIndex];
                SimpleWebTable.Cell cell = webTable.addCell(aggStatus.getDownEntityCount() + " of " + aggStatus.getTotalEntityCount(), aggStatus.getStatus());
                if (aggStatus.getDownEntityCount() <= 0) continue;
                cell.setLink(this.createNodePageUrl(sView, colIndex, rowIndex));
            }
        }
        progressMonitor.finished(webTable);
        return webTable;
    }

    private String computeReportCategoryLink(String reportCategory) {
        String link = null;
        if (reportCategory != null) {
            link = "rtc/category.jsp?category=" + Util.encode(reportCategory);
        }
        return link;
    }

    private String createNodePageUrl(SurveillanceView view, int colIndex, int rowIndex) {
        Set<OnmsCategory> columns = view.getCategoriesForColumn(colIndex);
        Set<OnmsCategory> rows = view.getCategoriesForRow(rowIndex);
        ArrayList<String> params = new ArrayList<String>(columns.size() + rows.size());
        for (OnmsCategory category : columns) {
            params.add("category1=" + Util.encode(category.getName()));
        }
        for (OnmsCategory category : rows) {
            params.add("category2=" + Util.encode(category.getName()));
        }
        params.add("nodesWithDownAggregateStatus=true");
        return "element/nodeList.htm?" + StringUtils.collectionToDelimitedString(params, (String)"&");
    }

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    public CategoryDao getCategoryDao() {
        return this.m_categoryDao;
    }

    public void setCategoryDao(CategoryDao categoryDao) {
        this.m_categoryDao = categoryDao;
    }

    public SurveillanceViewConfigDao getSurveillanceConfigDao() {
        return this.m_surveillanceConfigDao;
    }

    public void setSurveillanceConfigDao(SurveillanceViewConfigDao surveillanceConfigDao) {
        this.m_surveillanceConfigDao = surveillanceConfigDao;
    }

    @Override
    public String getHeaderRefreshSeconds(String viewName) {
        viewName = viewName == null ? this.m_surveillanceConfigDao.getDefaultView().getName() : viewName;
        return this.m_surveillanceConfigDao.getView(viewName).getRefreshSeconds();
    }

    @Override
    public boolean isViewName(String viewName) {
        View view = viewName == null ? this.m_surveillanceConfigDao.getDefaultView() : this.m_surveillanceConfigDao.getView(viewName);
        return view != null;
    }

    @Override
    public List<String> getViewNames() {
        ArrayList<String> viewNames = new ArrayList<String>(this.m_surveillanceConfigDao.getViews().getViewCount());
        for (View view : this.getViewCollection()) {
            viewNames.add(view.getName());
        }
        Collections.sort(viewNames);
        return viewNames;
    }

    private Collection<View> getViewCollection() {
        return this.m_surveillanceConfigDao.getViews().getViewCollection();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SurveillanceView {
        private SurveillanceViewConfigDao m_surveillanceConfigDao;
        private CategoryDao m_categoryDao;
        private View m_view;

        public SurveillanceView(String viewName, SurveillanceViewConfigDao surveillanceConfigDao, CategoryDao categoryDao) {
            this.m_surveillanceConfigDao = surveillanceConfigDao;
            this.m_categoryDao = categoryDao;
            this.m_view = this.m_surveillanceConfigDao.getView(viewName);
        }

        public int getRowCount() {
            return this.m_view.getRows().getRowDefCount();
        }

        public int getColumnCount() {
            return this.m_view.getColumns().getColumnDefCount();
        }

        public Set<OnmsCategory> getCategoriesForRow(int rowIndex) {
            return this.getOnmsCategoriesFromViewCategories(this.getRowDef(rowIndex).getCategoryCollection());
        }

        private RowDef getRowDef(int rowIndex) {
            return this.m_view.getRows().getRowDef(rowIndex);
        }

        public Set<OnmsCategory> getCategoriesForColumn(int colIndex) {
            return this.getOnmsCategoriesFromViewCategories(this.getColumnDef(colIndex).getCategoryCollection());
        }

        private ColumnDef getColumnDef(int colIndex) {
            return this.m_view.getColumns().getColumnDef(colIndex);
        }

        private Set<OnmsCategory> getOnmsCategoriesFromViewCategories(Collection<Category> viewCats) {
            HashSet<OnmsCategory> categories = new HashSet<OnmsCategory>();
            for (Category viewCat : viewCats) {
                OnmsCategory category = this.m_categoryDao.findByName(viewCat.getName());
                if (category == null) {
                    throw new ObjectRetrievalFailureException(OnmsCategory.class, (Object)viewCat.getName(), "Unable to locate OnmsCategory named: " + viewCat.getName() + " as specified in the surveillance view configuration file", null);
                }
                categories.add(category);
            }
            return categories;
        }

        public String getRowLabel(int rowIndex) {
            return this.getRowDef(rowIndex).getLabel();
        }

        public String getColumnLabel(int colIndex) {
            return this.getColumnDef(colIndex).getLabel();
        }

        public String getColumnReportCategory(int colIndex) {
            return this.getColumnDef(colIndex).getReportCategory();
        }

        public String getRowReportCategory(int rowIndex) {
            return this.getRowDef(rowIndex).getReportCategory();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CellStatusStrategy {
        CellStatusStrategy() {
        }

        Collection<OnmsNode> getNodesInCategories(Set<OnmsCategory> categories) {
            return DefaultSurveillanceService.this.m_nodeDao.findAllByCategoryList(categories);
        }

        AggregateStatus[][] calculateCellStatus(SurveillanceView sView, ProgressMonitor progressMonitor) {
            ArrayList<Collection<OnmsNode>> nodesByRowIndex = new ArrayList<Collection<OnmsNode>>();
            ArrayList<Collection<OnmsNode>> nodesByColIndex = new ArrayList<Collection<OnmsNode>>();
            for (int rowIndex = 0; rowIndex < sView.getRowCount(); ++rowIndex) {
                progressMonitor.beginNextPhase("Loading nodes for row '" + sView.getRowLabel(rowIndex) + "'");
                Collection<OnmsNode> nodesForRow = this.getNodesInCategories(sView.getCategoriesForRow(rowIndex));
                nodesByRowIndex.add(rowIndex, nodesForRow);
            }
            for (int colIndex = 0; colIndex < sView.getColumnCount(); ++colIndex) {
                progressMonitor.beginNextPhase("Loading nodes for column '" + sView.getColumnLabel(colIndex) + "'");
                Collection<OnmsNode> nodesForCol = this.getNodesInCategories(sView.getCategoriesForColumn(colIndex));
                nodesByColIndex.add(colIndex, nodesForCol);
            }
            AggregateStatus[][] cellStatus = new AggregateStatus[sView.getRowCount()][sView.getColumnCount()];
            progressMonitor.beginNextPhase("Intersecting rows and columns");
            for (int rowIndex = 0; rowIndex < sView.getRowCount(); ++rowIndex) {
                Collection nodesForRow = (Collection)nodesByRowIndex.get(rowIndex);
                for (int colIndex = 0; colIndex < sView.getColumnCount(); ++colIndex) {
                    Collection nodesForCol = (Collection)nodesByColIndex.get(colIndex);
                    HashSet<OnmsNode> cellNodes = new HashSet<OnmsNode>(nodesForRow);
                    cellNodes.retainAll(nodesForCol);
                    cellStatus[rowIndex][colIndex] = new AggregateStatus(cellNodes);
                }
            }
            return cellStatus;
        }
    }
}

