/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer.support;

import java.io.Serializable;
import java.util.List;
import org.opennms.netmgt.dao.ResourceDao;
import org.opennms.netmgt.dao.StatisticsReportDao;
import org.opennms.netmgt.model.StatisticsReport;
import org.opennms.netmgt.model.StatisticsReportData;
import org.opennms.web.command.StatisticsReportCommand;
import org.opennms.web.svclayer.StatisticsReportService;
import org.opennms.web.svclayer.support.StatisticsReportModel;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.orm.ObjectRetrievalFailureException;
import org.springframework.util.Assert;
import org.springframework.validation.BindException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultStatisticsReportService
implements StatisticsReportService,
InitializingBean {
    private StatisticsReportDao m_statisticsReportDao;
    private ResourceDao m_resourceDao;

    @Override
    public List<StatisticsReport> getStatisticsReports() {
        return this.m_statisticsReportDao.findAll();
    }

    @Override
    public StatisticsReportModel getReport(StatisticsReportCommand command, BindException errors) {
        StatisticsReportModel model = new StatisticsReportModel();
        model.setErrors(errors);
        if (errors.hasErrors()) {
            return model;
        }
        Assert.notNull((Object)command.getId(), (String)"id property on command object cannot be null");
        StatisticsReport report = (StatisticsReport)this.m_statisticsReportDao.load((Serializable)command.getId());
        model.setReport(report);
        this.m_statisticsReportDao.initialize((Object)report);
        this.m_statisticsReportDao.initialize((Object)report.getData());
        for (StatisticsReportData datum : report.getData()) {
            StatisticsReportModel.Datum d = new StatisticsReportModel.Datum();
            d.setValue(datum.getValue());
            try {
                d.setResource(this.m_resourceDao.loadResourceById(datum.getResourceId()));
            }
            catch (ObjectRetrievalFailureException e) {
                d.setResourceThrowable(e);
            }
            model.addData(d);
        }
        return model;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.m_statisticsReportDao != null ? 1 : 0) != 0, (String)"property statisticsReportDao must be set to a non-null value");
        Assert.state((this.m_resourceDao != null ? 1 : 0) != 0, (String)"property resourceDao must be set to a non-null value");
    }

    public StatisticsReportDao getStatisticsReportDao() {
        return this.m_statisticsReportDao;
    }

    public void setStatisticsReportDao(StatisticsReportDao statisticsReportDao) {
        this.m_statisticsReportDao = statisticsReportDao;
    }

    public ResourceDao getResourceDao() {
        return this.m_resourceDao;
    }

    public void setResourceDao(ResourceDao resourceDao) {
        this.m_resourceDao = resourceDao;
    }
}

