/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer.support;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.type.StringType;
import org.hibernate.type.Type;
import org.opennms.core.utils.IPSorter;
import org.opennms.netmgt.config.siteStatusViews.Category;
import org.opennms.netmgt.config.siteStatusViews.RowDef;
import org.opennms.netmgt.config.siteStatusViews.Rows;
import org.opennms.netmgt.config.siteStatusViews.View;
import org.opennms.netmgt.dao.CategoryDao;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.model.OnmsArpInterface;
import org.opennms.netmgt.model.OnmsCriteria;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsRestrictions;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.web.command.NodeListCommand;
import org.opennms.web.svclayer.AggregateStatus;
import org.opennms.web.svclayer.NodeListService;
import org.opennms.web.svclayer.dao.SiteStatusViewConfigDao;
import org.opennms.web.svclayer.support.NodeListModel;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultNodeListService
implements NodeListService,
InitializingBean {
    private static final Comparator<OnmsIpInterface> IP_INTERFACE_COMPARATOR = new IpInterfaceComparator();
    private static final Comparator<OnmsArpInterface> ARP_INTERFACE_COMPARATOR = new ArpInterfaceComparator();
    private static final Comparator<OnmsSnmpInterface> SNMP_INTERFACE_COMPARATOR = new SnmpInterfaceComparator();
    private NodeDao m_nodeDao;
    private CategoryDao m_categoryDao;
    private SiteStatusViewConfigDao m_siteStatusViewConfigDao;

    @Override
    public NodeListModel createNodeList(NodeListCommand command) {
        Collection<Object> onmsNodes = null;
        OnmsCriteria criteria = new OnmsCriteria(OnmsNode.class, "node");
        criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        criteria.add((Criterion)Restrictions.ne((String)"node.type", (Object)"D"));
        this.addCriteriaForCommand(criteria, command);
        criteria.addOrder(Order.asc((String)"node.label"));
        onmsNodes = this.m_nodeDao.findMatching(criteria);
        if (command.getNodesWithDownAggregateStatus()) {
            AggregateStatus as = new AggregateStatus(onmsNodes);
            onmsNodes = as.getDownNodes();
        }
        return this.createModelForNodes(command, onmsNodes);
    }

    private void addCriteriaForCommand(OnmsCriteria criteria, NodeListCommand command) {
        if (command.hasNodename()) {
            this.addCriteriaForNodename(criteria, command.getNodename());
        } else if (command.hasNodeId()) {
            this.addCriteriaForNodeId(criteria, command.getNodeId());
        } else if (command.hasIplike()) {
            this.addCriteriaForIpLike(criteria, command.getIplike());
        } else if (command.hasService()) {
            this.addCriteriaForService(criteria, command.getService());
        } else if (command.hasMaclike()) {
            this.addCriteriaForMaclike(criteria, command.getMaclike());
        } else if (command.hasSnmpParm() && command.hasSnmpParmValue() && command.hasSnmpParmMatchType()) {
            this.addCriteriaForSnmpParm(criteria, command.getSnmpParm(), command.getSnmpParmValue(), command.getSnmpParmMatchType());
        } else if (command.hasCategory1() && command.hasCategory2()) {
            this.addCriteriaForCategories(criteria, command.getCategory1(), command.getCategory2());
        } else if (command.hasCategory1()) {
            this.addCriteriaForCategories(criteria, new String[][]{command.getCategory1()});
        } else if (command.hasStatusViewName() && command.hasStatusSite() && command.hasStatusRowLabel()) {
            this.addCriteriaForSiteStatusView(criteria, command.getStatusViewName(), command.getStatusSite(), command.getStatusRowLabel());
        } else if (command.hasForeignSource()) {
            this.addCriteriaForForeignSource(criteria, command.getForeignSource());
        }
        if (command.getNodesWithOutages()) {
            this.addCriteriaForCurrentOutages(criteria);
        }
    }

    private void addCriteriaForSnmpParm(OnmsCriteria criteria, String snmpParm, String snmpParmValue, String snmpParmMatchType) {
        criteria.createAlias("node.ipInterfaces", "ipInterface");
        criteria.add((Criterion)Restrictions.ne((String)"ipInterface.isManaged", (Object)"D"));
        criteria.createAlias("node.snmpInterfaces", "snmpInterface");
        criteria.add((Criterion)Restrictions.ne((String)"snmpInterface.collect", (Object)"D"));
        if (snmpParmMatchType.equals("contains")) {
            criteria.add(Restrictions.ilike((String)"snmpInterface.".concat(snmpParm), (String)snmpParmValue, (MatchMode)MatchMode.ANYWHERE));
        } else if (snmpParmMatchType.equals("equals")) {
            snmpParmValue = snmpParmValue.toLowerCase();
            criteria.add(Restrictions.sqlRestriction((String)("{alias}.nodeid in (select nodeid from snmpinterface where snmpcollect != 'D' and lower(snmp" + snmpParm + ") = '" + snmpParmValue + "')")));
        }
    }

    private void addCriteriaForCurrentOutages(OnmsCriteria criteria) {
        criteria.add(Restrictions.sqlRestriction((String)"{alias}.nodeId in (select o.nodeId from outages o where o.ifregainedservice is null and o.suppresstime is null or o.suppresstime < now())"));
    }

    private void addCriteriaForNodename(OnmsCriteria criteria, String nodeName) {
        criteria.add(Restrictions.ilike((String)"node.label", (String)nodeName, (MatchMode)MatchMode.ANYWHERE));
    }

    private void addCriteriaForNodeId(OnmsCriteria criteria, int nodeId) {
        criteria.add(Restrictions.idEq((Object)nodeId));
    }

    private void addCriteriaForForeignSource(OnmsCriteria criteria, String foreignSource) {
        criteria.add(Restrictions.ilike((String)"node.foreignSource", (String)foreignSource, (MatchMode)MatchMode.ANYWHERE));
    }

    private void addCriteriaForIpLike(OnmsCriteria criteria, String iplike) {
        OnmsCriteria ipInterface = criteria.createCriteria("node.ipInterfaces", "ipInterface");
        ipInterface.add((Criterion)Restrictions.ne((String)"isManaged", (Object)"D"));
        ipInterface.add(OnmsRestrictions.ipLike((String)iplike));
    }

    private void addCriteriaForService(OnmsCriteria criteria, int serviceId) {
        criteria.createAlias("node.ipInterfaces", "ipInterface");
        criteria.add((Criterion)Restrictions.ne((String)"ipInterface.isManaged", (Object)"D"));
        criteria.createAlias("node.ipInterfaces.monitoredServices", "monitoredService");
        criteria.createAlias("node.ipInterfaces.monitoredServices.serviceType", "serviceType");
        criteria.add((Criterion)Restrictions.eq((String)"serviceType.id", (Object)serviceId));
        criteria.add((Criterion)Restrictions.ne((String)"monitoredService.status", (Object)"D"));
    }

    private void addCriteriaForMaclike(OnmsCriteria criteria, String macLike) {
        String macLikeStripped = macLike.replaceAll("[:-]", "");
        criteria.createAlias("node.snmpInterfaces", "snmpInterface", 1);
        criteria.createAlias("node.arpInterfaces", "arpInterface", 1);
        Disjunction physAddrDisjunction = Restrictions.disjunction();
        physAddrDisjunction.add(Restrictions.ilike((String)"snmpInterface.physAddr", (String)macLikeStripped, (MatchMode)MatchMode.ANYWHERE));
        physAddrDisjunction.add(Restrictions.ilike((String)"arpInterface.physAddr", (String)macLikeStripped, (MatchMode)MatchMode.ANYWHERE));
        criteria.add((Criterion)physAddrDisjunction);
    }

    private void addCriteriaForCategories(OnmsCriteria criteria, String[] ... categories) {
        Assert.notNull((Object)criteria, (String)"criteria argument must not be null");
        for (Criterion criterion : this.m_categoryDao.getCriterionForCategorySetsUnion(categories)) {
            criteria.add(criterion);
        }
    }

    private void addCriteriaForSiteStatusView(OnmsCriteria criteria, String statusViewName, String statusSite, String rowLabel) {
        View view = this.m_siteStatusViewConfigDao.getView(statusViewName);
        RowDef rowDef = this.getRowDef(view, rowLabel);
        Set<String> categoryNames = this.getCategoryNamesForRowDef(rowDef);
        this.addCriteriaForCategories(criteria, new String[][]{categoryNames.toArray(new String[categoryNames.size()])});
        String sql = "{alias}.nodeId in (select nodeId from assets where " + view.getColumnName() + " = ?)";
        criteria.add(Restrictions.sqlRestriction((String)sql, (Object)statusSite, (Type)new StringType()));
    }

    private RowDef getRowDef(View view, String rowLabel) {
        Rows rows = view.getRows();
        List rowDefs = rows.getRowDefCollection();
        for (RowDef rowDef : rowDefs) {
            if (!rowDef.getLabel().equals(rowLabel)) continue;
            return rowDef;
        }
        throw new DataRetrievalFailureException("Unable to locate row: " + rowLabel + " for status view: " + view.getName());
    }

    private Set<String> getCategoryNamesForRowDef(RowDef rowDef) {
        LinkedHashSet<String> categories = new LinkedHashSet<String>();
        List cats = rowDef.getCategoryCollection();
        for (Category cat : cats) {
            categories.add(cat.getName());
        }
        return categories;
    }

    private NodeListModel createModelForNodes(NodeListCommand command, Collection<OnmsNode> onmsNodes) {
        int interfaceCount = 0;
        LinkedList<NodeListModel.NodeModel> displayNodes = new LinkedList<NodeListModel.NodeModel>();
        for (OnmsNode node : onmsNodes) {
            LinkedList<OnmsIpInterface> displayInterfaces = new LinkedList<OnmsIpInterface>();
            LinkedList<OnmsArpInterface> displayArpInterfaces = new LinkedList<OnmsArpInterface>();
            LinkedList<OnmsSnmpInterface> displaySnmpInterfaces = new LinkedList<OnmsSnmpInterface>();
            if (command.getListInterfaces()) {
                if (command.hasSnmpParm() && command.getSnmpParmMatchType().equals("contains")) {
                    String parmValueMatchString = ".*" + command.getSnmpParmValue().toLowerCase().replaceAll("([\\W])", "\\\\$0").replaceAll("\\\\%", ".*").replaceAll("_", ".") + ".*";
                    if (command.getSnmpParm().equals("ifAlias")) {
                        for (OnmsSnmpInterface snmpIntf : node.getSnmpInterfaces()) {
                            if (snmpIntf == null || "D".equals(snmpIntf.getCollect()) || snmpIntf.getIfAlias() == null || !snmpIntf.getIfAlias().toLowerCase().matches(parmValueMatchString)) continue;
                            displaySnmpInterfaces.add(snmpIntf);
                        }
                    } else if (command.getSnmpParm().equals("ifName")) {
                        for (OnmsSnmpInterface snmpIntf : node.getSnmpInterfaces()) {
                            if (snmpIntf == null || "D".equals(snmpIntf.getCollect()) || snmpIntf.getIfName() == null || !snmpIntf.getIfName().toLowerCase().matches(parmValueMatchString)) continue;
                            displaySnmpInterfaces.add(snmpIntf);
                        }
                    } else if (command.getSnmpParm().equals("ifDescr")) {
                        for (OnmsSnmpInterface snmpIntf : node.getSnmpInterfaces()) {
                            if (snmpIntf == null || "D".equals(snmpIntf.getCollect()) || snmpIntf.getIfDescr() == null || !snmpIntf.getIfDescr().toLowerCase().matches(parmValueMatchString)) continue;
                            displaySnmpInterfaces.add(snmpIntf);
                        }
                    }
                } else if (command.hasSnmpParm() && command.getSnmpParmMatchType().equals("equals")) {
                    if (command.getSnmpParm().equals("ifAlias")) {
                        for (OnmsSnmpInterface snmpIntf : node.getSnmpInterfaces()) {
                            if (snmpIntf == null || "D".equals(snmpIntf.getCollect()) || snmpIntf.getIfAlias() == null || !snmpIntf.getIfAlias().equalsIgnoreCase(command.getSnmpParmValue())) continue;
                            displaySnmpInterfaces.add(snmpIntf);
                        }
                    } else if (command.getSnmpParm().equals("ifName")) {
                        for (OnmsSnmpInterface snmpIntf : node.getSnmpInterfaces()) {
                            if (snmpIntf == null || "D".equals(snmpIntf.getCollect()) || snmpIntf.getIfName() == null || !snmpIntf.getIfName().equalsIgnoreCase(command.getSnmpParmValue())) continue;
                            displaySnmpInterfaces.add(snmpIntf);
                        }
                    } else if (command.getSnmpParm().equals("ifDescr")) {
                        for (OnmsSnmpInterface snmpIntf : node.getSnmpInterfaces()) {
                            if (snmpIntf == null || "D".equals(snmpIntf.getCollect()) || snmpIntf.getIfDescr() == null || !snmpIntf.getIfDescr().equalsIgnoreCase(command.getSnmpParmValue())) continue;
                            displaySnmpInterfaces.add(snmpIntf);
                        }
                    }
                } else if (command.hasMaclike()) {
                    OnmsIpInterface intf;
                    String macLikeStripped = command.getMaclike().toLowerCase().replaceAll("[:-]", "");
                    for (OnmsIpInterface intf2 : node.getIpInterfaces()) {
                        if (intf2.getSnmpInterface() == null || intf2.getSnmpInterface().getPhysAddr() == null || !intf2.getSnmpInterface().getPhysAddr().toLowerCase().contains(macLikeStripped)) continue;
                        displayInterfaces.add(intf2);
                    }
                    for (OnmsSnmpInterface snmpIntf : node.getSnmpInterfaces()) {
                        if (snmpIntf.getPhysAddr() == null || "D".equals(snmpIntf.getCollect()) || !snmpIntf.getPhysAddr().toLowerCase().contains(macLikeStripped) || (intf = node.getIpInterfaceByIpAddress(snmpIntf.getIpAddress())) != null) continue;
                        displaySnmpInterfaces.add(snmpIntf);
                    }
                    for (OnmsArpInterface aint : node.getArpInterfaces()) {
                        if (aint.getPhysAddr() == null || !aint.getPhysAddr().toLowerCase().contains(macLikeStripped) || (intf = node.getIpInterfaceByIpAddress(aint.getIpAddress())) != null && intf.getSnmpInterface() != null && intf.getSnmpInterface().getPhysAddr() != null && intf.getSnmpInterface().getPhysAddr().equalsIgnoreCase(aint.getPhysAddr())) continue;
                        displayArpInterfaces.add(aint);
                    }
                } else {
                    for (OnmsIpInterface intf : node.getIpInterfaces()) {
                        if ("D".equals(intf.getIsManaged()) || "0.0.0.0".equals(intf.getIpAddress())) continue;
                        displayInterfaces.add(intf);
                    }
                }
            }
            Collections.sort(displayInterfaces, IP_INTERFACE_COMPARATOR);
            Collections.sort(displayArpInterfaces, ARP_INTERFACE_COMPARATOR);
            Collections.sort(displaySnmpInterfaces, SNMP_INTERFACE_COMPARATOR);
            displayNodes.add(new NodeListModel.NodeModel(node, displayInterfaces, displayArpInterfaces, displaySnmpInterfaces));
            interfaceCount += displayInterfaces.size();
            interfaceCount += displayArpInterfaces.size();
            interfaceCount += displaySnmpInterfaces.size();
        }
        return new NodeListModel(displayNodes, interfaceCount);
    }

    public CategoryDao getCategoryDao() {
        return this.m_categoryDao;
    }

    public void setCategoryDao(CategoryDao categoryDao) {
        this.m_categoryDao = categoryDao;
    }

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    public SiteStatusViewConfigDao getSiteStatusViewConfigDao() {
        return this.m_siteStatusViewConfigDao;
    }

    public void setSiteStatusViewConfigDao(SiteStatusViewConfigDao siteStatusViewConfigDao) {
        this.m_siteStatusViewConfigDao = siteStatusViewConfigDao;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.m_nodeDao != null ? 1 : 0) != 0, (String)"nodeDao property cannot be null");
        Assert.state((this.m_categoryDao != null ? 1 : 0) != 0, (String)"categoryDao property cannot be null");
        Assert.state((this.m_siteStatusViewConfigDao != null ? 1 : 0) != 0, (String)"siteStatusViewConfigDao property cannot be null");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ArpInterfaceComparator
    implements Comparator<OnmsArpInterface>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(OnmsArpInterface o1, OnmsArpInterface o2) {
            if (!"0.0.0.0".equals(o1.getIpAddress()) && !"0.0.0.0".equals(o2.getIpAddress())) {
                if (IPSorter.convertToLong((String)o1.getIpAddress()) > IPSorter.convertToLong((String)o2.getIpAddress())) {
                    return 1;
                }
                if (IPSorter.convertToLong((String)o1.getIpAddress()) < IPSorter.convertToLong((String)o2.getIpAddress())) {
                    return -1;
                }
                return 0;
            }
            if (!"0.0.0.0".equals(o1.getIpAddress())) {
                return -1;
            }
            if (!"0.0.0.0".equals(o2.getIpAddress())) {
                return 1;
            }
            if (o1.getPhysAddr() == null || o2.getPhysAddr() == null) {
                if (o1.getPhysAddr() != null) {
                    return -1;
                }
                if (o2.getPhysAddr() != null) {
                    return 1;
                }
            } else {
                int diff = o1.getPhysAddr().compareTo(o2.getPhysAddr());
                if (diff != 0) {
                    return diff;
                }
            }
            return o1.getId().compareTo(o2.getId());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SnmpInterfaceComparator
    implements Comparator<OnmsSnmpInterface>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(OnmsSnmpInterface o1, OnmsSnmpInterface o2) {
            int diff;
            if (o1.getIfName() == null || o2.getIfName() == null) {
                if (o1.getIfName() != null) {
                    return -1;
                }
                if (o2.getIfName() != null) {
                    return 1;
                }
            } else {
                diff = o1.getIfName().compareTo(o2.getIfName());
                if (diff != 0) {
                    return diff;
                }
            }
            if (o1.getIfDescr() == null || o2.getIfDescr() == null) {
                if (o1.getIfDescr() != null) {
                    return -1;
                }
                if (o2.getIfDescr() != null) {
                    return 1;
                }
            } else {
                diff = o1.getIfDescr().compareTo(o2.getIfDescr());
                if (diff != 0) {
                    return diff;
                }
            }
            if ((diff = o1.getIfIndex().compareTo(o2.getIfIndex())) != 0) {
                return diff;
            }
            return o1.getId().compareTo(o2.getId());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IpInterfaceComparator
    implements Comparator<OnmsIpInterface>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(OnmsIpInterface o1, OnmsIpInterface o2) {
            int diff;
            if (!"0.0.0.0".equals(o1.getIpAddress()) && !"0.0.0.0".equals(o2.getIpAddress())) {
                if (IPSorter.convertToLong((String)o1.getIpAddress()) > IPSorter.convertToLong((String)o2.getIpAddress())) {
                    return 1;
                }
                if (IPSorter.convertToLong((String)o1.getIpAddress()) < IPSorter.convertToLong((String)o2.getIpAddress())) {
                    return -1;
                }
                return 0;
            }
            if (!"0.0.0.0".equals(o1.getIpAddress())) {
                return -1;
            }
            if (!"0.0.0.0".equals(o2.getIpAddress())) {
                return 1;
            }
            if (o1.getSnmpInterface() == null || o2.getSnmpInterface() == null) {
                if (o1.getSnmpInterface() != null) {
                    return -1;
                }
                return o1.getId().compareTo(o2.getId());
            }
            if (o1.getSnmpInterface().getIfName() == null || o2.getSnmpInterface().getIfName() == null) {
                if (o1.getSnmpInterface().getIfName() != null) {
                    return -1;
                }
                if (o2.getSnmpInterface().getIfName() != null) {
                    return 1;
                }
            } else {
                diff = o1.getSnmpInterface().getIfName().compareTo(o2.getSnmpInterface().getIfName());
                if (diff != 0) {
                    return diff;
                }
            }
            if (o1.getSnmpInterface().getIfDescr() == null || o2.getSnmpInterface().getIfDescr() == null) {
                if (o1.getSnmpInterface().getIfDescr() != null) {
                    return -1;
                }
                if (o2.getSnmpInterface().getIfDescr() != null) {
                    return 1;
                }
            } else {
                diff = o1.getSnmpInterface().getIfDescr().compareTo(o2.getSnmpInterface().getIfDescr());
                if (diff != 0) {
                    return diff;
                }
            }
            if ((diff = o1.getSnmpInterface().getIfIndex().compareTo(o2.getSnmpInterface().getIfIndex())) != 0) {
                return diff;
            }
            return o1.getId().compareTo(o2.getId());
        }
    }
}

