/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer.support;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.beanutils.MethodUtils;
import org.opennms.core.utils.PropertyPath;
import org.opennms.netmgt.dao.CategoryDao;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.dao.ServiceTypeDao;
import org.opennms.netmgt.model.OnmsAssetRecord;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventProxy;
import org.opennms.netmgt.model.events.EventProxyException;
import org.opennms.netmgt.provision.persist.ForeignSourceRepository;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.opennms.netmgt.provision.persist.requisition.RequisitionAsset;
import org.opennms.netmgt.provision.persist.requisition.RequisitionCategory;
import org.opennms.netmgt.provision.persist.requisition.RequisitionInterface;
import org.opennms.netmgt.provision.persist.requisition.RequisitionMonitoredService;
import org.opennms.netmgt.provision.persist.requisition.RequisitionNode;
import org.opennms.web.BeanUtils;
import org.opennms.web.Util;
import org.opennms.web.svclayer.ManualProvisioningService;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultManualProvisioningService
implements ManualProvisioningService {
    private ForeignSourceRepository m_deployedForeignSourceRepository;
    private ForeignSourceRepository m_pendingForeignSourceRepository;
    private NodeDao m_nodeDao;
    private CategoryDao m_categoryDao;
    private ServiceTypeDao m_serviceTypeDao;

    public void setDeployedForeignSourceRepository(ForeignSourceRepository repository) {
        this.m_deployedForeignSourceRepository = repository;
    }

    public void setPendingForeignSourceRepository(ForeignSourceRepository repository) {
        this.m_pendingForeignSourceRepository = repository;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    public void setCategoryDao(CategoryDao categoryDao) {
        this.m_categoryDao = categoryDao;
    }

    public void setServiceTypeDao(ServiceTypeDao serviceTypeDao) {
        this.m_serviceTypeDao = serviceTypeDao;
    }

    @Override
    public Requisition addCategoryToNode(String groupName, String pathToNode, String categoryName) {
        Requisition group = this.getProvisioningGroup(groupName);
        RequisitionNode node = BeanUtils.getPathValue(group, pathToNode, RequisitionNode.class);
        RequisitionCategory category = new RequisitionCategory();
        category.setName(categoryName);
        node.insertCategory(category);
        this.m_pendingForeignSourceRepository.save(group);
        return this.m_pendingForeignSourceRepository.getRequisition(groupName);
    }

    @Override
    public Requisition addAssetFieldToNode(String groupName, String pathToNode, String assetName, String assetValue) {
        Requisition group = this.getProvisioningGroup(groupName);
        RequisitionNode node = BeanUtils.getPathValue(group, pathToNode, RequisitionNode.class);
        RequisitionAsset asset = new RequisitionAsset();
        asset.setName(assetName);
        asset.setValue(assetValue);
        node.insertAsset(asset);
        this.m_pendingForeignSourceRepository.save(group);
        return this.m_pendingForeignSourceRepository.getRequisition(groupName);
    }

    @Override
    public Requisition addInterfaceToNode(String groupName, String pathToNode, String ipAddr) {
        Requisition group = this.getProvisioningGroup(groupName);
        Assert.notNull((Object)group, (String)("Group should not be Null and is null groupName: " + groupName));
        RequisitionNode node = BeanUtils.getPathValue(group, pathToNode, RequisitionNode.class);
        Assert.notNull((Object)node, (String)("Node should not be Null and pathToNode: " + pathToNode));
        String snmpPrimary = "P";
        if (node.getInterfaceCount() > 0) {
            snmpPrimary = "S";
        }
        RequisitionInterface iface = this.createInterface(ipAddr, snmpPrimary);
        node.insertInterface(iface);
        this.m_pendingForeignSourceRepository.save(group);
        return this.m_pendingForeignSourceRepository.getRequisition(groupName);
    }

    private RequisitionInterface createInterface(String ipAddr, String snmpPrimary) {
        RequisitionInterface iface = new RequisitionInterface();
        iface.setIpAddr(ipAddr);
        iface.setStatus(Integer.valueOf(1));
        iface.setSnmpPrimary(snmpPrimary);
        return iface;
    }

    @Override
    public Requisition addNewNodeToGroup(String groupName, String nodeLabel) {
        Requisition group = this.getProvisioningGroup(groupName);
        RequisitionNode node = this.createNode(nodeLabel, String.valueOf(System.currentTimeMillis()));
        node.setBuilding(groupName);
        group.insertNode(node);
        this.m_pendingForeignSourceRepository.save(group);
        return this.m_pendingForeignSourceRepository.getRequisition(groupName);
    }

    private RequisitionNode createNode(String nodeLabel, String foreignId) {
        RequisitionNode node = new RequisitionNode();
        node.setNodeLabel(nodeLabel);
        node.setForeignId(foreignId);
        return node;
    }

    @Override
    public Requisition addServiceToInterface(String groupName, String pathToInterface, String serviceName) {
        Requisition group = this.getProvisioningGroup(groupName);
        RequisitionInterface iface = BeanUtils.getPathValue(group, pathToInterface, RequisitionInterface.class);
        RequisitionMonitoredService monSvc = this.createService(serviceName);
        iface.insertMonitoredService(monSvc);
        this.m_pendingForeignSourceRepository.save(group);
        return this.m_pendingForeignSourceRepository.getRequisition(groupName);
    }

    @Override
    public Requisition getProvisioningGroup(String name) {
        Requisition deployed = this.m_deployedForeignSourceRepository.getRequisition(name);
        Requisition pending = this.m_pendingForeignSourceRepository.getRequisition(name);
        return pending == null ? deployed : pending;
    }

    @Override
    public Requisition saveProvisioningGroup(String groupName, Requisition group) {
        group.setForeignSource(groupName);
        this.m_pendingForeignSourceRepository.save(group);
        return this.m_pendingForeignSourceRepository.getRequisition(groupName);
    }

    @Override
    public Collection<String> getProvisioningGroupNames() {
        TreeSet<String> names = new TreeSet<String>();
        for (Requisition r : this.m_deployedForeignSourceRepository.getRequisitions()) {
            names.add(r.getForeignSource());
        }
        for (Requisition r : this.m_pendingForeignSourceRepository.getRequisitions()) {
            names.add(r.getForeignSource());
        }
        return names;
    }

    @Override
    public Requisition createProvisioningGroup(String name) {
        Requisition group = new Requisition();
        group.setForeignSource(name);
        this.m_pendingForeignSourceRepository.save(group);
        return this.m_pendingForeignSourceRepository.getRequisition(name);
    }

    private RequisitionMonitoredService createService(String serviceName) {
        RequisitionMonitoredService svc = new RequisitionMonitoredService();
        svc.setServiceName(serviceName);
        return svc;
    }

    @Override
    public void importProvisioningGroup(String groupName) {
        Requisition group = this.getProvisioningGroup(groupName);
        group.updateDateStamp();
        this.saveProvisioningGroup(groupName, group);
        EventProxy proxy = Util.createEventProxy();
        String url = this.m_pendingForeignSourceRepository.getRequisitionURL(groupName).toString();
        Assert.notNull((Object)url, (String)("Could not find url for group " + groupName + ".  Does it exists?"));
        EventBuilder bldr = new EventBuilder("uei.opennms.org/internal/importer/reloadImport", "Web");
        bldr.addParam("url", url);
        try {
            proxy.send(bldr.getEvent());
        }
        catch (EventProxyException e) {
            throw new DataAccessResourceFailureException("Unable to send event to import group " + groupName, (Throwable)e);
        }
    }

    @Override
    public Requisition deletePath(String groupName, String pathToDelete) {
        Requisition group = this.getProvisioningGroup(groupName);
        PropertyPath path = new PropertyPath(pathToDelete);
        Object objToDelete = path.getValue((Object)group);
        Requisition parentObject = path.getParent() == null ? group : path.getParent().getValue((Object)group);
        String propName = path.getPropertyName();
        String methodSuffix = Character.toUpperCase(propName.charAt(0)) + propName.substring(1);
        String methodName = "remove" + methodSuffix;
        try {
            MethodUtils.invokeMethod((Object)parentObject, (String)methodName, (Object[])new Object[]{objToDelete});
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Unable to find method " + methodName + " on object of type " + parentObject.getClass(), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("unable to access property " + pathToDelete, e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("an execption occurred deleting " + pathToDelete, e);
        }
        this.m_pendingForeignSourceRepository.save(group);
        return this.m_pendingForeignSourceRepository.getRequisition(groupName);
    }

    @Override
    public Collection<Requisition> getAllGroups() {
        LinkedList<Requisition> groups = new LinkedList<Requisition>();
        for (String groupName : this.getProvisioningGroupNames()) {
            groups.add(this.getProvisioningGroup(groupName));
        }
        return groups;
    }

    @Override
    public void deleteProvisioningGroup(String groupName) {
        Requisition r = this.getProvisioningGroup(groupName);
        if (r != null) {
            this.m_pendingForeignSourceRepository.delete(r);
            this.m_deployedForeignSourceRepository.delete(r);
        }
    }

    @Override
    public void deleteAllNodes(String groupName) {
        Requisition group = this.m_deployedForeignSourceRepository.getRequisition(groupName);
        if (group != null) {
            group.setNodes(new ArrayList());
            this.m_deployedForeignSourceRepository.save(group);
        }
        if ((group = this.m_pendingForeignSourceRepository.getRequisition(groupName)) != null) {
            group.setNodes(new ArrayList());
            this.m_pendingForeignSourceRepository.save(group);
        }
    }

    @Override
    public Map<String, Integer> getGroupDbNodeCounts() {
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        for (String groupName : this.getProvisioningGroupNames()) {
            counts.put(groupName, this.m_nodeDao.getNodeCountForForeignSource(groupName));
        }
        return counts;
    }

    @Override
    public Collection<String> getNodeCategoryNames() {
        LinkedList<String> names = new LinkedList<String>();
        for (OnmsCategory category : this.m_categoryDao.findAll()) {
            names.add(category.getName());
        }
        return names;
    }

    @Override
    public Collection<String> getServiceTypeNames() {
        LinkedList<String> names = new LinkedList<String>();
        for (OnmsServiceType svcType : this.m_serviceTypeDao.findAll()) {
            names.add(svcType.getName());
        }
        return names;
    }

    @Override
    public Collection<String> getAssetFieldNames() {
        return BeanUtils.getProperties(new OnmsAssetRecord());
    }
}

