/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer.support;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.opennms.netmgt.dao.LocationMonitorDao;
import org.opennms.netmgt.model.OnmsLocationMonitor;
import org.opennms.netmgt.model.OnmsMonitoringLocationDefinition;
import org.opennms.web.command.LocationMonitorIdCommand;
import org.opennms.web.svclayer.DistributedPollerService;
import org.opennms.web.svclayer.LocationMonitorListModel;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.validation.ObjectError;

public class DefaultDistributedPollerService
implements DistributedPollerService {
    private LocationMonitorDao m_locationMonitorDao;
    private OnmsLocationMonitorAreaNameComparator m_comparator = new OnmsLocationMonitorAreaNameComparator();

    public LocationMonitorListModel getLocationMonitorList() {
        List monitors = this.m_locationMonitorDao.findAll();
        Collections.sort(monitors, this.m_comparator);
        LocationMonitorListModel model = new LocationMonitorListModel();
        for (OnmsLocationMonitor monitor : monitors) {
            OnmsMonitoringLocationDefinition def = this.m_locationMonitorDao.findMonitoringLocationDefinition(monitor.getDefinitionName());
            model.addLocationMonitor(new LocationMonitorListModel.LocationMonitorModel(monitor, def));
        }
        return model;
    }

    public LocationMonitorDao getLocationMonitorDao() {
        return this.m_locationMonitorDao;
    }

    public void setLocationMonitorDao(LocationMonitorDao locationMonitorDao) {
        this.m_locationMonitorDao = locationMonitorDao;
    }

    public LocationMonitorListModel getLocationMonitorDetails(LocationMonitorIdCommand cmd, BindException errors) {
        LocationMonitorListModel model = new LocationMonitorListModel();
        model.setErrors((Errors)errors);
        if (errors.getErrorCount() > 0) {
            return model;
        }
        OnmsLocationMonitor monitor = (OnmsLocationMonitor)this.m_locationMonitorDao.load((Serializable)cmd.getMonitorId());
        OnmsMonitoringLocationDefinition def = this.m_locationMonitorDao.findMonitoringLocationDefinition(monitor.getDefinitionName());
        model.addLocationMonitor(new LocationMonitorListModel.LocationMonitorModel(monitor, def));
        return model;
    }

    public void pauseLocationMonitor(LocationMonitorIdCommand command, BindException errors) {
        if (command == null) {
            throw new IllegalStateException("command argument cannot be null");
        }
        if (errors == null) {
            throw new IllegalStateException("errors argument cannot be null");
        }
        if (errors.hasErrors()) {
            return;
        }
        OnmsLocationMonitor monitor = (OnmsLocationMonitor)this.m_locationMonitorDao.load((Serializable)command.getMonitorId());
        if (monitor.getStatus() == OnmsLocationMonitor.MonitorStatus.PAUSED) {
            errors.addError(new ObjectError(OnmsLocationMonitor.MonitorStatus.class.getName(), new String[]{"distributed.locationMonitor.alreadyPaused"}, new Object[]{command.getMonitorId()}, "Location monitor " + command.getMonitorId() + " is already paused."));
            return;
        }
        monitor.setStatus(OnmsLocationMonitor.MonitorStatus.PAUSED);
        this.m_locationMonitorDao.update((Object)monitor);
    }

    public void resumeLocationMonitor(LocationMonitorIdCommand command, BindException errors) {
        if (command == null) {
            throw new IllegalStateException("command argument cannot be null");
        }
        if (errors == null) {
            throw new IllegalStateException("errors argument cannot be null");
        }
        if (errors.hasErrors()) {
            return;
        }
        OnmsLocationMonitor monitor = (OnmsLocationMonitor)this.m_locationMonitorDao.load((Serializable)command.getMonitorId());
        if (monitor.getStatus() != OnmsLocationMonitor.MonitorStatus.PAUSED) {
            errors.addError(new ObjectError(OnmsLocationMonitor.MonitorStatus.class.getName(), new String[]{"distributed.locationMonitor.notPaused"}, new Object[]{command.getMonitorId()}, "Location monitor " + command.getMonitorId() + " is not paused."));
            return;
        }
        monitor.setStatus(OnmsLocationMonitor.MonitorStatus.STARTED);
        this.m_locationMonitorDao.update((Object)monitor);
    }

    public void deleteLocationMonitor(LocationMonitorIdCommand command, BindException errors) {
        if (command == null) {
            throw new IllegalStateException("command argument cannot be null");
        }
        if (errors == null) {
            throw new IllegalStateException("errors argument cannot be null");
        }
        if (errors.hasErrors()) {
            return;
        }
        OnmsLocationMonitor monitor = (OnmsLocationMonitor)this.m_locationMonitorDao.load((Serializable)command.getMonitorId());
        this.m_locationMonitorDao.delete((Object)monitor);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class OnmsLocationMonitorAreaNameComparator
    implements Comparator<OnmsLocationMonitor> {
        @Override
        public int compare(OnmsLocationMonitor o1, OnmsLocationMonitor o2) {
            int diff;
            OnmsMonitoringLocationDefinition def1 = null;
            OnmsMonitoringLocationDefinition def2 = null;
            if (o1.getDefinitionName() != null) {
                def1 = DefaultDistributedPollerService.this.m_locationMonitorDao.findMonitoringLocationDefinition(o1.getDefinitionName());
            }
            if (o2.getDefinitionName() != null) {
                def2 = DefaultDistributedPollerService.this.m_locationMonitorDao.findMonitoringLocationDefinition(o2.getDefinitionName());
            }
            if ((def1 == null || def1.getArea() == null) && def2 != null && def2.getArea() != null) {
                return 1;
            }
            if (def1 != null && def1.getArea() != null && (def2 == null || def2.getArea() == null)) {
                return -1;
            }
            if (def1 != null && def1.getArea() != null && def2 != null && def2.getArea() != null && (diff = def1.getArea().compareToIgnoreCase(def1.getArea())) != 0) {
                return diff;
            }
            diff = o1.getDefinitionName().compareToIgnoreCase(o2.getDefinitionName());
            if (diff != 0) {
                return diff;
            }
            return o1.getId().compareTo(o2.getId());
        }
    }
}

