/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer.outage;

import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.opennms.netmgt.dao.CategoryDao;
import org.opennms.netmgt.model.OnmsCriteria;
import org.opennms.netmgt.model.OnmsOutage;
import org.opennms.web.WebSecurityUtils;

public class OutagesFilteringView {
    private CategoryDao m_categoryDao;

    public String filterQuery(HttpServletRequest request) {
        String queryResult = "";
        Locale locale = Locale.getDefault();
        SimpleDateFormat d_format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", locale);
        if (request.getQueryString() != null) {
            StringTokenizer st = new StringTokenizer(request.getQueryString(), "&");
            while (st.hasMoreTokens()) {
                Date date;
                String temp = st.nextToken();
                String parameterName = temp.substring(0, temp.indexOf(61));
                String parameterValue = temp.substring(temp.indexOf(61) + 1, temp.length());
                if (parameterName.startsWith("nodeid")) {
                    queryResult = queryResult + " AND outages.nodeid = '" + parameterValue + "'";
                }
                if (parameterName.startsWith("not_nodeid")) {
                    queryResult = queryResult + " AND outages.nodeid <> '" + parameterValue + "'";
                }
                if (parameterName.startsWith("ipaddr")) {
                    queryResult = queryResult + " AND outages.ipaddr ='" + parameterValue + "'";
                }
                if (parameterName.startsWith("not_ipaddr")) {
                    queryResult = queryResult + " AND outages.ipaddr <> '" + parameterValue + "'";
                }
                if (parameterName.startsWith("smaller_iflostservice")) {
                    date = new Date(WebSecurityUtils.safeParseLong((String)parameterValue));
                    queryResult = queryResult + " AND outages.iflostservice < " + "'" + d_format.format(date) + "'";
                }
                if (parameterName.startsWith("bigger_iflostservice")) {
                    date = new Date(WebSecurityUtils.safeParseLong((String)parameterValue));
                    queryResult = queryResult + " AND outages.iflostservice > " + "'" + d_format.format(date) + "'";
                }
                if (parameterName.startsWith("smaller_ifregainedservice")) {
                    date = new Date(WebSecurityUtils.safeParseLong((String)parameterValue));
                    queryResult = queryResult + " AND outages.iflostservice < " + "'" + d_format.format(date) + "'";
                }
                if (!parameterName.startsWith("bigger_ifregainedservice")) continue;
                date = new Date(WebSecurityUtils.safeParseLong((String)parameterValue));
                queryResult = queryResult + " AND outages.iflostservice > " + "'" + d_format.format(date) + "'";
            }
        }
        return queryResult;
    }

    public OnmsCriteria buildCriteria(HttpServletRequest request) {
        Date date;
        OnmsCriteria criteria = new OnmsCriteria(OnmsOutage.class);
        if (request.getParameter("nodeid") != null && request.getParameter("nodeid").length() > 0) {
            criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)WebSecurityUtils.safeParseInt((String)request.getParameter("nodeid"))));
        }
        if (request.getParameter("not_nodeid") != null && request.getParameter("not_nodeid").length() > 0) {
            criteria.add((Criterion)Restrictions.ne((String)"node.id", (Object)WebSecurityUtils.safeParseInt((String)request.getParameter("not_nodeid"))));
        }
        if (request.getParameter("ipinterfaceid") != null && request.getParameter("ipinterfaceid").length() > 0) {
            criteria.add((Criterion)Restrictions.eq((String)"ipInterface.id", (Object)WebSecurityUtils.safeParseInt((String)request.getParameter("ipinterfaceid"))));
        }
        if (request.getParameter("not_ipinterfaceid") != null && request.getParameter("not_ipinterfaceid").length() > 0) {
            criteria.add((Criterion)Restrictions.ne((String)"ipInterface.id", (Object)WebSecurityUtils.safeParseInt((String)request.getParameter("not_ipinterfaceid"))));
        }
        if (request.getParameter("serviceid") != null && request.getParameter("serviceid").length() > 0) {
            criteria.add((Criterion)Restrictions.eq((String)"monitoredService.serviceType.id", (Object)WebSecurityUtils.safeParseInt((String)request.getParameter("serviceid"))));
        }
        if (request.getParameter("not_serviceid") != null && request.getParameter("not_serviceid").length() > 0) {
            criteria.add((Criterion)Restrictions.ne((String)"monitoredService.serviceType.id", (Object)WebSecurityUtils.safeParseInt((String)request.getParameter("not_serviceid"))));
        }
        if (request.getParameter("ifserviceid") != null && request.getParameter("ifserviceid").length() > 0) {
            criteria.add((Criterion)Restrictions.eq((String)"monitoredService.id", (Object)WebSecurityUtils.safeParseInt((String)request.getParameter("ifserviceid"))));
        }
        if (request.getParameter("not_ifserviceid") != null && request.getParameter("not_ifserviceid").length() > 0) {
            criteria.add((Criterion)Restrictions.ne((String)"monitoredService.id", (Object)WebSecurityUtils.safeParseInt((String)request.getParameter("not_ifserviceid"))));
        }
        if (request.getParameter("smaller_iflostservice") != null && request.getParameter("smaller_iflostservice").length() > 0) {
            date = new Date(WebSecurityUtils.safeParseLong((String)request.getParameter("smaller_iflostservice")));
            criteria.add((Criterion)Restrictions.lt((String)"ifLostService", (Object)date));
        }
        if (request.getParameter("bigger_iflostservice") != null && request.getParameter("bigger_iflostservice").length() > 0) {
            date = new Date(WebSecurityUtils.safeParseLong((String)request.getParameter("bigger_iflostservice")));
            criteria.add((Criterion)Restrictions.gt((String)"ifLostService", (Object)date));
        }
        if (request.getParameter("smaller_ifregainedservice") != null && request.getParameter("smaller_ifregainedservice").length() > 0) {
            date = new Date(WebSecurityUtils.safeParseLong((String)request.getParameter("smaller_ifregainedservice")));
            criteria.add((Criterion)Restrictions.lt((String)"ifRegainedService", (Object)date));
        }
        if (request.getParameter("bigger_ifregainedservice") != null && request.getParameter("bigger_ifregainedservice").length() > 0) {
            date = new Date(WebSecurityUtils.safeParseLong((String)request.getParameter("bigger_ifregainedservice")));
            criteria.add((Criterion)Restrictions.gt((String)"ifRegainedService", (Object)date));
        }
        if (request.getParameter("building") != null && request.getParameter("building").length() > 0) {
            criteria.createAlias("node.assetRecord", "assetRecord");
            criteria.add((Criterion)Restrictions.eq((String)"assetRecord.building", (Object)request.getParameter("building")));
        }
        if (request.getParameter("category1") != null && request.getParameter("category1").length() > 0 && request.getParameter("category2") != null && request.getParameter("category2").length() > 0) {
            for (Criterion criterion : this.m_categoryDao.getCriterionForCategorySetsUnion((String[][])new String[][]{request.getParameterValues("category1"), request.getParameterValues("category2")})) {
                criteria.add(criterion);
            }
        } else if (request.getParameter("category1") != null && request.getParameter("category1").length() > 0) {
            for (Criterion criterion : this.m_categoryDao.getCriterionForCategorySetsUnion((String[][])new String[][]{request.getParameterValues("category1")})) {
                criteria.add(criterion);
            }
        }
        if ("true".equals(request.getParameter("currentOutages"))) {
            criteria.add(Restrictions.isNull((String)"ifRegainedService"));
        }
        if ("true".equals(request.getParameter("resolvedOutages"))) {
            criteria.add(Restrictions.isNotNull((String)"ifRegainedService"));
        }
        return criteria;
    }

    public CategoryDao getCategoryDao() {
        return this.m_categoryDao;
    }

    public void setCategoryDao(CategoryDao categoryDao) {
        this.m_categoryDao = categoryDao;
    }
}

