/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer.outage;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.extremecomponents.table.bean.Column;
import org.extremecomponents.table.core.TableModel;
import org.extremecomponents.util.ExtremeUtils;

public class DateFilterPredicate
implements Predicate {
    public static final String LESS_THAN_OR_EQUAL = "<=";
    public static final String GREATER_THAN_OR_EQUAL = ">=";
    public static final String BETWEEN = "<>";
    public static final String NOT_EQUAL = "!=";
    public static final String DELIM = "\\s";
    private static final Logger logger = Logger.getLogger(DateFilterPredicate.class);
    private static final String asterisk = "*";
    private static final String emptyString = "";
    private TableModel model;

    public DateFilterPredicate(TableModel model) {
        this.model = model;
    }

    public boolean evaluate(Object bean) {
        boolean match = false;
        try {
            for (Column column : this.model.getColumnHandler().getColumns()) {
                Locale locale;
                String property;
                Object value;
                String alias = column.getAlias();
                String filterValue = this.model.getLimit().getFilterSet().getFilterValue(alias);
                if (StringUtils.isEmpty((String)filterValue) || (value = PropertyUtils.getProperty((Object)bean, (String)(property = column.getProperty()))) == null) continue;
                if (column.isDate()) {
                    locale = this.model.getLocale();
                    value = ExtremeUtils.formatDate((String)column.getParse(), (String)column.getFormat(), (Object)value, (Locale)locale);
                } else if (column.isCurrency()) {
                    locale = this.model.getLocale();
                    value = ExtremeUtils.formatNumber((String)column.getFormat(), (Object)value, (Locale)locale);
                }
                if (!this.isSearchMatch(value, filterValue, column.isDate(), column.getFormat(), this.model.getLocale())) {
                    match = false;
                    break;
                }
                match = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)"FilterPredicate.evaluate() had problems", (Throwable)e);
        }
        return match;
    }

    private boolean isSearchMatch(Object value, String search, boolean isDate, String format, Locale locale) {
        String valueStr = value.toString().toLowerCase().trim();
        if ((search = search.toLowerCase().trim()).startsWith(asterisk) && valueStr.endsWith(StringUtils.replace((String)search, (String)asterisk, (String)emptyString))) {
            return true;
        }
        if (search.endsWith(asterisk) && valueStr.startsWith(StringUtils.replace((String)search, (String)asterisk, (String)emptyString))) {
            return true;
        }
        if (isDate) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(format, locale);
            Date dateToCompare = null;
            Date dateToCompare2 = null;
            try {
                Date dateValue = dateFormat.parse(value.toString());
                String[] result = search.split(DELIM);
                String operator = result[0];
                if (operator.equals(LESS_THAN_OR_EQUAL)) {
                    dateToCompare = dateFormat.parse(result[1]);
                    return dateValue.getTime() <= dateToCompare.getTime();
                }
                if (operator.equals(GREATER_THAN_OR_EQUAL)) {
                    dateToCompare = dateFormat.parse(result[1]);
                    return dateValue.getTime() >= dateToCompare.getTime();
                }
                if (operator.equals(BETWEEN)) {
                    dateToCompare = dateFormat.parse(result[1]);
                    dateToCompare2 = dateFormat.parse(result[2]);
                    return dateValue.getTime() >= dateToCompare.getTime() && dateValue.getTime() <= dateToCompare2.getTime();
                }
                if (operator.equals(NOT_EQUAL)) {
                    dateToCompare = dateFormat.parse(result[1]);
                    return dateValue.getTime() != dateToCompare.getTime();
                }
                return StringUtils.contains((String)valueStr, (String)search);
            }
            catch (Exception e) {
                logger.error((Object)("The parse was incorrectly defined for date String [" + search + "]."));
                return StringUtils.contains((String)valueStr, (String)search);
            }
        }
        return StringUtils.contains((String)valueStr, (String)search);
    }
}

